/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.web.security.authentication.AuthenticationRequestToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class IdentityFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(IdentityFilter.class);
    private final IdentityProvider identityProvider;

    public IdentityFilter(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!servletRequest.isSecure()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (this.identityProvider == null) {
            logger.warn("Identity Filter configured with NULL identity provider. Credentials will not be extracted.");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (this.credentialsAlreadyPresent()) {
            logger.debug("Credentials already extracted for [{}], skipping credentials extraction filter using {}", (Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString(), (Object)this.identityProvider.getClass().getSimpleName());
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        logger.debug("Attempting to extract user credentials using {}", (Object)this.identityProvider.getClass().getSimpleName());
        try {
            AuthenticationRequest authenticationRequest = this.identityProvider.extractCredentials((HttpServletRequest)servletRequest);
            if (authenticationRequest != null) {
                AuthenticationRequestToken authentication = new AuthenticationRequestToken(authenticationRequest, this.identityProvider.getClass(), servletRequest.getRemoteAddr());
                logger.debug("Adding credentials claim to SecurityContext to be authenticated. Credentials extracted by {}: {}", (Object)this.identityProvider.getClass().getSimpleName(), (Object)authenticationRequest);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        catch (Exception e) {
            logger.debug("Exception occurred while extracting credentials:", (Throwable)e);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean credentialsAlreadyPresent() {
        return SecurityContextHolder.getContext().getAuthentication() != null;
    }
}

