/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.registry.web.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class UnauthorizedExceptionMapper
implements ExceptionMapper<UnauthorizedException> {
    private static final Logger logger = LoggerFactory.getLogger(UnauthorizedExceptionMapper.class);
    private static final String AUTHENTICATION_CHALLENGE_HEADER_NAME = "WWW-Authenticate";

    public Response toResponse(UnauthorizedException exception) {
        logger.info("{}. Returning {} response.", (Object)exception, (Object)Response.Status.UNAUTHORIZED);
        logger.debug("", (Throwable)exception);
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        if (exception.getWwwAuthenticateChallenge() != null) {
            response.header(AUTHENTICATION_CHALLENGE_HEADER_NAME, (Object)exception.getWwwAuthenticateChallenge());
        }
        response.entity((Object)exception.getMessage()).type("text/plain");
        return response.build();
    }
}

