/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.link;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleInfo;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoExtensionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.link.LinkableDocs;
import org.apache.nifi.registry.link.LinkableEntity;
import org.apache.nifi.registry.web.link.LinkBuilder;
import org.springframework.stereotype.Service;

@Service
public class LinkService {
    private static final String BUCKET_PATH = "buckets/{id}";
    private static final String FLOW_PATH = "buckets/{bucketId}/flows/{flowId}";
    private static final String FLOW_SNAPSHOT_PATH = "buckets/{bucketId}/flows/{flowId}/versions/{versionNumber}";
    private static final String EXTENSION_BUNDLE_PATH = "bundles/{bundleId}";
    private static final String EXTENSION_BUNDLE_VERSION_PATH = "bundles/{bundleId}/versions/{version}";
    private static final String EXTENSION_BUNDLE_VERSION_CONTENT_PATH = "bundles/{bundleId}/versions/{version}/content";
    private static final String EXTENSION_BUNDLE_VERSION_EXTENSION_PATH = "bundles/{bundleId}/versions/{version}/extensions/{name}";
    private static final String EXTENSION_BUNDLE_VERSION_EXTENSION_DOCS_PATH = "bundles/{bundleId}/versions/{version}/extensions/{name}/docs";
    private static final String EXTENSION_REPO_BUCKET_PATH = "extension-repository/{bucketName}";
    private static final String EXTENSION_REPO_GROUP_PATH = "extension-repository/{bucketName}/{groupId}";
    private static final String EXTENSION_REPO_ARTIFACT_PATH = "extension-repository/{bucketName}/{groupId}/{artifactId}";
    private static final String EXTENSION_REPO_VERSION_PATH = "extension-repository/{bucketName}/{groupId}/{artifactId}/{version}";
    private static final String EXTENSION_REPO_EXTENSION_PATH = "extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}";
    private static final String EXTENSION_REPO_EXTENSION_DOCS_PATH = "extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}/docs";
    private static final LinkBuilder<Bucket> BUCKET_LINK_BUILDER = bucket -> {
        if (bucket == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)BUCKET_PATH).resolveTemplate("id", (Object)bucket.getIdentifier()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<VersionedFlow> FLOW_LINK_BUILDER = versionedFlow -> {
        if (versionedFlow == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)FLOW_PATH).resolveTemplate("bucketId", (Object)versionedFlow.getBucketIdentifier()).resolveTemplate("flowId", (Object)versionedFlow.getIdentifier()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<VersionedFlowSnapshotMetadata> FLOW_SNAPSHOT_LINK_BUILDER = snapshotMetadata -> {
        if (snapshotMetadata == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)FLOW_SNAPSHOT_PATH).resolveTemplate("bucketId", (Object)snapshotMetadata.getBucketIdentifier()).resolveTemplate("flowId", (Object)snapshotMetadata.getFlowIdentifier()).resolveTemplate("versionNumber", (Object)snapshotMetadata.getVersion()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("content").build(new Object[0]);
    };
    private static final LinkBuilder<Bundle> EXTENSION_BUNDLE_LINK_BUILDER = extensionBundle -> {
        if (extensionBundle == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_BUNDLE_PATH).resolveTemplate("bundleId", (Object)extensionBundle.getIdentifier()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<BundleVersionMetadata> EXTENSION_BUNDLE_VERSION_LINK_BUILDER = bundleVersion -> {
        if (bundleVersion == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_BUNDLE_VERSION_PATH).resolveTemplate("bundleId", (Object)bundleVersion.getBundleId()).resolveTemplate("version", (Object)bundleVersion.getVersion()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<BundleVersion> EXTENSION_BUNDLE_VERSION_CONTENT_LINK_BUILDER = bundleVersion -> {
        if (bundleVersion == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_BUNDLE_VERSION_CONTENT_PATH).resolveTemplate("bundleId", (Object)bundleVersion.getBundle().getIdentifier()).resolveTemplate("version", (Object)bundleVersion.getVersionMetadata().getVersion()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionMetadata> EXTENSION_METADATA_LINK_BUILDER = extensionMetadata -> {
        if (extensionMetadata == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_BUNDLE_VERSION_EXTENSION_PATH).resolveTemplate("bundleId", (Object)extensionMetadata.getBundleInfo().getBundleId()).resolveTemplate("version", (Object)extensionMetadata.getBundleInfo().getVersion()).resolveTemplate("name", (Object)extensionMetadata.getName()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionMetadata> EXTENSION_METADATA_DOCS_LINK_BUILDER = extensionMetadata -> {
        if (extensionMetadata == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_BUNDLE_VERSION_EXTENSION_DOCS_PATH).resolveTemplate("bundleId", (Object)extensionMetadata.getBundleInfo().getBundleId()).resolveTemplate("version", (Object)extensionMetadata.getBundleInfo().getVersion()).resolveTemplate("name", (Object)extensionMetadata.getName()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("docs").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoBucket> EXTENSION_REPO_BUCKET_LINK_BUILDER = extensionRepoBucket -> {
        if (extensionRepoBucket == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_BUCKET_PATH).resolveTemplate("bucketName", (Object)extensionRepoBucket.getBucketName()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoGroup> EXTENSION_REPO_GROUP_LINK_BUILDER = extensionRepoGroup -> {
        if (extensionRepoGroup == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_GROUP_PATH).resolveTemplate("bucketName", (Object)extensionRepoGroup.getBucketName()).resolveTemplate("groupId", (Object)extensionRepoGroup.getGroupId()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoArtifact> EXTENSION_REPO_ARTIFACT_LINK_BUILDER = extensionRepoArtifact -> {
        if (extensionRepoArtifact == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_ARTIFACT_PATH).resolveTemplate("bucketName", (Object)extensionRepoArtifact.getBucketName()).resolveTemplate("groupId", (Object)extensionRepoArtifact.getGroupId()).resolveTemplate("artifactId", (Object)extensionRepoArtifact.getArtifactId()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoVersionSummary> EXTENSION_REPO_VERSION_LINK_BUILDER = extensionRepoVersion -> {
        if (extensionRepoVersion == null) {
            return null;
        }
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_VERSION_PATH).resolveTemplate("bucketName", (Object)extensionRepoVersion.getBucketName()).resolveTemplate("groupId", (Object)extensionRepoVersion.getGroupId()).resolveTemplate("artifactId", (Object)extensionRepoVersion.getArtifactId()).resolveTemplate("version", (Object)extensionRepoVersion.getVersion()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoExtensionMetadata> EXTENSION_REPO_EXTENSION_METADATA_LINK_BUILDER = extensionMetadata -> {
        if (extensionMetadata == null || extensionMetadata.getExtensionMetadata() == null || extensionMetadata.getExtensionMetadata().getBundleInfo() == null) {
            return null;
        }
        ExtensionMetadata metadata = extensionMetadata.getExtensionMetadata();
        BundleInfo bundleInfo = metadata.getBundleInfo();
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_EXTENSION_PATH).resolveTemplate("bucketName", (Object)bundleInfo.getBucketName()).resolveTemplate("groupId", (Object)bundleInfo.getGroupId()).resolveTemplate("artifactId", (Object)bundleInfo.getArtifactId()).resolveTemplate("version", (Object)bundleInfo.getVersion()).resolveTemplate("name", (Object)metadata.getName()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("self").build(new Object[0]);
    };
    private static final LinkBuilder<ExtensionRepoExtensionMetadata> EXTENSION_REPO_EXTENSION_METADATA_DOCS_LINK_BUILDER = extensionMetadata -> {
        if (extensionMetadata == null || extensionMetadata.getExtensionMetadata() == null || extensionMetadata.getExtensionMetadata().getBundleInfo() == null) {
            return null;
        }
        ExtensionMetadata metadata = extensionMetadata.getExtensionMetadata();
        BundleInfo bundleInfo = metadata.getBundleInfo();
        URI uri = UriBuilder.fromPath((String)EXTENSION_REPO_EXTENSION_DOCS_PATH).resolveTemplate("bucketName", (Object)bundleInfo.getBucketName()).resolveTemplate("groupId", (Object)bundleInfo.getGroupId()).resolveTemplate("artifactId", (Object)bundleInfo.getArtifactId()).resolveTemplate("version", (Object)bundleInfo.getVersion()).resolveTemplate("name", (Object)metadata.getName()).build(new Object[0]);
        return Link.fromUri((URI)uri).rel("docs").build(new Object[0]);
    };
    private static final Map<Class, LinkBuilder> LINK_BUILDERS;
    private static final Map<Class, LinkBuilder> DOCS_LINK_BUILDERS;

    public <E extends LinkableEntity> void populateLinks(E entity) {
        LinkBuilder linkBuilder = (LinkBuilder)LINK_BUILDERS.get(entity.getClass());
        if (linkBuilder == null) {
            throw new IllegalArgumentException("No LinkBuilder found for " + entity.getClass().getCanonicalName());
        }
        Link link = linkBuilder.createLink(entity);
        entity.setLink(link);
        if (entity instanceof LinkableDocs) {
            LinkBuilder docsLinkBuilder = (LinkBuilder)DOCS_LINK_BUILDERS.get(entity.getClass());
            if (docsLinkBuilder == null) {
                throw new IllegalArgumentException("No documentation LinkBuilder found for " + entity.getClass().getCanonicalName());
            }
            Link docsLink = docsLinkBuilder.createLink(entity);
            LinkableDocs docsEntity = (LinkableDocs)entity;
            docsEntity.setLinkDocs(docsLink);
        }
    }

    public <E extends LinkableEntity> void populateLinks(Iterable<E> entities) {
        if (entities == null) {
            return;
        }
        entities.forEach(e -> this.populateLinks(e));
    }

    public <E extends LinkableEntity> void populateFullLinks(E entity, URI baseUri) {
        LinkBuilder linkBuilder = (LinkBuilder)LINK_BUILDERS.get(entity.getClass());
        if (linkBuilder == null) {
            throw new IllegalArgumentException("No LinkBuilder found for " + entity.getClass().getCanonicalName());
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI cannot be null");
        }
        Link relativeLink = linkBuilder.createLink(entity);
        Link fullLink = this.getFullLink(baseUri, relativeLink);
        entity.setLink(fullLink);
        if (entity instanceof LinkableDocs) {
            LinkBuilder docsLinkBuilder = (LinkBuilder)DOCS_LINK_BUILDERS.get(entity.getClass());
            if (docsLinkBuilder == null) {
                throw new IllegalArgumentException("No documentation LinkBuilder found for " + entity.getClass().getCanonicalName());
            }
            Link relativeDocsLink = docsLinkBuilder.createLink(entity);
            Link fullDocsLink = this.getFullLink(baseUri, relativeDocsLink);
            LinkableDocs docsEntity = (LinkableDocs)entity;
            docsEntity.setLinkDocs(fullDocsLink);
        }
    }

    public <E extends LinkableEntity> void populateFullLinks(Iterable<E> entities, URI baseUri) {
        if (entities == null) {
            return;
        }
        entities.forEach(e -> this.populateFullLinks(e, baseUri));
    }

    private Link getFullLink(URI baseUri, Link relativeLink) {
        URI relativeUri = relativeLink.getUri();
        URI fullUri = UriBuilder.fromUri((URI)baseUri).path(relativeUri.getPath()).build(new Object[0]);
        return Link.fromUri((URI)fullUri).rel(relativeLink.getRel()).build(new Object[0]);
    }

    static {
        HashMap<Class, LinkBuilder> builderMap = new HashMap<Class, LinkBuilder>();
        builderMap.put(Bucket.class, BUCKET_LINK_BUILDER);
        builderMap.put(VersionedFlow.class, FLOW_LINK_BUILDER);
        builderMap.put(VersionedFlowSnapshotMetadata.class, FLOW_SNAPSHOT_LINK_BUILDER);
        builderMap.put(Bundle.class, EXTENSION_BUNDLE_LINK_BUILDER);
        builderMap.put(BundleVersionMetadata.class, EXTENSION_BUNDLE_VERSION_LINK_BUILDER);
        builderMap.put(BundleVersion.class, EXTENSION_BUNDLE_VERSION_CONTENT_LINK_BUILDER);
        builderMap.put(ExtensionMetadata.class, EXTENSION_METADATA_LINK_BUILDER);
        builderMap.put(ExtensionRepoBucket.class, EXTENSION_REPO_BUCKET_LINK_BUILDER);
        builderMap.put(ExtensionRepoGroup.class, EXTENSION_REPO_GROUP_LINK_BUILDER);
        builderMap.put(ExtensionRepoArtifact.class, EXTENSION_REPO_ARTIFACT_LINK_BUILDER);
        builderMap.put(ExtensionRepoVersionSummary.class, EXTENSION_REPO_VERSION_LINK_BUILDER);
        builderMap.put(ExtensionRepoExtensionMetadata.class, EXTENSION_REPO_EXTENSION_METADATA_LINK_BUILDER);
        LINK_BUILDERS = Collections.unmodifiableMap(builderMap);
        builderMap = new HashMap();
        builderMap.put(ExtensionMetadata.class, EXTENSION_METADATA_DOCS_LINK_BUILDER);
        builderMap.put(ExtensionRepoExtensionMetadata.class, EXTENSION_REPO_EXTENSION_METADATA_DOCS_LINK_BUILDER);
        DOCS_LINK_BUILDERS = Collections.unmodifiableMap(builderMap);
    }
}

