/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.field.Fields;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/items")
@Api(value="items", description="Retrieve items across all buckets for which the user is authorized.", authorizations={@Authorization(value="Authorization")})
public class ItemResource
extends ApplicationResource {
    @Context
    UriInfo uriInfo;

    @Autowired
    public ItemResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all items", notes="Get items across all buckets. The returned items will include only items from buckets for which the user is authorized. If the user is not authorized to any buckets, an empty list will be returned.", response=BucketItem.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated.")})
    public Response getItems() {
        List items = this.serviceFacade.getBucketItems();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)items).build();
    }

    @GET
    @Path(value="{bucketId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket items", notes="Gets the items located in the given bucket.", response=BucketItem.class, responseContainer="List", nickname="getItemsInBucket", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found.")})
    public Response getItems(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId) {
        List items = this.serviceFacade.getBucketItems(bucketId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)items).build();
    }

    @GET
    @Path(value="fields")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get item fields", notes="Retrieves the item field names for searching or sorting on bucket items.", response=Fields.class)
    public Response getAvailableBucketItemFields() {
        Set bucketFields = this.serviceFacade.getBucketItemFields();
        Fields fields = new Fields(bucketFields);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)fields).build();
    }
}

