/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.exception.ResourceNotFoundException;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersion;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.apache.nifi.registry.web.service.StreamingContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/extension-repository")
@Api(value="extension repository", description="Interact with extension bundles via the hierarchy of bucket/group/artifact/version. ", authorizations={@Authorization(value="Authorization")})
public class ExtensionRepoResource
extends ApplicationResource {
    public static final String CONTENT_DISPOSITION_HEADER = "content-disposition";

    @Autowired
    public ExtensionRepoResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo buckets", notes="Gets the names of the buckets the current user is authorized for in order to browse the repo by bucket. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionRepoBucket.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoBuckets() {
        SortedSet repoBuckets = this.serviceFacade.getExtensionRepoBuckets(this.getBaseUri());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)repoBuckets).build();
    }

    @GET
    @Path(value="{bucketName}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo groups", notes="Gets the groups in the extension repository in the given bucket. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionRepoGroup.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoGroups(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName) {
        SortedSet repoGroups = this.serviceFacade.getExtensionRepoGroups(this.getBaseUri(), bucketName);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)repoGroups).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo artifacts", notes="Gets the artifacts in the extension repository in the given bucket and group. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionRepoArtifact.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoArtifacts(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group id") String groupId) {
        SortedSet repoArtifacts = this.serviceFacade.getExtensionRepoArtifacts(this.getBaseUri(), bucketName, groupId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)repoArtifacts).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo versions", notes="Gets the versions in the extension repository for the given bucket, group, and artifact. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionRepoVersionSummary.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersions(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId) {
        SortedSet repoVersions = this.serviceFacade.getExtensionRepoVersions(this.getBaseUri(), bucketName, groupId, artifactId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)repoVersions).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo version", notes="Gets information about the version in the given bucket, group, and artifact. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionRepoVersion.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersion(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version) {
        ExtensionRepoVersion repoVersion = this.serviceFacade.getExtensionRepoVersion(this.getBaseUri(), bucketName, groupId, artifactId, version);
        return Response.ok((Object)repoVersion).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/extensions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo extensions", notes="Gets information about the extensions in the given bucket, group, artifact, and version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionMetadata.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionExtensions(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version) {
        List extensionRepoExtensions = this.serviceFacade.getExtensionRepoExtensions(this.getBaseUri(), bucketName, groupId, artifactId, version);
        return Response.ok((Object)extensionRepoExtensions).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension repo extension", notes="Gets information about the extension with the given name in the given bucket, group, artifact, and version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=Extension.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionExtension(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        Extension extension = this.serviceFacade.getExtensionRepoExtension(this.getBaseUri(), bucketName, groupId, artifactId, version, name);
        return Response.ok((Object)extension).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}/docs")
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Get extension repo extension docs", notes="Gets the documentation for the extension with the given name in the given bucket, group, artifact, and version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionExtensionDocs(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        StreamingOutput streamingOutput = this.serviceFacade.getExtensionRepoExtensionDocs(this.getBaseUri(), bucketName, groupId, artifactId, version, name);
        return Response.ok((Object)streamingOutput).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}/docs/additional-details")
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Get extension repo extension details", notes="Gets the additional details documentation for the extension with the given name in the given bucket, group, artifact, and version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionExtensionAdditionalDetailsDocs(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        StreamingOutput streamingOutput = this.serviceFacade.getExtensionRepoExtensionAdditionalDocs(this.getBaseUri(), bucketName, groupId, artifactId, version, name);
        return Response.ok((Object)streamingOutput).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/content")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Get extension repo version content", notes="Gets the binary content of the bundle with the given bucket, group, artifact, and version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=byte[].class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionContent(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version) {
        StreamingContent streamingContent = this.serviceFacade.getExtensionRepoVersionContent(bucketName, groupId, artifactId, version);
        String filename = streamingContent.getFilename();
        StreamingOutput streamingOutput = streamingContent.getOutput();
        return Response.ok((Object)streamingOutput).header(CONTENT_DISPOSITION_HEADER, (Object)("attachment; filename = " + filename)).build();
    }

    @GET
    @Path(value="{bucketName}/{groupId}/{artifactId}/{version}/sha256")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get extension repo version checksum", notes="Gets the hex representation of the SHA-256 digest for the binary content of the bundle with the given bucket, group, artifact, and version.\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionRepoVersionSha256(@PathParam(value="bucketName") @ApiParam(value="The bucket name") String bucketName, @PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version) {
        String sha256Hex = this.serviceFacade.getExtensionRepoVersionSha256(bucketName, groupId, artifactId, version);
        return Response.ok((Object)sha256Hex, (String)"text/plain").build();
    }

    @GET
    @Path(value="{groupId}/{artifactId}/{version}/sha256")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get global extension repo version checksum", notes="Gets the hex representation of the SHA-256 digest for the binary content with the given bucket, group, artifact, and version. Since the same group-artifact-version can exist in multiple buckets, this will return the checksum of the first one returned. This will be consistent since the checksum must be the same when existing in multiple buckets. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getGlobalExtensionRepoVersionSha256(@PathParam(value="groupId") @ApiParam(value="The group identifier") String groupId, @PathParam(value="artifactId") @ApiParam(value="The artifact identifier") String artifactId, @PathParam(value="version") @ApiParam(value="The version") String version) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        BundleVersionFilterParams filterParams = BundleVersionFilterParams.of((String)groupId, (String)artifactId, (String)version);
        SortedSet bundleVersions = this.serviceFacade.getBundleVersions(filterParams);
        if (bundleVersions.isEmpty()) {
            throw new ResourceNotFoundException("An extension bundle version does not exist with the specific group, artifact, and version");
        }
        BundleVersionMetadata latestVersionMetadata = null;
        for (BundleVersionMetadata versionMetadata : bundleVersions) {
            if (latestVersionMetadata != null && versionMetadata.getTimestamp() <= latestVersionMetadata.getTimestamp()) continue;
            latestVersionMetadata = versionMetadata;
        }
        return Response.ok((Object)latestVersionMetadata.getSha256(), (String)"text/plain").build();
    }
}

