/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.event.EventFactory;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.field.Fields;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.web.ClientIdParameter;
import org.apache.nifi.registry.revision.web.LongParameter;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/buckets")
@Api(value="buckets", description="Create named buckets in the registry to store NiFi objects such flows and extensions. Search for and retrieve existing buckets.", authorizations={@Authorization(value="Authorization")})
public class BucketResource
extends ApplicationResource {
    @Autowired
    public BucketResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create bucket", response=Bucket.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response createBucket(@ApiParam(value="The bucket to create", required=true) Bucket bucket) {
        Bucket createdBucket = this.serviceFacade.createBucket(bucket);
        this.publish(EventFactory.bucketCreated((Bucket)createdBucket));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdBucket).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all buckets", notes="The returned list will include only buckets for which the user is authorized.If the user is not authorized for any buckets, this returns an empty list.", response=Bucket.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated.")})
    public Response getBuckets() {
        List buckets = this.serviceFacade.getBuckets();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)buckets).build();
    }

    @GET
    @Path(value="{bucketId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket", notes="Gets the bucket with the given id.", response=Bucket.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found.")})
    public Response getBucket(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId) {
        Bucket bucket = this.serviceFacade.getBucket(bucketId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bucket).build();
    }

    @PUT
    @Path(value="{bucketId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update bucket", notes="Updates the bucket with the given id.", response=Bucket.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response updateBucket(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @ApiParam(value="The updated bucket", required=true) Bucket bucket) {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new BadRequestException("Bucket id cannot be blank");
        }
        if (bucket == null) {
            throw new BadRequestException("Bucket cannot be null");
        }
        if (bucket.getIdentifier() != null && !bucketId.equals(bucket.getIdentifier())) {
            throw new BadRequestException("Bucket id in path param must match bucket id in body");
        }
        bucket.setIdentifier(bucketId);
        Bucket updatedBucket = this.serviceFacade.updateBucket(bucket);
        this.publish(EventFactory.bucketUpdated((Bucket)updatedBucket));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)updatedBucket).build();
    }

    @DELETE
    @Path(value="{bucketId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete bucket", notes="Deletes the bucket with the given id, along with all objects stored in the bucket", response=Bucket.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="delete"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found.")})
    public Response deleteBucket(@ApiParam(value="The version is used to verify the client is working with the latest version of the entity.", required=true) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId) {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new BadRequestException("Bucket id cannot be blank");
        }
        RevisionInfo revisionInfo = this.getRevisionInfo(version, clientId);
        Bucket deletedBucket = this.serviceFacade.deleteBucket(bucketId, revisionInfo);
        this.publish(EventFactory.bucketDeleted((Bucket)deletedBucket));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)deletedBucket).build();
    }

    @GET
    @Path(value="fields")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket fields", notes="Retrieves bucket field names for searching or sorting on buckets.", response=Fields.class)
    public Response getAvailableBucketFields() {
        Set bucketFields = this.serviceFacade.getBucketFields();
        Fields fields = new Fields(bucketFields);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)fields).build();
    }
}

