/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import io.jsonwebtoken.JwtException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.CurrentUser;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.exception.AdministrationException;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.BasicAuthIdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderUsage;
import org.apache.nifi.registry.security.authentication.exception.IdentityAccessException;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.exception.UnauthorizedException;
import org.apache.nifi.registry.web.security.authentication.jwt.JwtService;
import org.apache.nifi.registry.web.security.authentication.kerberos.KerberosSpnegoIdentityProvider;
import org.apache.nifi.registry.web.security.authentication.oidc.OidcService;
import org.apache.nifi.registry.web.security.authentication.x509.X509IdentityProvider;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/access")
@Api(value="access", description="Endpoints for obtaining an access token or checking access status.")
public class AccessResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(AccessResource.class);
    private static final String OIDC_REQUEST_IDENTIFIER = "oidc-request-identifier";
    private static final String OIDC_ERROR_TITLE = "Unable to continue login sequence";
    private NiFiRegistryProperties properties;
    private JwtService jwtService;
    private OidcService oidcService;
    private X509IdentityProvider x509IdentityProvider;
    private KerberosSpnegoIdentityProvider kerberosSpnegoIdentityProvider;
    private IdentityProvider identityProvider;
    @Context
    protected UriInfo uriInfo;

    @Autowired
    public AccessResource(NiFiRegistryProperties properties, JwtService jwtService, X509IdentityProvider x509IdentityProvider, OidcService oidcService, @Nullable KerberosSpnegoIdentityProvider kerberosSpnegoIdentityProvider, @Nullable IdentityProvider identityProvider, ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
        this.properties = properties;
        this.jwtService = jwtService;
        this.x509IdentityProvider = x509IdentityProvider;
        this.oidcService = oidcService;
        this.kerberosSpnegoIdentityProvider = kerberosSpnegoIdentityProvider;
        this.identityProvider = identityProvider;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get access status", notes="Returns the current client's authenticated identity and permissions to top-level resources", response=CurrentUser.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry might be running unsecured.")})
    public Response getAccessStatus(@Context HttpServletRequest httpServletRequest) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        CurrentUser currentUser = this.serviceFacade.getCurrentUser();
        currentUser.setLoginSupported(this.isBasicLoginSupported(httpServletRequest));
        currentUser.setOIDCLoginSupported(this.isOIDCLoginSupported(httpServletRequest));
        return this.generateOkResponse((Object)currentUser).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token")
    @ApiOperation(value="Create token trying all providers", notes="Creates a token for accessing the REST API via auto-detected method of verifying client identity claim credentials. The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login with username/password."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response createAccessTokenByTryingAllProviders(@Context HttpServletRequest httpServletRequest) {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("Access tokens are only issued over HTTPS");
        }
        List identityProviderWaterfall = this.generateIdentityProviderWaterfall();
        String token = null;
        for (IdentityProvider provider : identityProviderWaterfall) {
            AuthenticationRequest authenticationRequest = provider.extractCredentials(httpServletRequest);
            if (authenticationRequest == null) continue;
            try {
                token = this.createAccessToken(provider, authenticationRequest);
                break;
            }
            catch (InvalidCredentialsException ice) {
                logger.debug("{}: the supplied client credentials are invalid.", (Object)provider.getClass().getSimpleName());
                logger.debug("", (Throwable)ice);
            }
        }
        if (StringUtils.isEmpty(token)) {
            List acceptableAuthTypes = identityProviderWaterfall.stream().map(IdentityProvider::getUsageInstructions).map(IdentityProviderUsage::getAuthType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            throw new UnauthorizedException("Client credentials are missing or invalid according to all configured identity providers.").withAuthenticateChallenge(acceptableAuthTypes);
        }
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        return this.generateCreatedResponse(uri, (Object)token).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token/login")
    @ApiOperation(value="Create token using basic auth", notes="Creates a token for accessing the REST API via username/password. The user credentials must be passed in standard HTTP Basic Auth format. That is: 'Authorization: Basic <credentials>', where <credentials> is the base64 encoded value of '<username>:<password>'. The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.", response=String.class, authorizations={@Authorization(value="BasicAuth")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login with username/password."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response createAccessTokenUsingBasicAuthCredentials(@Context HttpServletRequest httpServletRequest) {
        String token;
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("Access tokens are only issued over HTTPS");
        }
        if (this.identityProvider == null) {
            logger.debug("An Identity Provider must be configured to use this endpoint. Please consult the administration guide.");
            throw new IllegalStateException("Username/Password login not supported by this NiFi. Contact System Administrator.");
        }
        if (!(this.identityProvider instanceof BasicAuthIdentityProvider)) {
            logger.debug("An Identity Provider is configured, but it does not support HTTP Basic Auth authentication. The configured Identity Provider must extend {}", BasicAuthIdentityProvider.class);
            throw new IllegalStateException("Username/Password login not supported by this NiFi. Contact System Administrator.");
        }
        AuthenticationRequest authenticationRequest = this.identityProvider.extractCredentials(httpServletRequest);
        if (authenticationRequest == null) {
            throw new UnauthorizedException("The client credentials are missing from the request.").withAuthenticateChallenge(IdentityProviderUsage.AuthType.OTHER);
        }
        try {
            token = this.createAccessToken(this.identityProvider, authenticationRequest);
        }
        catch (InvalidCredentialsException ice) {
            throw new UnauthorizedException("The supplied client credentials are not valid.", (Throwable)ice).withAuthenticateChallenge(IdentityProviderUsage.AuthType.OTHER);
        }
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        return this.generateCreatedResponse(uri, (Object)token).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout")
    @ApiOperation(value="Performs a logout for other providers that have been issued a JWT.", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.")
    @ApiResponses(value={@ApiResponse(code=200, message="User was logged out successfully."), @ApiResponse(code=401, message="Authentication token provided was empty or not in the correct JWT format."), @ApiResponse(code=500, message="Client failed to log out.")})
    public Response logOut(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        String userIdentity = NiFiUserUtils.getNiFiUserIdentity();
        if (userIdentity != null && !userIdentity.isEmpty()) {
            try {
                logger.info("Logging out user " + userIdentity);
                this.jwtService.logOut(userIdentity);
                return this.generateOkResponse().build();
            }
            catch (JwtException e) {
                logger.error("Logout of user " + userIdentity + " failed due to: " + e.getMessage());
                return Response.serverError().build();
            }
        }
        return Response.status((int)401, (String)"Authentication token provided was empty or not in the correct JWT format.").build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token/kerberos")
    @ApiOperation(value="Create token using kerberos", notes="Creates a token for accessing the REST API via Kerberos Service Tickets or SPNEGO Tokens (which includes Kerberos Service Tickets). The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login Kerberos credentials."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response createAccessTokenUsingKerberosTicket(@Context HttpServletRequest httpServletRequest) {
        String token;
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("Access tokens are only issued over HTTPS");
        }
        if (!this.properties.isKerberosSpnegoSupportEnabled() || this.kerberosSpnegoIdentityProvider == null) {
            throw new IllegalStateException("Kerberos service ticket login not supported by this NiFi Registry");
        }
        AuthenticationRequest authenticationRequest = this.kerberosSpnegoIdentityProvider.extractCredentials(httpServletRequest);
        if (authenticationRequest == null) {
            throw new UnauthorizedException("The client credentials are missing from the request.").withAuthenticateChallenge(this.kerberosSpnegoIdentityProvider.getUsageInstructions().getAuthType());
        }
        try {
            token = this.createAccessToken((IdentityProvider)this.kerberosSpnegoIdentityProvider, authenticationRequest);
        }
        catch (InvalidCredentialsException ice) {
            throw new UnauthorizedException("The supplied client credentials are not valid.", (Throwable)ice).withAuthenticateChallenge(this.kerberosSpnegoIdentityProvider.getUsageInstructions().getAuthType());
        }
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        return this.generateCreatedResponse(uri, (Object)token).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token/identity-provider")
    @ApiOperation(value="Create token using identity provider", notes="Creates a token for accessing the REST API via a custom identity provider. The user credentials must be passed in a format understood by the custom identity provider, e.g., a third-party auth token in an HTTP header. The exact format of the user credentials expected by the custom identity provider can be discovered by 'GET /access/token/identity-provider/usage'. The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login with customized credentials."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response createAccessTokenUsingIdentityProviderCredentials(@Context HttpServletRequest httpServletRequest) {
        String token;
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("Access tokens are only issued over HTTPS");
        }
        if (this.identityProvider == null) {
            throw new IllegalStateException("Custom login not supported by this NiFi Registry");
        }
        AuthenticationRequest authenticationRequest = this.identityProvider.extractCredentials(httpServletRequest);
        if (authenticationRequest == null) {
            throw new UnauthorizedException("The client credentials are missing from the request.").withAuthenticateChallenge(this.identityProvider.getUsageInstructions().getAuthType());
        }
        try {
            token = this.createAccessToken(this.identityProvider, authenticationRequest);
        }
        catch (InvalidCredentialsException ice) {
            throw new UnauthorizedException("The supplied client credentials are not valid.", (Throwable)ice).withAuthenticateChallenge(this.identityProvider.getUsageInstructions().getAuthType());
        }
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        return this.generateCreatedResponse(uri, (Object)token).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token/identity-provider/usage")
    @ApiOperation(value="Get identity provider usage", notes="Provides a description of how the currently configured identity provider expects credentials to be passed to POST /access/token/identity-provider", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login with customized credentials."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response getIdentityProviderUsageInstructions(@Context HttpServletRequest httpServletRequest) {
        if (this.identityProvider == null) {
            throw new IllegalStateException("Custom login not supported by this NiFi Registry");
        }
        Class<?> ipClazz = this.identityProvider.getClass();
        String identityProviderName = StringUtils.isNotEmpty((CharSequence)ipClazz.getSimpleName()) ? ipClazz.getSimpleName() : ipClazz.getName();
        try {
            String usageInstructions = "Usage Instructions for '" + identityProviderName + "': ";
            usageInstructions = usageInstructions + this.identityProvider.getUsageInstructions().getText();
            return this.generateOkResponse((Object)usageInstructions).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("The currently configured identity provider, '" + this.identityProvider.getClass().getName() + "' does not provide usage instructions.")).build();
        }
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/token/identity-provider/test")
    @ApiOperation(value="Test identity provider", notes="Tests the format of the credentials against this identity provider without preforming authentication on the credentials to validate them. The user credentials should be passed in a format understood by the custom identity provider as defined by 'GET /access/token/identity-provider/usage'.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="The format of the credentials were not recognized by the currently configured identity provider."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry may not be configured to support login with customized credentials."), @ApiResponse(code=500, message="NiFi Registry was unable to complete the request because an unexpected error occurred.")})
    public Response testIdentityProviderRecognizesCredentialsFormat(@Context HttpServletRequest httpServletRequest) {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("Access tokens are only issued over HTTPS");
        }
        if (this.identityProvider == null) {
            throw new IllegalStateException("Custom login not supported by this NiFi Registry");
        }
        Class<?> ipClazz = this.identityProvider.getClass();
        String identityProviderName = StringUtils.isNotEmpty((CharSequence)ipClazz.getSimpleName()) ? ipClazz.getSimpleName() : ipClazz.getName();
        AuthenticationRequest authenticationRequest = this.identityProvider.extractCredentials(httpServletRequest);
        if (authenticationRequest == null) {
            throw new UnauthorizedException("The format of the credentials were not recognized by the currently configured identity provider '" + identityProviderName + "'. " + this.identityProvider.getUsageInstructions().getText()).withAuthenticateChallenge(this.identityProvider.getUsageInstructions().getAuthType());
        }
        String successMessage = identityProviderName + " recognized the format of the credentials in the HTTP request.";
        return this.generateOkResponse((Object)successMessage).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/oidc/request")
    @ApiOperation(value="Initiates a request to authenticate through the configured OpenId Connect provider.", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.")
    public void oidcRequest(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect is not configured.");
        }
        String oidcRequestIdentifier = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(OIDC_REQUEST_IDENTIFIER, oidcRequestIdentifier);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(60);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
        State state = this.oidcService.createState(oidcRequestIdentifier);
        URI authorizationUri = UriBuilder.fromUri((URI)this.oidcService.getAuthorizationEndpoint()).queryParam("client_id", new Object[]{this.oidcService.getClientId()}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{this.oidcService.getScope().toString()}).queryParam("state", new Object[]{state.getValue()}).queryParam("redirect_uri", new Object[]{this.getOidcCallback()}).build(new Object[0]);
        httpServletResponse.sendRedirect(authorizationUri.toString());
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/oidc/callback")
    @ApiOperation(value="Redirect/callback URI for processing the result of the OpenId Connect login sequence.", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.")
    public void oidcCallback(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        com.nimbusds.openid.connect.sdk.AuthenticationResponse oidcResponse;
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect is not configured.");
        }
        String oidcRequestIdentifier = this.getCookieValue(httpServletRequest.getCookies(), OIDC_REQUEST_IDENTIFIER);
        if (oidcRequestIdentifier == null) {
            throw new IllegalStateException("The login request identifier was not found in the request. Unable to continue.");
        }
        try {
            oidcResponse = AuthenticationResponseParser.parse((URI)this.getRequestUri());
        }
        catch (ParseException e) {
            logger.error("Unable to parse the redirect URI from the OpenId Connect Provider. Unable to continue login process.");
            this.removeOidcRequestCookie(httpServletResponse);
            throw new IllegalStateException("Unable to parse the redirect URI from the OpenId Connect Provider. Unable to continue login process.");
        }
        if (oidcResponse.indicatesSuccess()) {
            AuthenticationSuccessResponse successfulOidcResponse = (AuthenticationSuccessResponse)oidcResponse;
            State state = successfulOidcResponse.getState();
            if (state == null || !this.oidcService.isStateValid(oidcRequestIdentifier, state)) {
                logger.error("The state value returned by the OpenId Connect Provider does not match the stored state. Unable to continue login process.");
                this.removeOidcRequestCookie(httpServletResponse);
                throw new IllegalStateException("Purposed state does not match the stored state. Unable to continue login process.");
            }
            try {
                AuthorizationCode authorizationCode = successfulOidcResponse.getAuthorizationCode();
                AuthorizationCodeGrant authorizationGrant = new AuthorizationCodeGrant(authorizationCode, URI.create(this.getOidcCallback()));
                this.oidcService.exchangeAuthorizationCode(oidcRequestIdentifier, (AuthorizationGrant)authorizationGrant);
            }
            catch (Exception e) {
                logger.error("Unable to exchange authorization for ID token: " + e.getMessage(), (Throwable)e);
                this.removeOidcRequestCookie(httpServletResponse);
                throw new IllegalStateException("Unable to exchange authorization for ID token: " + e.getMessage());
            }
        } else {
            this.removeOidcRequestCookie(httpServletResponse);
            AuthenticationErrorResponse errorOidcResponse = (AuthenticationErrorResponse)oidcResponse;
            throw new IllegalStateException("Unsuccessful login attempt: " + errorOidcResponse.getErrorObject().getDescription());
        }
        httpServletResponse.sendRedirect(this.getNiFiRegistryUri());
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/oidc/exchange")
    @ApiOperation(value="Retrieves a JWT following a successful login sequence using the configured OpenId Connect provider.", response=String.class, notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.")
    public Response oidcExchange(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect is not configured.");
        }
        String oidcRequestIdentifier = this.getCookieValue(httpServletRequest.getCookies(), OIDC_REQUEST_IDENTIFIER);
        if (oidcRequestIdentifier == null) {
            throw new IllegalArgumentException("The login request identifier was not found in the request. Unable to continue.");
        }
        this.removeOidcRequestCookie(httpServletResponse);
        String jwt = this.oidcService.getJwt(oidcRequestIdentifier);
        if (jwt == null) {
            throw new IllegalArgumentException("A JWT for this login request identifier could not be found. Unable to continue.");
        }
        return this.generateOkResponse((Object)jwt).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/oidc/logout")
    @ApiOperation(value="Performs a logout in the OpenId Provider.", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.")
    public void oidcLogout(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect is not configured.");
        }
        String tokenHeader = httpServletRequest.getHeader("Authorization");
        this.jwtService.logOutUsingAuthHeader(tokenHeader);
        URI endSessionEndpoint = this.oidcService.getEndSessionEndpoint();
        String postLogoutRedirectUri = this.generateResourceUri(new String[]{"..", "nifi-registry"});
        if (endSessionEndpoint != null) {
            URI logoutUri = UriBuilder.fromUri((URI)endSessionEndpoint).queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri}).build(new Object[0]);
            httpServletResponse.sendRedirect(logoutUri.toString());
        }
    }

    private String getCookieValue(Cookie[] cookies, String name) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void setOidcService(OidcService oidcService) {
        this.oidcService = oidcService;
    }

    private String getOidcCallback() {
        return this.generateResourceUri(new String[]{"access", "oidc", "callback"});
    }

    private void removeOidcRequestCookie(HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie(OIDC_REQUEST_IDENTIFIER, null);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
    }

    protected URI getRequestUri() {
        return this.uriInfo.getRequestUri();
    }

    private String getNiFiRegistryUri() {
        String nifiRegistryApiUrl = this.generateResourceUri(new String[0]);
        String baseUrl = StringUtils.substringBeforeLast((String)nifiRegistryApiUrl, (String)"/nifi-registry-api");
        return baseUrl + "/nifi-registry";
    }

    private void forwardToMessagePage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String message) throws Exception {
        httpServletRequest.setAttribute("title", (Object)OIDC_ERROR_TITLE);
        httpServletRequest.setAttribute("messages", (Object)message);
        ServletContext uiContext = httpServletRequest.getServletContext().getContext("/nifi-registry");
        uiContext.getRequestDispatcher("/WEB-INF/pages/message-page.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String createAccessToken(IdentityProvider identityProvider, AuthenticationRequest authenticationRequest) throws InvalidCredentialsException, AdministrationException {
        try {
            AuthenticationResponse authenticationResponse = identityProvider.authenticate(authenticationRequest);
            String token = this.jwtService.generateSignedToken(authenticationResponse);
            return token;
        }
        catch (JwtException | IdentityAccessException e) {
            throw new AdministrationException(e.getMessage());
        }
    }

    private List<IdentityProvider> generateIdentityProviderWaterfall() {
        ArrayList<IdentityProvider> identityProviderWaterfall = new ArrayList<IdentityProvider>();
        if (this.x509IdentityProvider != null) {
            identityProviderWaterfall.add((IdentityProvider)this.x509IdentityProvider);
        }
        if (this.kerberosSpnegoIdentityProvider != null) {
            identityProviderWaterfall.add((IdentityProvider)this.kerberosSpnegoIdentityProvider);
        }
        if (this.identityProvider != null) {
            identityProviderWaterfall.add(this.identityProvider);
        }
        return identityProviderWaterfall;
    }

    private boolean isBasicLoginSupported(HttpServletRequest request) {
        return request.isSecure() && this.identityProvider != null;
    }

    private boolean isOIDCLoginSupported(HttpServletRequest request) {
        return request.isSecure() && this.oidcService != null && this.oidcService.isOidcEnabled();
    }
}

