/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.registry.revision.api.DeleteRevisionTask;
import org.apache.nifi.registry.revision.api.EntityModification;
import org.apache.nifi.registry.revision.api.ExpiredRevisionClaimException;
import org.apache.nifi.registry.revision.api.InvalidRevisionException;
import org.apache.nifi.registry.revision.api.Revision;
import org.apache.nifi.registry.revision.api.RevisionClaim;
import org.apache.nifi.registry.revision.api.RevisionManager;
import org.apache.nifi.registry.revision.api.RevisionUpdate;
import org.apache.nifi.registry.revision.api.UpdateResult;
import org.apache.nifi.registry.revision.api.UpdateRevisionTask;
import org.apache.nifi.registry.revision.jdbc.RevisionRowMapper;
import org.apache.nifi.registry.revision.standard.RevisionComparator;
import org.apache.nifi.registry.revision.standard.StandardRevisionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcRevisionManager
implements RevisionManager {
    private static Logger LOGGER = LoggerFactory.getLogger(JdbcRevisionManager.class);
    private final JdbcTemplate jdbcTemplate;

    public JdbcRevisionManager(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    public Revision getRevision(String entityId) {
        Revision revision = this.retrieveRevision(entityId);
        if (revision == null) {
            return this.createRevision(entityId);
        }
        return revision;
    }

    private Revision retrieveRevision(String entityId) {
        try {
            String selectSql = "SELECT * FROM REVISION WHERE ENTITY_ID = ?";
            return (Revision)this.jdbcTemplate.queryForObject("SELECT * FROM REVISION WHERE ENTITY_ID = ?", (RowMapper)new RevisionRowMapper(), new Object[]{entityId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private Revision createRevision(String entityId) {
        Revision revision = new Revision(Long.valueOf(0L), null, entityId);
        String insertSql = "INSERT INTO REVISION(ENTITY_ID, VERSION) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO REVISION(ENTITY_ID, VERSION) VALUES (?, ?)", new Object[]{revision.getEntityId(), revision.getVersion()});
        return revision;
    }

    public <T> RevisionUpdate<T> updateRevision(RevisionClaim claim, UpdateRevisionTask<T> task) {
        LOGGER.debug("Attempting to update revision using {}", (Object)claim);
        ArrayList revisionList = new ArrayList(claim.getRevisions());
        revisionList.sort(new RevisionComparator());
        HashSet<Revision> incrementedRevisions = new HashSet<Revision>();
        for (Revision incomingRevision : revisionList) {
            String entityId = incomingRevision.getEntityId();
            this.getRevision(entityId);
            this.updateRevision(incomingRevision);
            Revision incrementedRevision = this.getRevision(entityId);
            incrementedRevisions.add(incrementedRevision);
        }
        LOGGER.debug("Successfully verified Revision Claim for all revisions");
        UpdateResult updateResult = task.update();
        LOGGER.debug("Update task completed");
        Object updatedEntity = updateResult.getEntity();
        String updaterIdentity = updateResult.updaterIdentity();
        Revision updatedEntityRevision = this.getRevision(updateResult.getEntityId());
        EntityModification entityModification = new EntityModification(updatedEntityRevision, updaterIdentity);
        return new StandardRevisionUpdate(updatedEntity, entityModification, incrementedRevisions);
    }

    private void updateRevision(Revision incomingRevision) {
        String sql = "UPDATE REVISION SET VERSION = (VERSION + 1), CLIENT_ID = ? WHERE ENTITY_ID = ? AND (VERSION = ? OR CLIENT_ID = ? )";
        String entityId = incomingRevision.getEntityId();
        String clientId = incomingRevision.getClientId();
        Long version = incomingRevision.getVersion();
        int rowsUpdated = this.jdbcTemplate.update("UPDATE REVISION SET VERSION = (VERSION + 1), CLIENT_ID = ? WHERE ENTITY_ID = ? AND (VERSION = ? OR CLIENT_ID = ? )", new Object[]{clientId, entityId, version, clientId});
        if (rowsUpdated <= 0) {
            throw new InvalidRevisionException("Invalid Revision was given for entity with ID '" + entityId + "'");
        }
    }

    public <T> T deleteRevision(RevisionClaim claim, DeleteRevisionTask<T> task) throws ExpiredRevisionClaimException {
        LOGGER.debug("Attempting to delete revision using {}", (Object)claim);
        ArrayList revisionList = new ArrayList(claim.getRevisions());
        revisionList.sort(new RevisionComparator());
        for (Revision revision : revisionList) {
            this.deleteRevision(revision);
        }
        Object taskResult = task.performTask();
        LOGGER.debug("Delete task completed");
        return (T)taskResult;
    }

    private void deleteRevision(Revision revision) {
        String sql = "DELETE FROM REVISION WHERE ENTITY_ID = ? AND (VERSION = ? OR CLIENT_ID = ? )";
        String entityId = revision.getEntityId();
        String clientId = revision.getClientId();
        Long version = revision.getVersion();
        int rowsUpdated = this.jdbcTemplate.update("DELETE FROM REVISION WHERE ENTITY_ID = ? AND (VERSION = ? OR CLIENT_ID = ? )", new Object[]{entityId, version, clientId});
        if (rowsUpdated <= 0) {
            throw new ExpiredRevisionClaimException("Invalid Revision was given for entity with ID '" + entityId + "'");
        }
    }

    public void reset(Collection<Revision> revisions) {
        this.jdbcTemplate.update("DELETE FROM REVISION");
        String insertSql = "INSERT INTO REVISION(ENTITY_ID, VERSION, CLIENT_ID) VALUES (?, ?, ?)";
        for (Revision revision : revisions) {
            this.jdbcTemplate.update("INSERT INTO REVISION(ENTITY_ID, VERSION, CLIENT_ID) VALUES (?, ?, ?)", new Object[]{revision.getEntityId(), revision.getVersion(), revision.getClientId()});
        }
    }

    public List<Revision> getAllRevisions() {
        return this.jdbcTemplate.query("SELECT * FROM REVISION", (RowMapper)new RevisionRowMapper());
    }

    public Map<String, Revision> getRevisionMap() {
        HashMap<String, Revision> revisionMap = new HashMap<String, Revision>();
        RevisionRowMapper rowMapper = new RevisionRowMapper();
        this.jdbcTemplate.query("SELECT * FROM REVISION", rs -> {
            Revision revision = rowMapper.mapRow(rs, 0);
            revisionMap.put(revision.getEntityId(), revision);
        });
        return revisionMap;
    }
}

