/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.entity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.registry.revision.api.EntityModification;
import org.apache.nifi.registry.revision.api.Revision;
import org.apache.nifi.registry.revision.api.RevisionClaim;
import org.apache.nifi.registry.revision.api.RevisionManager;
import org.apache.nifi.registry.revision.api.RevisionUpdate;
import org.apache.nifi.registry.revision.entity.RevisableEntity;
import org.apache.nifi.registry.revision.entity.RevisableEntityService;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.standard.StandardRevisionClaim;
import org.apache.nifi.registry.revision.standard.StandardUpdateResult;

public class StandardRevisableEntityService
implements RevisableEntityService {
    private final RevisionManager revisionManager;

    public StandardRevisableEntityService(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    @Override
    public <T extends RevisableEntity> T create(T requestEntity, String creatorIdentity, Supplier<T> createEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Request entity is required");
        }
        if (requestEntity.getRevision() == null || requestEntity.getRevision().getVersion() == null) {
            throw new IllegalArgumentException("Revision info is required");
        }
        if (requestEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision version of 0 must be specified when creating a new entity");
        }
        return this.createOrUpdate(requestEntity, creatorIdentity, createEntity);
    }

    @Override
    public <T extends RevisableEntity> T get(Supplier<T> getEntity) {
        RevisableEntity entity = (RevisableEntity)getEntity.get();
        if (entity != null) {
            this.populateRevision(entity);
        }
        return (T)entity;
    }

    @Override
    public <T extends RevisableEntity> List<T> getEntities(Supplier<List<T>> getEntities) {
        List<T> entities = getEntities.get();
        this.populateRevisableEntityRevisions(entities);
        return entities;
    }

    @Override
    public <T extends RevisableEntity> T update(T requestEntity, String updaterIdentity, Supplier<T> updateEntity) {
        return this.createOrUpdate(requestEntity, updaterIdentity, updateEntity);
    }

    private <T extends RevisableEntity> T createOrUpdate(T requestEntity, String userIdentity, Supplier<T> createOrUpdateEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Request entity is required");
        }
        if (requestEntity.getRevision() == null || requestEntity.getRevision().getVersion() == null) {
            throw new IllegalArgumentException("Revision info is required");
        }
        if (userIdentity == null || userIdentity.isBlank()) {
            throw new IllegalArgumentException("User identity is required");
        }
        Revision revision = this.createRevision(requestEntity.getIdentifier(), requestEntity.getRevision());
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate revisionUpdate = this.revisionManager.updateRevision((RevisionClaim)claim, () -> {
            RevisableEntity updatedEntity = (RevisableEntity)createOrUpdateEntity.get();
            return new StandardUpdateResult((Object)updatedEntity, updatedEntity.getIdentifier(), userIdentity);
        });
        RevisableEntity resultEntity = (RevisableEntity)revisionUpdate.getEntity();
        resultEntity.setRevision(this.createRevisionInfo(revisionUpdate.getLastModification()));
        return (T)resultEntity;
    }

    @Override
    public <T extends RevisableEntity> T delete(String entityIdentifier, RevisionInfo revisionInfo, Supplier<T> deleteEntity) {
        if (entityIdentifier == null || entityIdentifier.isBlank()) {
            throw new IllegalArgumentException("Entity identifier is required");
        }
        if (revisionInfo == null || revisionInfo.getVersion() == null) {
            throw new IllegalArgumentException("Revision info is required");
        }
        Revision revision = this.createRevision(entityIdentifier, revisionInfo);
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        return (T)((RevisableEntity)this.revisionManager.deleteRevision((RevisionClaim)claim, () -> (RevisableEntity)deleteEntity.get()));
    }

    @Override
    public void populateRevisions(Collection<?> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Map revisionMap = this.revisionManager.getRevisionMap();
        for (Object obj : entities) {
            if (!(obj instanceof RevisableEntity)) continue;
            this.populateRevision(revisionMap, (RevisableEntity)obj);
        }
    }

    private <T extends RevisableEntity> void populateRevisableEntityRevisions(Collection<T> revisableEntities) {
        if (revisableEntities == null) {
            return;
        }
        Map revisionMap = this.revisionManager.getRevisionMap();
        revisableEntities.forEach(e -> this.populateRevision(revisionMap, (RevisableEntity)e));
    }

    private void populateRevision(Map<String, Revision> revisionMap, RevisableEntity revisableEntity) {
        Revision revision = revisionMap.get(revisableEntity.getIdentifier());
        if (revision != null) {
            RevisionInfo revisionInfo = this.createRevisionInfo(revision);
            revisableEntity.setRevision(revisionInfo);
        } else {
            this.populateRevision(revisableEntity);
        }
    }

    private void populateRevision(RevisableEntity e) {
        if (e == null) {
            return;
        }
        Revision entityRevision = this.revisionManager.getRevision(e.getIdentifier());
        RevisionInfo revisionInfo = this.createRevisionInfo(entityRevision);
        e.setRevision(revisionInfo);
    }

    private Revision createRevision(String entityId, RevisionInfo revisionInfo) {
        return new Revision(revisionInfo.getVersion(), revisionInfo.getClientId(), entityId);
    }

    private RevisionInfo createRevisionInfo(Revision revision) {
        return this.createRevisionInfo(revision, null);
    }

    private RevisionInfo createRevisionInfo(EntityModification entityModification) {
        return this.createRevisionInfo(entityModification.getRevision(), entityModification);
    }

    private RevisionInfo createRevisionInfo(Revision revision, EntityModification entityModification) {
        RevisionInfo revisionInfo = new RevisionInfo();
        revisionInfo.setVersion(revision.getVersion());
        revisionInfo.setClientId(revision.getClientId());
        if (entityModification != null) {
            revisionInfo.setLastModifier(entityModification.getLastModifier());
        }
        return revisionInfo;
    }
}

