/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk;

import org.apache.nifi.components.DescribedValue;

public enum ZendeskAuthenticationType implements DescribedValue
{
    PASSWORD("password", "Password", "Password of Zendesk login user."){

        @Override
        public String enrichUserName(String userName) {
            return userName;
        }
    }
    ,
    TOKEN("token", "Token", "Authentication token generated in Zendesk Admin menu for API access."){

        @Override
        public String enrichUserName(String userName) {
            return String.format(ZendeskAuthenticationType.ZENDESK_USERNAME_WITH_TOKEN_TEMPLATE, userName);
        }
    };

    private static final String ZENDESK_USERNAME_WITH_TOKEN_TEMPLATE = "%s/token";
    private final String value;
    private final String displayName;
    private final String description;

    private ZendeskAuthenticationType(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String enrichUserName(String var1);
}

