/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk;

import org.apache.nifi.common.zendesk.ZendeskAuthenticationType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public final class ZendeskProperties {
    public static final String HTTPS = "https";
    public static final String APPLICATION_JSON = "application/json";
    public static final String ZENDESK_HOST_TEMPLATE = "%s.zendesk.com";
    public static final String ZENDESK_CREATE_TICKET_RESOURCE = "/api/v2/tickets";
    public static final String ZENDESK_CREATE_TICKETS_RESOURCE = "/api/v2/tickets/create_many";
    public static final String ZENDESK_TICKET_ROOT_NODE = "/ticket";
    public static final String ZENDESK_TICKETS_ROOT_NODE = "/tickets";
    public static final PropertyDescriptor WEB_CLIENT_SERVICE_PROVIDER = new PropertyDescriptor.Builder().name("web-client-service-provider").displayName("Web Client Service Provider").description("Controller service for HTTP client operations.").identifiesControllerService(WebClientServiceProvider.class).required(true).build();
    public static final PropertyDescriptor ZENDESK_SUBDOMAIN = new PropertyDescriptor.Builder().name("zendesk-subdomain").displayName("Subdomain Name").description("Name of the Zendesk subdomain.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ZENDESK_USER = new PropertyDescriptor.Builder().name("zendesk-user").displayName("User Name").description("Login user to Zendesk subdomain.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ZENDESK_AUTHENTICATION_TYPE = new PropertyDescriptor.Builder().name("zendesk-authentication-type-name").displayName("Authentication Type").description("Type of authentication to Zendesk API.").required(true).allowableValues(ZendeskAuthenticationType.class).build();
    public static final PropertyDescriptor ZENDESK_AUTHENTICATION_CREDENTIAL = new PropertyDescriptor.Builder().name("zendesk-authentication-value-name").displayName("Authentication Credential").description("Password or authentication token for Zendesk login user.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ZENDESK_TICKET_COMMENT_BODY = new PropertyDescriptor.Builder().name("zendesk-comment-body").displayName("Comment Body").description("The content or the path to the comment body in the incoming record.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor ZENDESK_TICKET_SUBJECT = new PropertyDescriptor.Builder().name("zendesk-subject").displayName("Subject").description("The content or the path to the subject in the incoming record.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ZENDESK_TICKET_PRIORITY = new PropertyDescriptor.Builder().name("zendesk-priority").displayName("Priority").description("The content or the path to the priority in the incoming record.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ZENDESK_TICKET_TYPE = new PropertyDescriptor.Builder().name("zendesk-type").displayName("Type").description("The content or the path to the type in the incoming record.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();

    private ZendeskProperties() {
    }
}

