/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.windows.event.log.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.windows.event.log.jna.ErrorLookup;
import org.apache.nifi.processors.windows.event.log.jna.WEvtApi;

public class EventSubscribeXmlRenderingCallback
implements WEvtApi.EVT_SUBSCRIBE_CALLBACK {
    public static final String RECEIVED_THE_FOLLOWING_WIN32_ERROR = "Received the following Win32 error: ";
    public static final int INITIAL_BUFFER_SIZE = 1024;
    public static final String EVT_RENDER_RETURNED_THE_FOLLOWING_ERROR_CODE = "EvtRender returned the following error code ";
    public static final String MISSING_EVENT_MESSAGE = "Received missing event notification.  Consider triggering processor more frequently or increasing queue size.";
    private final ComponentLog logger;
    private final Consumer<String> consumer;
    private final int maxBufferSize;
    private final WEvtApi wEvtApi;
    private final Kernel32 kernel32;
    private final ErrorLookup errorLookup;
    private int size;
    private Memory buffer;
    private Memory used;
    private Memory propertyCount;
    private boolean subscriptionFailed;

    public EventSubscribeXmlRenderingCallback(ComponentLog logger, Consumer<String> consumer, int maxBufferSize, WEvtApi wEvtApi, Kernel32 kernel32, ErrorLookup errorLookup) {
        this.logger = logger;
        this.consumer = consumer;
        this.maxBufferSize = maxBufferSize;
        this.wEvtApi = wEvtApi;
        this.kernel32 = kernel32;
        this.size = Math.min(maxBufferSize, 1024);
        this.errorLookup = errorLookup;
        this.buffer = new Memory((long)this.size);
        this.used = new Memory(4L);
        this.propertyCount = new Memory(4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int onEvent(int evtSubscribeNotifyAction, WinDef.PVOID userContext, WinNT.HANDLE eventHandle) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("onEvent(" + evtSubscribeNotifyAction + ", " + userContext + ", " + eventHandle);
        }
        if (evtSubscribeNotifyAction == 0) {
            try {
                int errorCode = eventHandle.getPointer().getInt(0L);
                if (errorCode == 15011) {
                    this.logger.error(MISSING_EVENT_MESSAGE);
                }
                this.logger.error(RECEIVED_THE_FOLLOWING_WIN32_ERROR + errorCode);
            }
            catch (Error e) {
                this.logger.error("Failed to get error code onEvent(" + evtSubscribeNotifyAction + ", " + userContext + ", " + eventHandle);
            }
            finally {
                this.subscriptionFailed = true;
            }
        } else if (evtSubscribeNotifyAction == 1) {
            int lastError;
            this.wEvtApi.EvtRender(null, eventHandle, 1, this.size, (Pointer)this.buffer, (Pointer)this.used, (Pointer)this.propertyCount);
            if (this.kernel32.GetLastError() == 122) {
                int newMaxSize = this.used.getInt(0L);
                if (newMaxSize < this.size || newMaxSize > this.maxBufferSize) {
                    this.logger.error("Dropping event " + eventHandle + " because it couldn't be rendered within " + this.maxBufferSize + " bytes.");
                    return 0;
                }
                this.size = newMaxSize;
                this.buffer = new Memory((long)this.size);
                this.wEvtApi.EvtRender(null, eventHandle, 1, this.size, (Pointer)this.buffer, (Pointer)this.used, (Pointer)this.propertyCount);
            }
            if ((lastError = this.kernel32.GetLastError()) == 0) {
                int usedBytes = this.used.getInt(0L);
                String string = StandardCharsets.UTF_16LE.decode(this.buffer.getByteBuffer(0L, (long)usedBytes)).toString();
                if (string.endsWith("\u0000")) {
                    string = string.substring(0, string.length() - 1);
                }
                this.consumer.accept(string);
            } else {
                this.logger.error(EVT_RENDER_RETURNED_THE_FOLLOWING_ERROR_CODE + this.errorLookup.getLastError() + ".");
            }
        }
        return 0;
    }

    public boolean isSubscriptionFailed() {
        return this.subscriptionFailed;
    }
}

