/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.log;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.nifi.web.security.log.AuthenticationUserAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthenticationUserFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationUserFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            logger.debug("Authentication not found in Security Context for Remote Address [{}]", (Object)request.getRemoteAddr());
        } else {
            String username = authentication.getName();
            request.setAttribute(AuthenticationUserAttribute.USERNAME.getName(), (Object)username);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

