/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client.provider.service;

import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.ssl.SSLContextProvider;
import org.apache.nifi.web.client.StandardHttpUriBuilder;
import org.apache.nifi.web.client.StandardWebClientService;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;
import org.apache.nifi.web.client.proxy.ProxyContext;
import org.apache.nifi.web.client.redirect.RedirectHandling;
import org.apache.nifi.web.client.ssl.TlsContext;

@CapabilityDescription(value="Web Client Service Provider with support for configuring standard HTTP connection properties")
@Tags(value={"HTTP", "Web", "Client"})
public class StandardWebClientServiceProvider
extends AbstractControllerService
implements WebClientServiceProvider {
    static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connect Timeout").description("Maximum amount of time to wait before failing during initial socket connection").required(true).defaultValue("10 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Maximum amount of time to wait before failing while reading socket responses").required(true).defaultValue("10 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor WRITE_TIMEOUT = new PropertyDescriptor.Builder().name("Write Timeout").description("Maximum amount of time to wait before failing while writing socket requests").required(true).defaultValue("10 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor REDIRECT_HANDLING_STRATEGY = new PropertyDescriptor.Builder().name("Redirect Handling Strategy").description("Handling strategy for responding to HTTP 301 or 302 redirects received with a Location header").required(true).defaultValue(RedirectHandling.FOLLOWED.name()).allowableValues((Enum[])RedirectHandling.values()).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("SSL Context Service overrides system default TLS settings for HTTPS communication").required(false).identifiesControllerService(SSLContextProvider.class).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CONNECT_TIMEOUT, READ_TIMEOUT, WRITE_TIMEOUT, REDIRECT_HANDLING_STRATEGY, SSL_CONTEXT_SERVICE, ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE);
    private StandardWebClientService webClientService;

    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        propertyConfiguration.renameProperty("connect-timeout", CONNECT_TIMEOUT.getName());
        propertyConfiguration.renameProperty("read-timeout", READ_TIMEOUT.getName());
        propertyConfiguration.renameProperty("write-timeout", WRITE_TIMEOUT.getName());
        propertyConfiguration.renameProperty("redirect-handling-strategy", REDIRECT_HANDLING_STRATEGY.getName());
        propertyConfiguration.renameProperty("ssl-context-service", SSL_CONTEXT_SERVICE.getName());
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        PropertyValue proxyConfigurationServiceProperty;
        StandardWebClientService standardWebClientService = new StandardWebClientService();
        Duration connectTimeout = this.getDuration(context, CONNECT_TIMEOUT);
        standardWebClientService.setConnectTimeout(connectTimeout);
        Duration readTimeout = this.getDuration(context, READ_TIMEOUT);
        standardWebClientService.setReadTimeout(readTimeout);
        Duration writeTimeout = this.getDuration(context, WRITE_TIMEOUT);
        standardWebClientService.setReadTimeout(writeTimeout);
        String redirectHandlingStrategy = context.getProperty(REDIRECT_HANDLING_STRATEGY).getValue();
        RedirectHandling redirectHandling = RedirectHandling.valueOf((String)redirectHandlingStrategy);
        standardWebClientService.setRedirectHandling(redirectHandling);
        PropertyValue sslContextServiceProperty = context.getProperty(SSL_CONTEXT_SERVICE);
        if (sslContextServiceProperty.isSet()) {
            SSLContextProvider sslContextProvider = (SSLContextProvider)sslContextServiceProperty.asControllerService(SSLContextProvider.class);
            TlsContext tlsContext = this.getTlsContext(sslContextProvider);
            standardWebClientService.setTlsContext(tlsContext);
        }
        if ((proxyConfigurationServiceProperty = context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE)).isSet()) {
            ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
            ProxyConfiguration proxyConfiguration = proxyConfigurationService.getConfiguration();
            ProxyContext proxyContext = this.getProxyContext(proxyConfiguration);
            standardWebClientService.setProxyContext(proxyContext);
        }
        this.webClientService = standardWebClientService;
    }

    @OnDisabled
    public void onDisabled() {
        this.webClientService.close();
    }

    public HttpUriBuilder getHttpUriBuilder() {
        return new StandardHttpUriBuilder();
    }

    public WebClientService getWebClientService() {
        return this.webClientService;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private Duration getDuration(ConfigurationContext context, PropertyDescriptor propertyDescriptor) {
        long millis = context.getProperty(propertyDescriptor).asTimePeriod(TimeUnit.MILLISECONDS);
        return Duration.ofMillis(millis);
    }

    private TlsContext getTlsContext(SSLContextProvider sslContextProvider) {
        final X509TrustManager trustManager = sslContextProvider.createTrustManager();
        final Optional keyManager = sslContextProvider.createKeyManager();
        final SSLContext sslContext = sslContextProvider.createContext();
        return new TlsContext(){

            public String getProtocol() {
                return sslContext.getProtocol();
            }

            public X509TrustManager getTrustManager() {
                return trustManager;
            }

            public Optional<X509KeyManager> getKeyManager() {
                return keyManager.map(Function.identity());
            }
        };
    }

    private ProxyContext getProxyContext(final ProxyConfiguration proxyConfiguration) {
        return new ProxyContext(){

            public Proxy getProxy() {
                return proxyConfiguration.createProxy();
            }

            public Optional<String> getUsername() {
                return Optional.ofNullable(proxyConfiguration.getProxyUserName());
            }

            public Optional<String> getPassword() {
                return Optional.ofNullable(proxyConfiguration.getProxyUserPassword());
            }
        };
    }
}

