/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.web.client.api.HttpContentType;
import org.apache.nifi.web.client.api.MultipartFormDataStreamBuilder;

public class StandardMultipartFormDataStreamBuilder
implements MultipartFormDataStreamBuilder {
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition: form-data; name=\"%s\"";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: %s";
    private static final Pattern ALLOWED_NAME_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final String CARRIAGE_RETURN_LINE_FEED = "\r\n";
    private static final String BOUNDARY_SEPARATOR = "--";
    private static final String BOUNDARY_FORMAT = "FormDataBoundary-%s";
    private static final String MULTIPART_FORM_DATA_FORMAT = "multipart/form-data; boundary=\"%s\"";
    private static final Charset HEADERS_CHARACTER_SET = StandardCharsets.US_ASCII;
    private final String boundary = "FormDataBoundary-%s".formatted(UUID.randomUUID());
    private final List<Part> parts = new ArrayList<Part>();

    @Override
    public InputStream build() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("Parts required");
        }
        ArrayList<InputStream> partInputStreams = new ArrayList<InputStream>();
        Iterator<Part> selectedParts = this.parts.iterator();
        while (selectedParts.hasNext()) {
            Part part = selectedParts.next();
            String footer = this.getFooter(selectedParts);
            InputStream partInputStream = this.getPartInputStream(part, footer);
            partInputStreams.add(partInputStream);
        }
        Enumeration enumeratedPartInputStreams = Collections.enumeration(partInputStreams);
        return new SequenceInputStream(enumeratedPartInputStreams);
    }

    @Override
    public HttpContentType getHttpContentType() {
        String contentType = MULTIPART_FORM_DATA_FORMAT.formatted(this.boundary);
        return new MultipartHttpContentType(contentType);
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, HttpContentType httpContentType, InputStream inputStream) {
        Objects.requireNonNull(name, "Name required");
        Objects.requireNonNull(httpContentType, "Content Type required");
        Objects.requireNonNull(inputStream, "Input Stream required");
        Matcher nameMatcher = ALLOWED_NAME_PATTERN.matcher(name);
        if (!nameMatcher.matches()) {
            throw new IllegalArgumentException("Name contains characters outside of ASCII character set");
        }
        Part part = new Part(name, httpContentType, inputStream);
        this.parts.add(part);
        return this;
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, HttpContentType httpContentType, byte[] bytes) {
        Objects.requireNonNull(bytes, "Byte Array required");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return this.addPart(name, httpContentType, inputStream);
    }

    private InputStream getPartInputStream(Part part, String footer) {
        String partHeaders = this.getPartHeaders(part);
        ByteArrayInputStream headersInputStream = new ByteArrayInputStream(partHeaders.getBytes(HEADERS_CHARACTER_SET));
        ByteArrayInputStream footerInputStream = new ByteArrayInputStream(footer.getBytes(HEADERS_CHARACTER_SET));
        Enumeration<ByteArrayInputStream> inputStreams = Collections.enumeration(List.of(headersInputStream, part.inputStream, footerInputStream));
        return new SequenceInputStream(inputStreams);
    }

    private String getPartHeaders(Part part) {
        StringBuilder headersBuilder = new StringBuilder();
        String contentDispositionHeader = CONTENT_DISPOSITION_HEADER.formatted(part.name);
        headersBuilder.append(contentDispositionHeader);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        String contentType = part.httpContentType.getContentType();
        String contentTypeHeader = CONTENT_TYPE_HEADER.formatted(contentType);
        headersBuilder.append(contentTypeHeader);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        return headersBuilder.toString();
    }

    private String getFooter(Iterator<Part> selectedParts) {
        StringBuilder footerBuilder = new StringBuilder();
        footerBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        footerBuilder.append(BOUNDARY_SEPARATOR);
        footerBuilder.append(this.boundary);
        if (selectedParts.hasNext()) {
            footerBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        } else {
            footerBuilder.append(BOUNDARY_SEPARATOR);
        }
        return footerBuilder.toString();
    }

    private record Part(String name, HttpContentType httpContentType, InputStream inputStream) {
    }

    private record MultipartHttpContentType(String contentType) implements HttpContentType
    {
        @Override
        public String getContentType() {
            return this.contentType;
        }
    }
}

