/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.UserDAO;
import org.apache.nifi.web.dao.UserGroupDAO;
import org.springframework.stereotype.Repository;

@Repository
public class StandardPolicyBasedAuthorizerDAO
implements AccessPolicyDAO,
UserGroupDAO,
UserDAO {
    private final AccessPolicyProvider accessPolicyProvider;
    private final UserGroupProvider userGroupProvider;

    public StandardPolicyBasedAuthorizerDAO(Authorizer authorizer) {
        this.accessPolicyProvider = AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer) ? ((ManagedAuthorizer)authorizer).getAccessPolicyProvider() : new /* Unavailable Anonymous Inner Class!! */;
        this.userGroupProvider = this.accessPolicyProvider.getUserGroupProvider();
    }

    private AccessPolicy findAccessPolicy(RequestAction requestAction, String resource) {
        return this.accessPolicyProvider.getAccessPolicies().stream().filter(policy -> policy.getAction().equals((Object)requestAction) && policy.getResource().equals(resource)).findFirst().orElse(null);
    }

    public boolean supportsConfigurableAuthorizer() {
        return this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider;
    }

    public boolean hasAccessPolicy(String accessPolicyId) {
        return this.accessPolicyProvider.getAccessPolicy(accessPolicyId) != null;
    }

    public AccessPolicy createAccessPolicy(AccessPolicyDTO accessPolicyDTO) {
        if (this.supportsConfigurableAuthorizer()) {
            ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
            return configurableAccessPolicyProvider.addAccessPolicy(this.buildAccessPolicy(accessPolicyDTO.getId(), accessPolicyDTO.getResource(), RequestAction.valueOfValue((String)accessPolicyDTO.getAction()), accessPolicyDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
    }

    public AccessPolicy getAccessPolicy(String accessPolicyId) {
        AccessPolicy accessPolicy = this.accessPolicyProvider.getAccessPolicy(accessPolicyId);
        if (accessPolicy == null) {
            throw new ResourceNotFoundException(String.format("Unable to find access policy with id '%s'.", accessPolicyId));
        }
        return accessPolicy;
    }

    public AccessPolicy getAccessPolicy(RequestAction requestAction, String resource) {
        return this.findAccessPolicy(requestAction, resource);
    }

    public AccessPolicy getAccessPolicy(RequestAction requestAction, Authorizable authorizable) {
        String resource = authorizable.getResource().getIdentifier();
        AccessPolicy accessPolicy = this.findAccessPolicy(requestAction, authorizable.getResource().getIdentifier());
        if (accessPolicy == null) {
            Authorizable parentAuthorizable = authorizable.getParentAuthorizable();
            if (parentAuthorizable == null) {
                throw new ResourceNotFoundException(String.format("Unable to find access policy for %s on %s", requestAction.toString(), resource));
            }
            return this.getAccessPolicy(requestAction, parentAuthorizable);
        }
        return accessPolicy;
    }

    public AccessPolicy updateAccessPolicy(AccessPolicyDTO accessPolicyDTO) {
        if (this.supportsConfigurableAuthorizer()) {
            ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
            AccessPolicy currentAccessPolicy = this.getAccessPolicy(accessPolicyDTO.getId());
            return configurableAccessPolicyProvider.updateAccessPolicy(this.buildAccessPolicy(currentAccessPolicy.getIdentifier(), currentAccessPolicy.getResource(), currentAccessPolicy.getAction(), accessPolicyDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
    }

    public AccessPolicy deleteAccessPolicy(String accessPolicyId) {
        if (this.supportsConfigurableAuthorizer()) {
            ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
            return configurableAccessPolicyProvider.deleteAccessPolicy(this.getAccessPolicy(accessPolicyId));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
    }

    private AccessPolicy buildAccessPolicy(String identifier, String resource, RequestAction action, AccessPolicyDTO accessPolicyDTO) {
        Set userGroups = accessPolicyDTO.getUserGroups();
        Set users = accessPolicyDTO.getUsers();
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(identifier).resource(resource);
        if (userGroups != null) {
            builder.addGroups(userGroups.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        if (users != null) {
            builder.addUsers(users.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        builder.action(action);
        return builder.build();
    }

    public boolean hasUserGroup(String userGroupId) {
        return this.userGroupProvider.getGroup(userGroupId) != null;
    }

    public Group createUserGroup(UserGroupDTO userGroupDTO) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            return configurableUserGroupProvider.addGroup(this.buildUserGroup(userGroupDTO.getId(), userGroupDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    public Group getUserGroup(String userGroupId) {
        Group userGroup = this.userGroupProvider.getGroup(userGroupId);
        if (userGroup == null) {
            throw new ResourceNotFoundException(String.format("Unable to find user group with id '%s'.", userGroupId));
        }
        return userGroup;
    }

    public Set<Group> getUserGroupsForUser(String userId) {
        return this.userGroupProvider.getGroups().stream().filter(g -> g.getUsers().contains(userId)).collect(Collectors.toSet());
    }

    public Set<AccessPolicy> getAccessPoliciesForUser(String userId) {
        return this.accessPolicyProvider.getAccessPolicies().stream().filter(p -> {
            if (p.getUsers().contains(userId)) {
                return true;
            }
            return p.getGroups().stream().anyMatch(g -> {
                Group group = this.userGroupProvider.getGroup(g);
                return group != null && group.getUsers().contains(userId);
            });
        }).collect(Collectors.toSet());
    }

    public Set<AccessPolicy> getAccessPoliciesForUserGroup(String userGroupId) {
        return this.accessPolicyProvider.getAccessPolicies().stream().filter(p -> p.getGroups().contains(userGroupId)).collect(Collectors.toSet());
    }

    public Set<Group> getUserGroups() {
        return this.userGroupProvider.getGroups();
    }

    public Group updateUserGroup(UserGroupDTO userGroupDTO) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            return configurableUserGroupProvider.updateGroup(this.buildUserGroup(this.getUserGroup(userGroupDTO.getId()).getIdentifier(), userGroupDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    public Group deleteUserGroup(String userGroupId) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            Group group = this.getUserGroup(userGroupId);
            Group removedGroup = configurableUserGroupProvider.deleteGroup(group);
            if (removedGroup == null) {
                throw new ResourceNotFoundException(String.format("Unable to find user group with id '%s'.", removedGroup));
            }
            if (this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                for (AccessPolicy policy : this.accessPolicyProvider.getAccessPolicies()) {
                    ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
                    if (!policy.getGroups().contains(removedGroup.getIdentifier()) || !configurableAccessPolicyProvider.isConfigurable(policy)) continue;
                    AccessPolicy.Builder builder = new AccessPolicy.Builder(policy).removeGroup(removedGroup.getIdentifier());
                    configurableAccessPolicyProvider.updateAccessPolicy(builder.build());
                }
            }
            return removedGroup;
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    private Group buildUserGroup(String identifier, UserGroupDTO userGroupDTO) {
        Set users = userGroupDTO.getUsers();
        Group.Builder builder = new Group.Builder().identifier(identifier).name(userGroupDTO.getIdentity());
        if (users != null) {
            builder.addUsers(users.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        return builder.build();
    }

    public boolean hasUser(String userId) {
        return this.userGroupProvider.getUser(userId) != null;
    }

    public User createUser(UserDTO userDTO) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            return configurableUserGroupProvider.addUser(this.buildUser(userDTO.getId(), userDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    public User getUser(String userId) {
        User user = this.userGroupProvider.getUser(userId);
        if (user == null) {
            throw new ResourceNotFoundException(String.format("Unable to find user with id '%s'.", userId));
        }
        return user;
    }

    public Set<User> getUsers() {
        return this.userGroupProvider.getUsers();
    }

    public User updateUser(UserDTO userDTO) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            return configurableUserGroupProvider.updateUser(this.buildUser(this.getUser(userDTO.getId()).getIdentifier(), userDTO));
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    public User deleteUser(String userId) {
        if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableUserGroupProvider = (ConfigurableUserGroupProvider)this.userGroupProvider;
            User user = this.getUser(userId);
            User removedUser = configurableUserGroupProvider.deleteUser(user);
            if (removedUser == null) {
                throw new ResourceNotFoundException(String.format("Unable to find user with id '%s'.", userId));
            }
            if (this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                for (AccessPolicy policy : this.accessPolicyProvider.getAccessPolicies()) {
                    ConfigurableAccessPolicyProvider configurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
                    if (!policy.getUsers().contains(removedUser.getIdentifier()) || !configurableAccessPolicyProvider.isConfigurable(policy)) continue;
                    AccessPolicy.Builder builder = new AccessPolicy.Builder(policy).removeUser(removedUser.getIdentifier());
                    configurableAccessPolicyProvider.updateAccessPolicy(builder.build());
                }
            }
            return removedUser;
        }
        throw new IllegalStateException("This NiFi is not configured to allow configurable users and groups. Please contact your system administrator.");
    }

    private User buildUser(String identifier, UserDTO userDTO) {
        User.Builder builder = new User.Builder().identifier(identifier).identity(userDTO.getIdentity());
        return builder.build();
    }
}

