/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Set;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.impl.AbstractPortDAO;
import org.apache.nifi.web.dao.impl.StandardOutputPortDAO;
import org.springframework.stereotype.Repository;

@Repository
public class StandardOutputPortDAO
extends AbstractPortDAO
implements PortDAO {
    protected Port locatePort(String portId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        Port port = rootGroup.findOutputPort(portId);
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find port with id '%s'.", portId));
        }
        return port;
    }

    public boolean hasPort(String portId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        return rootGroup.findOutputPort(portId) != null;
    }

    public Port createPort(String groupId, PortDTO portDTO) {
        if (this.isNotNull((Object)portDTO.getParentGroupId()) && !this.flowController.getFlowManager().areGroupsSame(groupId, portDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the OutputPort is being added.");
        }
        if (portDTO.getName() == null) {
            throw new IllegalArgumentException("Port name must be specified.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Port port = group.getParent() == null || Boolean.TRUE.equals(portDTO.getAllowRemoteAccess()) ? this.flowController.getFlowManager().createPublicOutputPort(portDTO.getId(), portDTO.getName()) : this.flowController.getFlowManager().createLocalOutputPort(portDTO.getId(), portDTO.getName());
        if (port instanceof PublicPort) {
            this.verifyPublicPortUniqueness(port.getIdentifier(), port.getName());
        }
        this.verifyUpdate(port, portDTO);
        if (portDTO.getPosition() != null) {
            port.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        port.setComments(portDTO.getComments());
        group.addOutputPort(port);
        return port;
    }

    public Port getPort(String portId) {
        return this.locatePort(portId);
    }

    public Set<Port> getPorts(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getOutputPorts();
    }

    protected Set<Port> getPublicPorts() {
        return this.flowController.getFlowManager().getPublicOutputPorts();
    }

    protected void handleStateTransition(Port port, ScheduledState proposedScheduledState) throws IllegalStateException {
        ProcessGroup processGroup = port.getProcessGroup();
        switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[proposedScheduledState.ordinal()]) {
            case 1: {
                processGroup.startOutputPort(port);
                break;
            }
            case 3: {
                switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[port.getScheduledState().ordinal()]) {
                    case 1: {
                        processGroup.stopOutputPort(port);
                        break;
                    }
                    case 2: {
                        processGroup.enableOutputPort(port);
                    }
                }
                break;
            }
            case 2: {
                processGroup.disableOutputPort(port);
            }
        }
    }

    public void deletePort(String portId) {
        Port outputPort = this.locatePort(portId);
        outputPort.getProcessGroup().removeOutputPort(outputPort);
    }
}

