/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Set;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StandardLabelDAO
extends ComponentDAO
implements LabelDAO {
    private FlowController flowController;

    private Label locateLabel(String labelId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        Label label = rootGroup.findLabel(labelId);
        if (label == null) {
            throw new ResourceNotFoundException(String.format("Unable to find label with id '%s'.", labelId));
        }
        return label;
    }

    public boolean hasLabel(String labelId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        return rootGroup.findLabel(labelId) != null;
    }

    public Label createLabel(String groupId, LabelDTO labelDTO) {
        if (labelDTO.getParentGroupId() != null && !this.flowController.getFlowManager().areGroupsSame(groupId, labelDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Label is being added.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Label label = this.flowController.getFlowManager().createLabel(labelDTO.getId(), labelDTO.getLabel());
        if (labelDTO.getPosition() != null) {
            label.setPosition(new Position(labelDTO.getPosition().getX().doubleValue(), labelDTO.getPosition().getY().doubleValue()));
        }
        if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
            label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
        }
        label.setStyle(labelDTO.getStyle());
        if (labelDTO.getzIndex() != null) {
            label.setZIndex(labelDTO.getzIndex().longValue());
        }
        group.addLabel(label);
        return label;
    }

    public Label getLabel(String labelId) {
        return this.locateLabel(labelId);
    }

    public Set<Label> getLabels(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getLabels();
    }

    public Label updateLabel(LabelDTO labelDTO) {
        Label label = this.locateLabel(labelDTO.getId());
        if (labelDTO.getPosition() != null) {
            label.setPosition(new Position(labelDTO.getPosition().getX().doubleValue(), labelDTO.getPosition().getY().doubleValue()));
        }
        if (labelDTO.getStyle() != null) {
            label.setStyle(labelDTO.getStyle());
        }
        if (labelDTO.getLabel() != null) {
            label.setValue(labelDTO.getLabel());
        }
        if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
            label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
        }
        if (labelDTO.getzIndex() != null) {
            label.setZIndex(labelDTO.getzIndex().longValue());
        }
        label.getProcessGroup().onComponentModified();
        return label;
    }

    public void deleteLabel(String labelId) {
        Label label = this.locateLabel(labelId);
        label.getProcessGroup().removeLabel(label);
    }

    @Autowired
    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

