/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.streaming;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.web.api.streaming.ByteRange;
import org.apache.nifi.web.api.streaming.ByteRangeFormatException;
import org.apache.nifi.web.api.streaming.ByteRangeParser;

public class StandardByteRangeParser
implements ByteRangeParser {
    private static final Pattern BYTE_RANGE_PATTERN = Pattern.compile("^bytes=(0|[1-9][0-9]{0,18})?-(0|[1-9][0-9]{0,18})?$");
    private static final int FIRST_POSITION_GROUP = 1;
    private static final int LAST_POSITION_GROUP = 2;

    public Optional<ByteRange> readByteRange(String rangeHeader) {
        ByteRange byteRange;
        if (rangeHeader == null || rangeHeader.isBlank()) {
            byteRange = null;
        } else {
            Matcher matcher = BYTE_RANGE_PATTERN.matcher(rangeHeader);
            if (matcher.matches()) {
                Long lastPosition;
                Long firstPosition;
                String firstPositionGroup = matcher.group(1);
                String lastPositionGroup = matcher.group(2);
                if (firstPositionGroup == null) {
                    if (lastPositionGroup == null) {
                        throw new ByteRangeFormatException("Range header missing first and last positions");
                    }
                    firstPosition = null;
                    lastPosition = this.parsePosition(lastPositionGroup);
                } else {
                    firstPosition = this.parsePosition(firstPositionGroup);
                    if (lastPositionGroup == null) {
                        lastPosition = null;
                    } else {
                        lastPosition = this.parsePosition(lastPositionGroup);
                        if (lastPosition < firstPosition) {
                            throw new ByteRangeFormatException("Range header not valid: last position less than first position");
                        }
                    }
                }
                byteRange = new ByteRange(firstPosition, lastPosition);
            } else {
                throw new ByteRangeFormatException("Range header not valid");
            }
        }
        return Optional.ofNullable(byteRange);
    }

    private long parsePosition(String positionGroup) {
        try {
            return Long.parseLong(positionGroup);
        }
        catch (NumberFormatException e) {
            throw new ByteRangeFormatException("Range header position not valid");
        }
    }
}

