/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.streaming;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class InputStreamingOutput
implements StreamingOutput {
    private final InputStream inputStream;

    public InputStreamingOutput(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "Input Stream required");
    }

    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
        try (InputStream inputStream = this.inputStream;){
            this.inputStream.transferTo(outputStream);
        }
    }
}

