/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.streaming;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.web.api.streaming.ByteRange;
import org.apache.nifi.web.api.streaming.RangeNotSatisfiableException;

public class ByteRangeStreamingOutput
implements StreamingOutput {
    private final InputStream inputStream;
    private final ByteRange byteRange;

    public ByteRangeStreamingOutput(InputStream inputStream, ByteRange byteRange) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        this.byteRange = Objects.requireNonNull(byteRange, "Byte Range required");
        OptionalLong lastPositionFound = byteRange.getLastPosition();
        if (lastPositionFound.isPresent()) {
            long lastPosition = lastPositionFound.getAsLong();
            OptionalLong firstPositionFound = byteRange.getFirstPosition();
            this.inputStream = firstPositionFound.isPresent() ? new LimitingInputStream(inputStream, lastPosition) : inputStream;
        } else {
            this.inputStream = inputStream;
        }
    }

    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
        try (InputStream inputStream = this.inputStream;){
            OptionalLong firstPositionFound = this.byteRange.getFirstPosition();
            OptionalLong lastPositionFound = this.byteRange.getLastPosition();
            if (firstPositionFound.isPresent()) {
                long firstPosition = firstPositionFound.getAsLong();
                try {
                    this.inputStream.skipNBytes(firstPosition);
                }
                catch (EOFException e) {
                    throw new RangeNotSatisfiableException("First Range Position [%d] not valid".formatted(firstPosition), (Throwable)e);
                }
            } else if (lastPositionFound.isPresent()) {
                long lastPosition = lastPositionFound.getAsLong();
                long available = this.inputStream.available();
                long skip = available - lastPosition;
                this.inputStream.skipNBytes(skip);
            }
            this.inputStream.transferTo(outputStream);
        }
    }
}

