/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger logger = LoggerFactory.getLogger(ValidationExceptionMapper.class);

    public Response toResponse(ValidationException exception) {
        logger.info("{}. Returning {} response.", (Object)exception, (Object)Response.Status.BAD_REQUEST);
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringUtils.join((Iterable)exception.getValidationErrors(), (String)"\n")).type("text/plain").build();
    }
}

