/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.exception.AuthenticationNotSupportedException;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.security.LogoutException;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.jwt.revocation.JwtLogoutListener;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/access")
@Tag(name="Access")
public class AccessResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(AccessResource.class);
    protected static final String AUTHENTICATION_NOT_ENABLED_MSG = "User authentication/authorization is only supported when running over HTTPS.";
    private LoginIdentityProvider loginIdentityProvider;
    private JwtLogoutListener jwtLogoutListener;
    private BearerTokenProvider bearerTokenProvider;
    private BearerTokenResolver bearerTokenResolver;
    private LogoutRequestManager logoutRequestManager;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Path(value="/token")
    @Operation(summary="Creates a token for accessing the REST API via username/password", description="The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. It is stored in the browser as a cookie, but also returned inthe response body to be stored/used by third party client scripts.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=String.class))})})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it."), @ApiResponse(responseCode="500", description="Unable to create access token because an unexpected error occurred.")})
    public Response createAccessToken(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        LoginAuthenticationToken loginAuthenticationToken;
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("Access tokens are only issued over HTTPS.");
        }
        if (this.loginIdentityProvider == null) {
            throw new IllegalStateException("Username/Password login not supported by this NiFi.");
        }
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("The username and password must be specified.");
        }
        try {
            AuthenticationResponse authenticationResponse = this.loginIdentityProvider.authenticate(new LoginCredentials(username, password));
            String rawIdentity = authenticationResponse.getIdentity();
            String mappedIdentity = IdentityMappingUtil.mapIdentity((String)rawIdentity, (List)IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            long expirationDuration = authenticationResponse.getExpiration();
            Instant expiration = Instant.now().plusMillis(expirationDuration);
            loginAuthenticationToken = new LoginAuthenticationToken(mappedIdentity, expiration, Collections.emptySet());
        }
        catch (InvalidLoginCredentialsException ilce) {
            throw new IllegalArgumentException("The supplied username and password are not valid.", ilce);
        }
        catch (IdentityAccessException iae) {
            throw new AdministrationException(iae.getMessage(), (Throwable)iae);
        }
        String bearerToken = this.bearerTokenProvider.getBearerToken(loginAuthenticationToken);
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        this.setBearerToken(httpServletResponse, bearerToken);
        return this.generateCreatedResponse(uri, (Object)bearerToken).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout")
    @Operation(summary="Performs a logout for other providers that have been issued a JWT.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User was logged out successfully."), @ApiResponse(responseCode="401", description="Authentication token provided was empty or not in the correct JWT format."), @ApiResponse(responseCode="500", description="Client failed to log out.")})
    public Response logOut(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException(AUTHENTICATION_NOT_ENABLED_MSG);
        }
        String mappedUserIdentity = NiFiUserUtils.getNiFiUserIdentity();
        if (StringUtils.isBlank((CharSequence)mappedUserIdentity)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication token provided was empty or not in the correct JWT format.").build();
        }
        try {
            String requestIdentifier = UUID.randomUUID().toString();
            logger.info("Logout Request [{}] Identity [{}] started", (Object)requestIdentifier, (Object)mappedUserIdentity);
            this.applicationCookieService.removeCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.AUTHORIZATION_BEARER);
            String bearerToken = this.bearerTokenResolver.resolve(httpServletRequest);
            this.jwtLogoutListener.logout(bearerToken);
            LogoutRequest logoutRequest = new LogoutRequest(requestIdentifier, mappedUserIdentity);
            this.logoutRequestManager.start(logoutRequest);
            this.applicationCookieService.addCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER, logoutRequest.getRequestIdentifier());
            return this.generateOkResponse().build();
        }
        catch (LogoutException e) {
            logger.error("Logout Failed Identity [{}]", (Object)mappedUserIdentity, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout/complete")
    @Operation(summary="Completes the logout sequence by removing the cached Logout Request and Cookie if they existed and redirects to /nifi/login.", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User was logged out successfully."), @ApiResponse(responseCode="401", description="Authentication token provided was empty or not in the correct JWT format."), @ApiResponse(responseCode="500", description="Client failed to log out.")})
    public void logOutComplete(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException(AUTHENTICATION_NOT_ENABLED_MSG);
        }
        this.completeLogoutRequest(httpServletResponse);
        httpServletResponse.sendRedirect(this.getNiFiLogoutCompleteUri());
    }

    private LogoutRequest completeLogoutRequest(HttpServletResponse httpServletResponse) {
        LogoutRequest logoutRequest = null;
        Optional cookieValue = this.getLogoutRequestIdentifier();
        if (cookieValue.isPresent()) {
            String logoutRequestIdentifier = (String)cookieValue.get();
            logoutRequest = this.logoutRequestManager.complete(logoutRequestIdentifier);
            logger.info("Logout Request [{}] Completed [{}]", (Object)logoutRequestIdentifier, (Object)logoutRequest.getMappedUserIdentity());
        } else {
            logger.warn("Logout Request Cookie [{}] not found", (Object)ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName());
        }
        this.removeLogoutRequestCookie(httpServletResponse);
        return logoutRequest;
    }

    private String getNiFiLogoutCompleteUri() {
        return this.getNiFiUri() + "logout-complete";
    }

    private void removeLogoutRequestCookie(HttpServletResponse httpServletResponse) {
        this.applicationCookieService.removeCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
    }

    private Optional<String> getLogoutRequestIdentifier() {
        return this.applicationCookieService.getCookieValue(this.httpServletRequest, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
    }

    @Autowired(required=false)
    public void setLoginIdentityProvider(LoginIdentityProvider loginIdentityProvider) {
        this.loginIdentityProvider = loginIdentityProvider;
    }

    @Autowired
    public void setBearerTokenProvider(BearerTokenProvider bearerTokenProvider) {
        this.bearerTokenProvider = bearerTokenProvider;
    }

    @Autowired
    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    @Autowired
    public void setJwtLogoutListener(JwtLogoutListener jwtLogoutListener) {
        this.jwtLogoutListener = jwtLogoutListener;
    }

    @Autowired
    public void setLogoutRequestManager(LogoutRequestManager logoutRequestManager) {
        this.logoutRequestManager = logoutRequestManager;
    }
}

