/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.EntityStoreAuditService;
import org.apache.nifi.framework.configuration.ApplicationPropertiesConfiguration;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.configuration.AuthenticationConfiguration;
import org.apache.nifi.web.configuration.WebApplicationConfiguration;
import org.apache.nifi.web.security.configuration.WebSecurityConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ComponentScan(basePackageClasses={ApplicationPropertiesConfiguration.class, WebSecurityConfiguration.class, WebApplicationConfiguration.class})
@Configuration
public class NiFiWebApiConfiguration {
    private static final URI OAUTH2_AUTHORIZATION_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/oauth2/authorization/consumer");
    private static final URI OIDC_LOGOUT_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/access/oidc/logout");
    private static final URI SAML2_AUTHENTICATE_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/saml2/authenticate/consumer");
    private static final URI SAML_LOCAL_LOGOUT_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/access/saml/local-logout/request");
    private static final URI SAML_SINGLE_LOGOUT_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/access/saml/single-logout/request");
    private static final URI LOGIN_FORM_URI = NiFiWebApiConfiguration.getLoginFormUri();
    private static final URI LOGOUT_COMPLETE_URI = NiFiWebApiConfiguration.getPathUri((String)"/nifi-api/access/logout/complete");
    private static final String UI_PATH = "/nf/";
    private static final String LOGIN_FRAGMENT = "/login";

    @Autowired
    @Bean
    public AuditService auditService(NiFiProperties properties) {
        File databaseDirectory = properties.getDatabaseRepositoryPath().toFile();
        return new EntityStoreAuditService(databaseDirectory);
    }

    @Autowired
    @Bean
    public AuthenticationConfiguration authenticationConfiguration(NiFiProperties properties) {
        URI logoutUri;
        URI loginUri;
        boolean externalLoginRequired;
        if (properties.isHTTPSConfigured()) {
            String loginIdentityProvider = properties.getProperty("nifi.security.user.login.identity.provider");
            if (properties.isOidcEnabled()) {
                externalLoginRequired = true;
                loginUri = OAUTH2_AUTHORIZATION_URI;
                logoutUri = OIDC_LOGOUT_URI;
            } else if (properties.isSamlEnabled()) {
                externalLoginRequired = true;
                loginUri = SAML2_AUTHENTICATE_URI;
                logoutUri = properties.isSamlSingleLogoutEnabled() ? SAML_SINGLE_LOGOUT_URI : SAML_LOCAL_LOGOUT_URI;
            } else if (StringUtils.hasText((String)loginIdentityProvider)) {
                externalLoginRequired = false;
                loginUri = LOGIN_FORM_URI;
                logoutUri = LOGOUT_COMPLETE_URI;
            } else {
                externalLoginRequired = false;
                loginUri = null;
                logoutUri = null;
            }
        } else {
            externalLoginRequired = false;
            loginUri = null;
            logoutUri = null;
        }
        boolean loginSupported = loginUri != null;
        return new AuthenticationConfiguration(externalLoginRequired, loginSupported, loginUri, logoutUri);
    }

    private static URI getPathUri(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Path URI construction failed", e);
        }
    }

    private static URI getLoginFormUri() {
        try {
            return new URI(null, null, UI_PATH, LOGIN_FRAGMENT);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Path Fragment URI construction failed", e);
        }
    }
}

