/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.dao.UserDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class UserAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(UserAuditor.class);
    private static final String IDENTITY = "Identity";

    @Around(value="within(org.apache.nifi.web.dao.UserDAO+) && execution(org.apache.nifi.authorization.User createUser(org.apache.nifi.web.api.dto.UserDTO))")
    public User createUserAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        User user = (User)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(user, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return user;
    }

    @Around(value="within(org.apache.nifi.web.dao.UserDAO+) && execution(org.apache.nifi.authorization.User updateUser(org.apache.nifi.web.api.dto.UserDTO)) && args(userDTO) && target(userDAO)")
    public User updateUserAdvice(ProceedingJoinPoint proceedingJoinPoint, UserDTO userDTO, UserDAO userDAO) throws Throwable {
        User user = userDAO.getUser(userDTO.getId());
        Map values = this.extractConfiguredPropertyValues(user, userDTO);
        User updatedUser = (User)proceedingJoinPoint.proceed();
        user = userDAO.getUser(updatedUser.getIdentifier());
        NiFiUser niFiUser = NiFiUserUtils.getNiFiUser();
        if (niFiUser != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(user, userDTO);
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(niFiUser.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(user.getIdentifier());
                configurationAction.setSourceName(user.getIdentity());
                configurationAction.setSourceType(Component.User);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedUser;
    }

    @Around(value="within(org.apache.nifi.web.dao.UserDAO+) && execution(org.apache.nifi.authorization.User deleteUser(java.lang.String)) && args(userId) && target(userDAO)")
    public User removeUserAdvice(ProceedingJoinPoint proceedingJoinPoint, String userId, UserDAO userDAO) throws Throwable {
        User user = userDAO.getUser(userId);
        User removedUser = (User)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(user, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return removedUser;
    }

    public Action generateAuditRecord(User user, Operation operation) {
        return this.generateAuditRecord(user, operation, null);
    }

    public Action generateAuditRecord(User user, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser niFiUser = NiFiUserUtils.getNiFiUser();
        if (niFiUser != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(niFiUser.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(user.getIdentifier());
            action.setSourceName(user.getIdentity());
            action.setSourceType(Component.User);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(User user, UserDTO userDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (userDTO.getIdentity() != null) {
            values.put(IDENTITY, user.getIdentity());
        }
        return values;
    }
}

