/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.Date;
import java.util.Objects;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.dao.LabelDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class LabelAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(LabelAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.LabelDAO+) && execution(org.apache.nifi.controller.label.Label createLabel(java.lang.String, org.apache.nifi.web.api.dto.LabelDTO))")
    public Label createLabelAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Label label = (Label)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(label, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return label;
    }

    @Around(value="within(org.apache.nifi.web.dao.LabelDAO+) && execution(org.apache.nifi.controller.label.Label updateLabel(org.apache.nifi.web.api.dto.LabelDTO)) && args(labelDTO) && target(labelDAO)")
    public Label updateLabelAdvice(ProceedingJoinPoint proceedingJoinPoint, LabelDTO labelDTO, LabelDAO labelDAO) throws Throwable {
        Label label = labelDAO.getLabel(labelDTO.getId());
        String originalLabelValue = label.getValue();
        Label updatedLabel = (Label)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            String updatedLabelValue = updatedLabel.getValue();
            if (originalLabelValue == null && updatedLabelValue != null || !Objects.equals(originalLabelValue, updatedLabelValue)) {
                FlowChangeAction labelAction = new FlowChangeAction();
                labelAction.setUserIdentity(user.getIdentity());
                labelAction.setTimestamp(new Date());
                labelAction.setSourceId(label.getIdentifier());
                labelAction.setSourceType(Component.Label);
                labelAction.setOperation(Operation.Configure);
                labelAction.setSourceName(label.getIdentifier());
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(label.getIdentifier());
                actionDetails.setValue(updatedLabelValue);
                actionDetails.setPreviousValue(originalLabelValue);
                labelAction.setActionDetails((ActionDetails)actionDetails);
                this.saveAction((Action)labelAction, logger);
            }
        }
        return updatedLabel;
    }

    @Around(value="within(org.apache.nifi.web.dao.LabelDAO+) && execution(void deleteLabel(java.lang.String)) && args(labelId) && target(labelDAO)")
    public void removeLabelAdvice(ProceedingJoinPoint proceedingJoinPoint, String labelId, LabelDAO labelDAO) throws Throwable {
        Label label = labelDAO.getLabel(labelId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(label, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(Label label, Operation operation) {
        return this.generateAuditRecord(label, operation, null);
    }

    public Action generateAuditRecord(Label label, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(label.getIdentifier());
            action.setSourceName(label.getIdentifier());
            action.setSourceType(Component.Label);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

