/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger logger = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);
    private static final String EXCEPTION_SEPARATOR = ": ";

    public Response toResponse(WebApplicationException exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        if (message.contains(EXCEPTION_SEPARATOR)) {
            message = StringUtils.substringAfter((String)message, (String)EXCEPTION_SEPARATOR);
        }
        Response response = exception.getResponse();
        logger.info(String.format("%s. Returning %s response.", exception, response.getStatus()));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((int)response.getStatus()).entity((Object)message).type("text/plain").build();
    }
}

