/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import com.sun.jersey.api.Responses;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.web.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ResourceNotFoundExceptionMapper
implements ExceptionMapper<ResourceNotFoundException> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceNotFoundExceptionMapper.class);

    public Response toResponse(ResourceNotFoundException exception) {
        logger.info(String.format("%s. Returning %s response.", new Object[]{exception, Response.Status.NOT_FOUND}));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Responses.notFound().entity((Object)exception.getMessage()).type("text/plain").build();
    }
}

