/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.util.Pause;

public class CancellableTimedPause
implements Pause {
    private final long expirationNanoTime;
    private final long pauseNanos;
    private volatile boolean cancelled = false;

    public CancellableTimedPause(long pauseTime, long expirationPeriod, TimeUnit timeUnit) {
        long expirationNanos = TimeUnit.NANOSECONDS.convert(expirationPeriod, timeUnit);
        long expirationTime = System.nanoTime() + expirationNanos;
        this.expirationNanoTime = expirationTime < 0L ? Long.MAX_VALUE : expirationTime;
        this.pauseNanos = Math.max(1L, TimeUnit.NANOSECONDS.convert(pauseTime, timeUnit));
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean pause() {
        if (this.cancelled) {
            return false;
        }
        long sysTime = System.nanoTime();
        long maxWaitTime = System.nanoTime() + this.pauseNanos;
        while (sysTime < maxWaitTime && !this.cancelled) {
            try {
                TimeUnit.NANOSECONDS.sleep(this.pauseNanos);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
            sysTime = System.nanoTime();
        }
        return sysTime < this.expirationNanoTime && !this.cancelled;
    }
}

