/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.FlowRegistryUtils;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.VersionsResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.VersionedFlowDTO;
import org.apache.nifi.web.api.dto.VersionedFlowUpdateRequestDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.CreateActiveRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.StartVersionControlRequestEntity;
import org.apache.nifi.web.api.entity.VersionControlComponentMappingEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotEntity;
import org.apache.nifi.web.api.entity.VersionedFlowUpdateRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.CancellableTimedPause;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/versions")
@Api(value="/versions", description="Endpoint for managing version control for a flow")
public class VersionsResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(VersionsResource.class);
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ComponentLifecycle clusterComponentLifecycle;
    private ComponentLifecycle localComponentLifecycle;
    private DtoFactory dtoFactory;
    private RequestManager<VersionControlInformationEntity, VersionControlInformationEntity> requestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Version Control Update Thread");
    private ActiveRequest activeRequest = null;
    private final Object activeRequestMonitor = new Object();

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Gets the Version Control information for a process group", response=VersionControlInformationEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVersionInformation(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        VersionControlInformationEntity entity = this.serviceFacade.getVersionControlInformation(groupId);
        if (entity == null) {
            ProcessGroupEntity processGroup = this.serviceFacade.getProcessGroup(groupId);
            entity = new VersionControlInformationEntity();
            entity.setProcessGroupRevision(processGroup.getRevision());
        }
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/download")
    @ApiOperation(value="Gets the latest version of a Process Group for download", response=String.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response exportFlowVersion(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        this.serviceFacade.authorizeAccess(lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, false, true);
        });
        VersionedFlowSnapshot versionedFlowSnapshot = this.serviceFacade.getVersionedFlowSnapshotByGroupId(groupId);
        VersionedProcessGroup versionedProcessGroup = versionedFlowSnapshot.getFlowContents();
        String flowName = versionedProcessGroup.getName();
        int flowVersion = versionedFlowSnapshot.getSnapshotMetadata().getVersion();
        versionedFlowSnapshot.setFlow(null);
        versionedFlowSnapshot.setBucket(null);
        versionedFlowSnapshot.setSnapshotMetadata(null);
        this.sanitizeRegistryInfo(versionedProcessGroup);
        String filename = flowName.replaceAll("\\s", "_") + "_" + flowVersion + ".json";
        return this.generateOkResponse((Object)versionedFlowSnapshot).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", filename)).build();
    }

    private void sanitizeRegistryInfo(VersionedProcessGroup versionedProcessGroup) {
        versionedProcessGroup.setVersionedFlowCoordinates(null);
        for (VersionedProcessGroup innerVersionedProcessGroup : versionedProcessGroup.getProcessGroups()) {
            this.sanitizeRegistryInfo(innerVersionedProcessGroup);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Path(value="active-requests")
    @ApiOperation(value="Create a version control request", response=String.class, notes="Creates a request so that a Process Group can be placed under Version Control or have its Version Control configuration changed. Creating this request will prevent any other threads from simultaneously saving local changes to Version Control. It will not, however, actually save the local flow to the Flow Registry. A POST to /versions/process-groups/{id} should be used to initiate saving of the local flow to the Flow Registry. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createVersionControlRequest(@ApiParam(value="The versioned flow details.", required=true) CreateActiveRequestEntity requestEntity) {
        if (requestEntity.getProcessGroupId() == null) {
            throw new IllegalArgumentException("The id of the process group that will be updated must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(requestEntity.getProcessGroupId()).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
        }, null, entity -> {
            String requestId = this.generateUuid();
            Object object = this.activeRequestMonitor;
            synchronized (object) {
                if (this.activeRequest != null && !this.activeRequest.isExpired()) {
                    throw new IllegalStateException("A request is already underway to place a Process Group in this NiFi instance under Version Control. Only a single such request is allowed to occurred at a time. Please try the request again momentarily.");
                }
                this.activeRequest = new ActiveRequest(requestId, user, entity.getProcessGroupId(), null);
            }
            return this.generateOkResponse((Object)requestId).build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="active-requests/{id}")
    @ApiOperation(value="Updates the request with the given ID", response=VersionControlInformationEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can update it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateVersionControlRequest(@ApiParam(value="The request ID.") @PathParam(value="id") String requestId, @ApiParam(value="The version control component mapping.", required=true) VersionControlComponentMappingEntity requestEntity) {
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionControlInformationDTO versionControlInfo = requestEntity.getVersionControlInformation();
        if (versionControlInfo == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied");
        }
        if (versionControlInfo.getGroupId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Process Group ID");
        }
        if (versionControlInfo.getBucketId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Bucket ID");
        }
        if (versionControlInfo.getFlowId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Flow ID");
        }
        if (versionControlInfo.getRegistryId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Registry ID");
        }
        if (versionControlInfo.getVersion() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Version");
        }
        Map mapping = requestEntity.getVersionControlComponentMapping();
        if (mapping == null) {
            throw new IllegalArgumentException("Version Control Component Mapping must be supplied");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Object object = this.activeRequestMonitor;
        synchronized (object) {
            if (this.activeRequest == null) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (!requestId.equals(this.activeRequest.getRequestId())) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (this.activeRequest.isExpired()) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " has already expired");
            }
            if (this.activeRequest.isUpdatePerformed()) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " has already been performed");
            }
            String groupId = requestEntity.getVersionControlInformation().getGroupId();
            if (!this.activeRequest.getProcessGroupId().equals(groupId)) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " was created for a different process group id");
            }
            Revision groupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), groupId);
            return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, groupRevision, lookup -> {
                NiFiUser user = NiFiUserUtils.getNiFiUser();
                if (user == null) {
                    throw new AccessDeniedException("Unknown user.");
                }
                if (!user.equals(this.activeRequest.getUser())) {
                    throw new AccessDeniedException("Only the user that creates the Version Control Request can use it.");
                }
            }, null, (rev, mappingEntity) -> {
                VersionControlInformationEntity responseEntity = this.serviceFacade.setVersionControlInformation(rev, groupId, mappingEntity.getVersionControlInformation(), mappingEntity.getVersionControlComponentMapping());
                this.activeRequest.updatePerformed();
                return this.generateOkResponse((Object)responseEntity).build();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="active-requests/{id}")
    @ApiOperation(value="Deletes the version control request with the given ID", notes="Deletes the Version Control Request with the given ID. This will allow other threads to save flows to the Flow Registry. See also the documentation for POSTing to /versions/active-requests for information regarding why this is done. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteVersionControlRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The request ID.") @PathParam(value="id") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Object object = this.activeRequestMonitor;
        synchronized (object) {
            if (this.activeRequest == null) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (!requestId.equals(this.activeRequest.getRequestId())) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            return this.withWriteLock(this.serviceFacade, null, lookup -> {
                NiFiUser user = NiFiUserUtils.getNiFiUser();
                if (user == null) {
                    throw new AccessDeniedException("Unknown user.");
                }
                if (!user.equals(this.activeRequest.getUser())) {
                    throw new AccessDeniedException("Only the user that creates the Version Control Request can use it.");
                }
            }, null, requestEntity -> {
                this.activeRequest = null;
                return this.generateOkResponse().build();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Save the Process Group with the given ID", response=VersionControlInformationEntity.class, notes="Begins version controlling the Process Group with the given ID or commits changes to the Versioned Flow, depending on if the provided VersionControlInformation includes a flowId. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Read - any referenced Controller Services by any encapsulated components - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response saveToFlowRegistry(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The versioned flow details.", required=true) StartVersionControlRequestEntity requestEntity) {
        ProcessGroupEntity root;
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionedFlowDTO versionedFlowDto = requestEntity.getVersionedFlow();
        if (versionedFlowDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getBucketId())) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getFlowName()) && StringUtils.isEmpty((CharSequence)versionedFlowDto.getFlowId())) {
            throw new IllegalArgumentException("The Flow Name or Flow ID must be supplied.");
        }
        if (versionedFlowDto.getFlowName() != null && versionedFlowDto.getFlowName().length() > 1000) {
            throw new IllegalArgumentException("The Flow Name cannot exceed 1,000 characters");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getRegistryId())) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (versionedFlowDto.getDescription() != null && versionedFlowDto.getDescription().length() > 65535) {
            throw new IllegalArgumentException("Flow Description cannot exceed 65,535 characters");
        }
        if (versionedFlowDto.getComments() != null && versionedFlowDto.getComments().length() > 65535) {
            throw new IllegalArgumentException("Comments cannot exceed 65,535 characters");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getAction())) {
            throw new IllegalArgumentException("Action is required");
        }
        if (!"COMMIT".equals(versionedFlowDto.getAction()) && !"FORCE_COMMIT".equals(versionedFlowDto.getAction())) {
            throw new IllegalArgumentException("Action must be one of COMMIT or FORCE_COMMIT");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        if ((root = this.serviceFacade.getProcessGroup("root")).getId().equals(groupId)) {
            throw new IllegalArgumentException("The Root Process Group cannot be versioned.");
        }
        if (this.isReplicateRequest()) {
            URI requestUri;
            try {
                URI originalUri = this.getAbsolutePath();
                String requestId = this.lockVersionControl(originalUri, groupId);
                requestUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/versions/active-requests/" + requestId, null, originalUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            try {
                VersionControlComponentMappingEntity mappingEntity = this.serviceFacade.registerFlowWithFlowRegistry(groupId, requestEntity);
                this.replicateVersionControlMapping(mappingEntity, requestEntity, requestUri, groupId);
                VersionControlInformationEntity responseEntity = this.serviceFacade.getVersionControlInformation(groupId);
                Response response = this.generateOkResponse((Object)responseEntity).build();
                return response;
            }
            finally {
                this.unlockVersionControl(requestUri, groupId);
            }
        }
        Revision groupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, groupRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, true, true);
        }, () -> {
            VersionedFlowDTO versionedFlow = requestEntity.getVersionedFlow();
            String registryId = versionedFlow.getRegistryId();
            String bucketId = versionedFlow.getBucketId();
            String flowId = versionedFlow.getFlowId();
            String action = versionedFlow.getAction();
            this.serviceFacade.verifyCanSaveToFlowRegistry(groupId, registryId, bucketId, flowId, action);
        }, (rev, flowEntity) -> {
            VersionControlComponentMappingEntity mappingEntity = this.serviceFacade.registerFlowWithFlowRegistry(groupId, flowEntity);
            VersionControlInformationEntity responseEntity = this.serviceFacade.setVersionControlInformation(rev, groupId, mappingEntity.getVersionControlInformation(), mappingEntity.getVersionControlComponentMapping());
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    private void unlockVersionControl(URI requestUri, String groupId) {
        NodeResponse clusterResponse;
        try {
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("DELETE", requestUri, (Object)new MultivaluedHashMap(), Collections.emptyMap()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "DELETE", requestUri, (Object)new MultivaluedHashMap(), Collections.emptyMap()).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("After starting Version Control on Process Group with ID " + groupId + ", interrupted while waiting for deletion of Version Control Request. Users may be unable to Version Control other Process Groups until the request lock times out.", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            logger.error("After starting Version Control on Process Group with ID " + groupId + ", failed to delete Version Control Request. Users may be unable to Version Control other Process Groups until the request lock times out. Response status code was " + clusterResponse.getStatus());
        }
    }

    private String lockVersionControl(URI originalUri, String groupId) throws URISyntaxException {
        NodeResponse clusterResponse;
        URI createRequestUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/versions/active-requests", null, originalUri.getFragment());
        try {
            CreateActiveRequestEntity activeRequestEntity = new CreateActiveRequestEntity();
            activeRequestEntity.setProcessGroupId(groupId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("POST", createRequestUri, (Object)activeRequestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "POST", createRequestUri, (Object)activeRequestEntity, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while updating Version Control Information for Process Group with ID " + groupId + ".", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            String errorResponse = (String)this.getResponseEntity(clusterResponse, String.class);
            throw new IllegalStateException("Failed to create a Version Control Request across all nodes in the cluster. Received response code " + clusterResponse.getStatus() + " with content: " + errorResponse);
        }
        String requestId = (String)this.getResponseEntity(clusterResponse, String.class);
        return requestId;
    }

    private void replicateVersionControlMapping(VersionControlComponentMappingEntity mappingEntity, StartVersionControlRequestEntity requestEntity, URI requestUri, String groupId) {
        NodeResponse clusterResponse;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        try {
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("PUT", requestUri, (Object)mappingEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "PUT", requestUri, (Object)mappingEntity, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (requestEntity.getVersionedFlow().getFlowId() == null) {
                VersionControlInformationDTO vci = mappingEntity.getVersionControlInformation();
                try {
                    this.serviceFacade.deleteVersionedFlow(vci.getRegistryId(), vci.getBucketId(), vci.getFlowId());
                }
                catch (Exception e) {
                    logger.error("Created Versioned Flow with ID {} in bucket with ID {} but failed to replicate the Version Control Information to cluster. Attempted to delete the newly created (empty) flow from the Flow Registry but failed", new Object[]{vci.getFlowId(), vci.getBucketId(), e});
                }
            }
            throw new RuntimeException("Interrupted while updating Version Control Information for Process Group with ID " + groupId + ".", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            if (requestEntity.getVersionedFlow().getFlowId() == null) {
                VersionControlInformationDTO vci = mappingEntity.getVersionControlInformation();
                try {
                    this.serviceFacade.deleteVersionedFlow(vci.getRegistryId(), vci.getBucketId(), vci.getFlowId());
                }
                catch (Exception e) {
                    logger.error("Created Versioned Flow with ID {} in bucket with ID {} but failed to replicate the Version Control Information to cluster. Attempted to delete the newly created (empty) flow from the Flow Registry but failed", new Object[]{vci.getFlowId(), vci.getBucketId(), e});
                }
            }
            String message = "Failed to update Version Control Information for Process Group with ID " + groupId + ".";
            Throwable cause = clusterResponse.getThrowable();
            if (cause == null) {
                throw new IllegalStateException(message);
            }
            throw new IllegalStateException(message, cause);
        }
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Stops version controlling the Process Group with the given ID", response=VersionControlInformationEntity.class, notes="Stops version controlling the Process Group with the given ID. The Process Group will no longer track to any Versioned Flow. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response stopVersionControl(@ApiParam(value="The version is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The process group id.") @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), groupId);
        return this.withWriteLock(this.serviceFacade, null, requestRevision, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> {
            VersionControlInformationEntity currentVersionControlInfo = this.serviceFacade.getVersionControlInformation(groupId);
            if (currentVersionControlInfo == null) {
                throw new IllegalStateException("Process Group with ID " + groupId + " is not currently under Version Control");
            }
        }, (revision, groupEntity) -> {
            VersionControlInformationEntity entity = this.serviceFacade.deleteVersionControl(revision, groupId);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Update the version of a Process Group with the given ID", response=VersionControlInformationEntity.class, notes="For a Process Group that is already under Version Control, this will update the version of the flow to a different version. This endpoint expects that the given snapshot will not modify any Processor that is currently running or any Controller Service that is enabled. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateFlowVersion(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) VersionedFlowSnapshotEntity requestEntity) {
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified.");
        }
        VersionedFlowSnapshot requestFlowSnapshot = requestEntity.getVersionedFlowSnapshot();
        if (requestFlowSnapshot == null) {
            throw new IllegalArgumentException("Versioned Flow Snapshot must be supplied.");
        }
        VersionedFlowSnapshotMetadata requestSnapshotMetadata = requestFlowSnapshot.getSnapshotMetadata();
        if (requestSnapshotMetadata == null) {
            throw new IllegalArgumentException("Snapshot Metadata must be supplied.");
        }
        if (requestSnapshotMetadata.getBucketIdentifier() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestSnapshotMetadata.getFlowIdentifier() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanUpdate(groupId, requestFlowSnapshot, true, false), (rev, entity) -> {
            VersionedFlowSnapshot flowSnapshot = entity.getVersionedFlowSnapshot();
            VersionedFlowSnapshotMetadata snapshotMetadata = flowSnapshot.getSnapshotMetadata();
            Bucket bucket = flowSnapshot.getBucket();
            VersionedFlow flow = flowSnapshot.getFlow();
            VersionControlInformationDTO versionControlInfoDto = new VersionControlInformationDTO();
            versionControlInfoDto.setBucketId(snapshotMetadata.getBucketIdentifier());
            versionControlInfoDto.setBucketName(bucket.getName());
            versionControlInfoDto.setFlowId(snapshotMetadata.getFlowIdentifier());
            versionControlInfoDto.setFlowName(flow.getName());
            versionControlInfoDto.setFlowDescription(flow.getDescription());
            versionControlInfoDto.setGroupId(groupId);
            versionControlInfoDto.setVersion(Integer.valueOf(snapshotMetadata.getVersion()));
            versionControlInfoDto.setRegistryId(entity.getRegistryId());
            versionControlInfoDto.setRegistryName(this.serviceFacade.getFlowRegistryName(entity.getRegistryId()));
            VersionedFlowState flowState = (long)snapshotMetadata.getVersion() == flow.getVersionCount() ? VersionedFlowState.UP_TO_DATE : VersionedFlowState.STALE;
            versionControlInfoDto.setState(flowState.name());
            ProcessGroupEntity updatedGroup = this.serviceFacade.updateProcessGroupContents(rev, groupId, versionControlInfoDto, flowSnapshot, (String)this.getIdGenerationSeed().orElse(null), false, false, entity.getUpdateDescendantVersionedFlows().booleanValue(), () -> ((VersionsResource)this).generateUuid());
            VersionControlInformationDTO updatedVci = updatedGroup.getComponent().getVersionControlInformation();
            VersionControlInformationEntity responseEntity = new VersionControlInformationEntity();
            responseEntity.setProcessGroupRevision(updatedGroup.getRevision());
            responseEntity.setVersionControlInformation(updatedVci);
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/{id}")
    @ApiOperation(value="Returns the Update Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /versions/update-requests/process-groups/{id}, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUpdateRequest(@ApiParam(value="The ID of the Update Request") @PathParam(value="id") String updateRequestId) {
        return this.retrieveRequest("update-requests", updateRequestId);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/{id}")
    @ApiOperation(value="Returns the Revert Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Returns the Revert Request with the given ID. Once a Revert Request has been created by performing a POST to /versions/revert-requests/process-groups/{id}, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRevertRequest(@ApiParam(value="The ID of the Revert Request") @PathParam(value="id") String revertRequestId) {
        return this.retrieveRequest("revert-requests", revertRequestId);
    }

    private Response retrieveRequest(String requestType, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.requestManager.getRequest(requestType, requestId, user);
        VersionedFlowUpdateRequestDTO updateRequestDto = new VersionedFlowUpdateRequestDTO();
        updateRequestDto.setComplete(asyncRequest.isComplete());
        updateRequestDto.setFailureReason(asyncRequest.getFailureReason());
        updateRequestDto.setLastUpdated(asyncRequest.getLastUpdated());
        updateRequestDto.setProcessGroupId(asyncRequest.getComponentId());
        updateRequestDto.setRequestId(requestId);
        updateRequestDto.setUri(this.generateResourceUri(new String[]{"versions", requestType, requestId}));
        updateRequestDto.setState(asyncRequest.getState());
        updateRequestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        if (updateRequestDto.isComplete()) {
            VersionControlInformationEntity vciEntity = this.serviceFacade.getVersionControlInformation(asyncRequest.getComponentId());
            updateRequestDto.setVersionControlInformation(vciEntity == null ? null : vciEntity.getVersionControlInformation());
        }
        RevisionDTO groupRevision = this.serviceFacade.getProcessGroup(asyncRequest.getComponentId()).getRevision();
        VersionedFlowUpdateRequestEntity updateRequestEntity = new VersionedFlowUpdateRequestEntity();
        updateRequestEntity.setProcessGroupRevision(groupRevision);
        updateRequestEntity.setRequest(updateRequestDto);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/{id}")
    @ApiOperation(value="Deletes the Update Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Deletes the Update Request with the given ID. After a request is created via a POST to /versions/update-requests/process-groups/{id}, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteUpdateRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the Update Request") @PathParam(value="id") String updateRequestId) {
        return this.deleteRequest("update-requests", updateRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/{id}")
    @ApiOperation(value="Deletes the Revert Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Deletes the Revert Request with the given ID. After a request is created via a POST to /versions/revert-requests/process-groups/{id}, it is expected that the client will properly clean up the request by DELETE'ing it, once the Revert process has completed. If the request is deleted before the request completes, then the Revert request will finish the step that it is currently performing and then will cancel any subsequent steps. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteRevertRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the Revert Request") @PathParam(value="id") String revertRequestId) {
        return this.deleteRequest("revert-requests", revertRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    private Response deleteRequest(String requestType, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.requestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        VersionedFlowUpdateRequestDTO updateRequestDto = new VersionedFlowUpdateRequestDTO();
        updateRequestDto.setComplete(asyncRequest.isComplete());
        updateRequestDto.setFailureReason(asyncRequest.getFailureReason());
        updateRequestDto.setLastUpdated(asyncRequest.getLastUpdated());
        updateRequestDto.setProcessGroupId(asyncRequest.getComponentId());
        updateRequestDto.setRequestId(requestId);
        updateRequestDto.setUri(this.generateResourceUri(new String[]{"versions", requestType, requestId}));
        updateRequestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        updateRequestDto.setState(asyncRequest.getState());
        if (updateRequestDto.isComplete()) {
            VersionControlInformationEntity vciEntity = this.serviceFacade.getVersionControlInformation(asyncRequest.getComponentId());
            updateRequestDto.setVersionControlInformation(vciEntity == null ? null : vciEntity.getVersionControlInformation());
        }
        RevisionDTO groupRevision = this.serviceFacade.getProcessGroup(asyncRequest.getComponentId()).getRevision();
        VersionedFlowUpdateRequestEntity updateRequestEntity = new VersionedFlowUpdateRequestEntity();
        updateRequestEntity.setProcessGroupRevision(groupRevision);
        updateRequestEntity.setRequest(updateRequestDto);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/process-groups/{id}")
    @ApiOperation(value="Initiate the Update Request of a Process Group with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="For a Process Group that is already under Version Control, this will initiate the action of changing from a specific version of the flow in the Flow Registry to a different version of the flow. This can be a lengthy process, as it will stop any Processors and disable any Controller Services necessary to perform the action and then restart them. As a result, the endpoint will immediately return a VersionedFlowUpdateRequestEntity, and the process of updating the flow will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /versions/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /versions/update-requests/{requestId}. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - if the template contains any restricted components - /restricted-components"), @Authorization(value="Read - /parameter-contexts/{uuid} - For any Parameter Context that is referenced by a Property that is changed, added, or removed")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response initiateVersionControlUpdate(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) VersionControlInformationEntity requestEntity) {
        boolean replicateRequest;
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionControlInformationDTO requestVersionControlInfoDto = requestEntity.getVersionControlInformation();
        if (requestVersionControlInfoDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (requestVersionControlInfoDto.getGroupId() == null) {
            throw new IllegalArgumentException("The Process Group ID must be supplied.");
        }
        if (!requestVersionControlInfoDto.getGroupId().equals(groupId)) {
            throw new IllegalArgumentException("The Process Group ID in the request body does not match the Process Group ID of the requested resource.");
        }
        if (requestVersionControlInfoDto.getBucketId() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getFlowId() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getRegistryId() == null) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getVersion() == null) {
            throw new IllegalArgumentException("The Version of the flow must be supplied.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        ComponentLifecycle componentLifecycle = (replicateRequest = this.isReplicateRequest()) ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        VersionedFlowSnapshot flowSnapshot = this.serviceFacade.getVersionedFlowSnapshot(requestEntity.getVersionControlInformation(), true);
        this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshot, groupId, NiFiUserUtils.getNiFiUser());
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByVersionChange(groupId, flowSnapshot);
        InitiateChangeFlowVersionRequestWrapper requestWrapper = new InitiateChangeFlowVersionRequestWrapper(requestEntity, componentLifecycle, this.getAbsolutePath(), affectedComponents, replicateRequest, flowSnapshot);
        Revision requestRevision = this.getRevision(requestEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, true, true);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, false, true, true, false);
            VersionedProcessGroup groupContents = flowSnapshot.getFlowContents();
            Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedProcessGroup)groupContents, (NiFiServiceFacade)this.serviceFacade);
            restrictedComponents.forEach(restrictedComponent -> {
                ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
                this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
            });
            Map parameterContexts = flowSnapshot.getParameterContexts();
            if (parameterContexts != null) {
                parameterContexts.values().forEach(context -> AuthorizeParameterReference.authorizeParameterContextAddition((VersionedParameterContext)context, (NiFiServiceFacade)this.serviceFacade, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (NiFiUser)user));
            }
        }, () -> this.serviceFacade.verifyCanUpdate(groupId, flowSnapshot, false, true), (revision, wrapper) -> {
            String idGenerationSeed = this.getIdGenerationSeed().orElse(null);
            String requestId = UUID.randomUUID().toString();
            StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestEntity, groupId, user, this.getUpdateSteps());
            Consumer<AsynchronousWebRequest> updateTask = arg_0 -> this.lambda$null$21(groupId, wrapper, revision, (AsynchronousWebRequest)request, idGenerationSeed, arg_0);
            this.requestManager.submitRequest("update-requests", requestId, (AsynchronousWebRequest)request, updateTask);
            VersionedFlowUpdateRequestDTO updateRequestDto = new VersionedFlowUpdateRequestDTO();
            updateRequestDto.setComplete(request.isComplete());
            updateRequestDto.setFailureReason(request.getFailureReason());
            updateRequestDto.setLastUpdated(request.getLastUpdated());
            updateRequestDto.setProcessGroupId(groupId);
            updateRequestDto.setRequestId(requestId);
            updateRequestDto.setUri(this.generateResourceUri(new String[]{"versions", "update-requests", requestId}));
            updateRequestDto.setPercentCompleted(request.getPercentComplete());
            updateRequestDto.setState(request.getState());
            VersionedFlowUpdateRequestEntity updateRequestEntity = new VersionedFlowUpdateRequestEntity();
            RevisionDTO groupRevision = this.serviceFacade.getProcessGroup(groupId).getRevision();
            updateRequestEntity.setProcessGroupRevision(groupRevision);
            updateRequestEntity.setRequest(updateRequestDto);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        });
    }

    private List<UpdateStep> getUpdateSteps() {
        ArrayList<UpdateStep> updateSteps = new ArrayList<UpdateStep>();
        updateSteps.add((UpdateStep)new StandardUpdateStep("Stopping Affected Processors"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Disabling Affected Controller Services"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Updating Flow"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Re-Enabling Controller Services"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Restarting Affected Processors"));
        return updateSteps;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/process-groups/{id}")
    @ApiOperation(value="Initiate the Revert Request of a Process Group with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="For a Process Group that is already under Version Control, this will initiate the action of reverting any local changes that have been made to the Process Group since it was last synchronized with the Flow Registry. This will result in the flow matching the Versioned Flow that exists in the Flow Registry. This can be a lengthy process, as it will stop any Processors and disable any Controller Services necessary to perform the action and then restart them. As a result, the endpoint will immediately return a VersionedFlowUpdateRequestEntity, and the process of updating the flow will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /versions/revert-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /versions/revert-requests/{requestId}. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - if the template contains any restricted components - /restricted-components"), @Authorization(value="Read - /parameter-contexts/{uuid} - For any Parameter Context that is referenced by a Property that is changed, added, or removed")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response initiateRevertFlowVersion(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) VersionControlInformationEntity requestEntity) {
        boolean replicateRequest;
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionControlInformationDTO requestVersionControlInfoDto = requestEntity.getVersionControlInformation();
        if (requestVersionControlInfoDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (requestVersionControlInfoDto.getGroupId() == null) {
            throw new IllegalArgumentException("The Process Group ID must be supplied.");
        }
        if (!requestVersionControlInfoDto.getGroupId().equals(groupId)) {
            throw new IllegalArgumentException("The Process Group ID in the request body does not match the Process Group ID of the requested resource.");
        }
        if (requestVersionControlInfoDto.getBucketId() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getFlowId() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getRegistryId() == null) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getVersion() == null) {
            throw new IllegalArgumentException("The Version of the flow must be supplied.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        ComponentLifecycle componentLifecycle = (replicateRequest = this.isReplicateRequest()) ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        VersionedFlowSnapshot flowSnapshot = this.serviceFacade.getVersionedFlowSnapshot(requestEntity.getVersionControlInformation(), true);
        this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshot, groupId, NiFiUserUtils.getNiFiUser());
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByVersionChange(groupId, flowSnapshot);
        InitiateChangeFlowVersionRequestWrapper requestWrapper = new InitiateChangeFlowVersionRequestWrapper(requestEntity, componentLifecycle, this.getAbsolutePath(), affectedComponents, replicateRequest, flowSnapshot);
        Revision requestRevision = this.getRevision(requestEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, true, true);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, false, true, true, false);
            VersionedProcessGroup groupContents = flowSnapshot.getFlowContents();
            Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedProcessGroup)groupContents, (NiFiServiceFacade)this.serviceFacade);
            restrictedComponents.forEach(restrictedComponent -> {
                ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
                this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
            });
            Map parameterContexts = flowSnapshot.getParameterContexts();
            if (parameterContexts != null) {
                parameterContexts.values().forEach(context -> AuthorizeParameterReference.authorizeParameterContextAddition((VersionedParameterContext)context, (NiFiServiceFacade)this.serviceFacade, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (NiFiUser)user));
            }
        }, () -> this.serviceFacade.verifyCanRevertLocalModifications(groupId, flowSnapshot), (revision, wrapper) -> {
            VersionControlInformationEntity versionControlInformationEntity = wrapper.getVersionControlInformationEntity();
            VersionControlInformationDTO versionControlInformationDTO = versionControlInformationEntity.getVersionControlInformation();
            VersionControlInformationEntity currentVersionEntity = this.serviceFacade.getVersionControlInformation(groupId);
            if (currentVersionEntity == null) {
                throw new IllegalStateException("Process Group cannot be reverted to the previous version of the flow because Process Group is not under Version Control.");
            }
            VersionControlInformationDTO currentVersion = currentVersionEntity.getVersionControlInformation();
            if (!currentVersion.getBucketId().equals(versionControlInformationDTO.getBucketId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getFlowId().equals(versionControlInformationDTO.getFlowId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getRegistryId().equals(versionControlInformationDTO.getRegistryId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getVersion().equals(versionControlInformationDTO.getVersion())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            String idGenerationSeed = this.getIdGenerationSeed().orElse(null);
            String requestId = UUID.randomUUID().toString();
            StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestEntity, groupId, user, this.getUpdateSteps());
            Consumer<AsynchronousWebRequest> updateTask = arg_0 -> this.lambda$null$27(groupId, wrapper, revision, versionControlInformationEntity, (AsynchronousWebRequest)request, idGenerationSeed, arg_0);
            this.requestManager.submitRequest("revert-requests", requestId, (AsynchronousWebRequest)request, updateTask);
            VersionedFlowUpdateRequestDTO updateRequestDto = new VersionedFlowUpdateRequestDTO();
            updateRequestDto.setComplete(request.isComplete());
            updateRequestDto.setFailureReason(request.getFailureReason());
            updateRequestDto.setLastUpdated(request.getLastUpdated());
            updateRequestDto.setProcessGroupId(groupId);
            updateRequestDto.setRequestId(requestId);
            updateRequestDto.setState(request.getState());
            updateRequestDto.setPercentCompleted(request.getPercentComplete());
            updateRequestDto.setUri(this.generateResourceUri(new String[]{"versions", "revert-requests", requestId}));
            VersionedFlowUpdateRequestEntity updateRequestEntity = new VersionedFlowUpdateRequestEntity();
            RevisionDTO groupRevision = this.serviceFacade.getProcessGroup(groupId).getRevision();
            updateRequestEntity.setProcessGroupRevision(groupRevision);
            updateRequestEntity.setRequest(updateRequestDto);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionControlInformationEntity updateFlowVersion(String groupId, ComponentLifecycle componentLifecycle, URI exampleUri, Set<AffectedComponentEntity> affectedComponents, boolean replicateRequest, Revision revision, VersionControlInformationEntity requestEntity, VersionedFlowSnapshot flowSnapshot, AsynchronousWebRequest<VersionControlInformationEntity, VersionControlInformationEntity> asyncRequest, String idGenerationSeed, boolean verifyNotModified, boolean updateDescendantVersionedFlows) throws LifecycleManagementException, ResumeFlowException {
        block29: {
            HashSet<String> stoppableReferenceTypes = new HashSet<String>();
            stoppableReferenceTypes.add("PROCESSOR");
            stoppableReferenceTypes.add("REMOTE_INPUT_PORT");
            stoppableReferenceTypes.add("REMOTE_OUTPUT_PORT");
            stoppableReferenceTypes.add("INPUT_PORT");
            stoppableReferenceTypes.add("OUTPUT_PORT");
            Set runningComponents = affectedComponents.stream().filter(dto -> stoppableReferenceTypes.contains(dto.getComponent().getReferenceType())).filter(dto -> "Running".equalsIgnoreCase(dto.getComponent().getState())).collect(Collectors.toSet());
            logger.info("Stopping {} Processors", (Object)runningComponents.size());
            CancellableTimedPause stopComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)stopComponentsPause).cancel());
            componentLifecycle.scheduleComponents(exampleUri, groupId, runningComponents, ScheduledState.STOPPED, (Pause)stopComponentsPause, InvalidComponentAction.SKIP);
            if (asyncRequest.isCancelled()) {
                return null;
            }
            asyncRequest.markStepComplete();
            Set enabledServices = affectedComponents.stream().filter(dto -> "CONTROLLER_SERVICE".equals(dto.getComponent().getReferenceType())).filter(dto -> "Enabled".equalsIgnoreCase(dto.getComponent().getState())).collect(Collectors.toSet());
            logger.info("Disabling {} Controller Services", (Object)enabledServices.size());
            CancellableTimedPause disableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)disableServicesPause).cancel());
            componentLifecycle.activateControllerServices(exampleUri, groupId, enabledServices, ControllerServiceState.DISABLED, (Pause)disableServicesPause, InvalidComponentAction.SKIP);
            if (asyncRequest.isCancelled()) {
                return null;
            }
            asyncRequest.markStepComplete();
            logger.info("Updating Process Group with ID {} to version {} of the Versioned Flow", (Object)groupId, (Object)flowSnapshot.getSnapshotMetadata().getVersion());
            try {
                if (replicateRequest) {
                    NodeResponse clusterResponse;
                    URI updateUri;
                    NiFiUser user = NiFiUserUtils.getNiFiUser();
                    try {
                        updateUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/versions/process-groups/" + groupId, null, exampleUri.getFragment());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("content-type", "application/json");
                    VersionedFlowSnapshotEntity snapshotEntity = new VersionedFlowSnapshotEntity();
                    snapshotEntity.setProcessGroupRevision(this.dtoFactory.createRevisionDTO(revision));
                    snapshotEntity.setRegistryId(requestEntity.getVersionControlInformation().getRegistryId());
                    snapshotEntity.setVersionedFlow(flowSnapshot);
                    snapshotEntity.setUpdateDescendantVersionedFlows(Boolean.valueOf(updateDescendantVersionedFlows));
                    try {
                        logger.debug("Replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
                        clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", updateUri, (Object)snapshotEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", updateUri, (Object)snapshotEntity, headers).awaitMergedResponse();
                    }
                    catch (InterruptedException ie) {
                        logger.warn("Interrupted while replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
                        Thread.currentThread().interrupt();
                        throw new LifecycleManagementException("Interrupted while updating flows across cluster", (Throwable)ie);
                    }
                    int updateFlowStatus = clusterResponse.getStatus();
                    if (updateFlowStatus != Response.Status.OK.getStatusCode()) {
                        String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                        logger.error("Failed to update flow across cluster when replicating PUT request to {} for user {}. Received {} response with explanation: {}", new Object[]{updateUri, user, updateFlowStatus, explanation});
                        throw new LifecycleManagementException("Failed to update Flow on all nodes in cluster due to " + explanation);
                    }
                    break block29;
                }
                this.serviceFacade.verifyCanUpdate(groupId, flowSnapshot, true, verifyNotModified);
                VersionControlInformationDTO requestVci = requestEntity.getVersionControlInformation();
                Bucket bucket = flowSnapshot.getBucket();
                VersionedFlow flow = flowSnapshot.getFlow();
                VersionedFlowSnapshotMetadata metadata = flowSnapshot.getSnapshotMetadata();
                VersionControlInformationDTO vci = new VersionControlInformationDTO();
                vci.setBucketId(metadata.getBucketIdentifier());
                vci.setBucketName(bucket.getName());
                vci.setFlowDescription(flow.getDescription());
                vci.setFlowId(flow.getIdentifier());
                vci.setFlowName(flow.getName());
                vci.setGroupId(groupId);
                vci.setRegistryId(requestVci.getRegistryId());
                vci.setRegistryName(this.serviceFacade.getFlowRegistryName(requestVci.getRegistryId()));
                vci.setVersion(Integer.valueOf(metadata.getVersion()));
                vci.setState(flowSnapshot.isLatest() ? VersionedFlowState.UP_TO_DATE.name() : VersionedFlowState.STALE.name());
                this.serviceFacade.updateProcessGroupContents(revision, groupId, vci, flowSnapshot, idGenerationSeed, verifyNotModified, false, updateDescendantVersionedFlows, () -> ((VersionsResource)this).generateUuid());
            }
            finally {
                if (!asyncRequest.isCancelled()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Re-Enabling {} Controller Services: {}", (Object)enabledServices.size(), enabledServices);
                    }
                    asyncRequest.markStepComplete();
                    CancellableTimedPause enableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)enableServicesPause).cancel());
                    Set servicesToEnable = this.getUpdatedEntities(enabledServices);
                    logger.info("Successfully updated flow; re-enabling {} Controller Services", (Object)servicesToEnable.size());
                    try {
                        componentLifecycle.activateControllerServices(exampleUri, groupId, servicesToEnable, ControllerServiceState.ENABLED, (Pause)enableServicesPause, InvalidComponentAction.SKIP);
                    }
                    catch (IllegalStateException ise) {
                        throw new ResumeFlowException("Successfully updated flow but could not re-enable all Controller Services because " + ise.getMessage(), (Throwable)ise);
                    }
                }
                if (!asyncRequest.isCancelled()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Restart {} Processors: {}", (Object)runningComponents.size(), runningComponents);
                    }
                    asyncRequest.markStepComplete();
                    Set componentsToStart = this.getUpdatedEntities(runningComponents);
                    HashSet<AffectedComponentEntity> avoidStarting = new HashSet<AffectedComponentEntity>();
                    for (AffectedComponentEntity componentEntity : componentsToStart) {
                        boolean startComponent;
                        AffectedComponentDTO componentDto = componentEntity.getComponent();
                        String referenceType = componentDto.getReferenceType();
                        if (!"REMOTE_INPUT_PORT".equals(referenceType) && !"REMOTE_OUTPUT_PORT".equals(referenceType)) continue;
                        try {
                            startComponent = this.serviceFacade.isRemoteGroupPortConnected(componentDto.getProcessGroupId(), componentDto.getId());
                        }
                        catch (ResourceNotFoundException rnfe) {
                            startComponent = false;
                        }
                        if (startComponent) continue;
                        avoidStarting.add(componentEntity);
                    }
                    componentsToStart.removeAll(avoidStarting);
                    CancellableTimedPause startComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)startComponentsPause).cancel());
                    logger.info("Restarting {} Processors", (Object)componentsToStart.size());
                    try {
                        componentLifecycle.scheduleComponents(exampleUri, groupId, componentsToStart, ScheduledState.RUNNING, (Pause)startComponentsPause, InvalidComponentAction.SKIP);
                    }
                    catch (IllegalStateException ise) {
                        throw new ResumeFlowException("Successfully updated flow but could not restart all Processors because " + ise.getMessage(), (Throwable)ise);
                    }
                }
            }
        }
        asyncRequest.setCancelCallback(null);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        return this.serviceFacade.getVersionControlInformation(groupId);
    }

    private <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    private Set<AffectedComponentEntity> getUpdatedEntities(Set<AffectedComponentEntity> originalEntities) {
        LinkedHashSet<AffectedComponentEntity> entities = new LinkedHashSet<AffectedComponentEntity>();
        for (AffectedComponentEntity original : originalEntities) {
            try {
                AffectedComponentEntity updatedEntity = AffectedComponentUtils.updateEntity((AffectedComponentEntity)original, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory);
                if (updatedEntity == null) continue;
                entities.add(updatedEntity);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        return entities;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setClusterComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.clusterComponentLifecycle = componentLifecycle;
    }

    public void setLocalComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.localComponentLifecycle = componentLifecycle;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    private /* synthetic */ void lambda$null$27(String groupId, InitiateChangeFlowVersionRequestWrapper wrapper, Revision revision, VersionControlInformationEntity versionControlInformationEntity, AsynchronousWebRequest request, String idGenerationSeed, AsynchronousWebRequest vcur) {
        try {
            VersionControlInformationEntity updatedVersionControlEntity = this.updateFlowVersion(groupId, wrapper.getComponentLifecycle(), wrapper.getExampleUri(), wrapper.getAffectedComponents(), wrapper.isReplicateRequest(), revision, versionControlInformationEntity, wrapper.getFlowSnapshot(), request, idGenerationSeed, false, true);
            vcur.markStepComplete((Object)updatedVersionControlEntity);
        }
        catch (ResumeFlowException rfe) {
            logger.warn(rfe.getMessage(), (Throwable)rfe);
            vcur.fail(rfe.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to update flow to new version", (Throwable)e);
            vcur.fail("Failed to update flow to new version due to " + e.getMessage());
        }
    }

    private /* synthetic */ void lambda$null$21(String groupId, InitiateChangeFlowVersionRequestWrapper wrapper, Revision revision, AsynchronousWebRequest request, String idGenerationSeed, AsynchronousWebRequest vcur) {
        try {
            VersionControlInformationEntity updatedVersionControlEntity = this.updateFlowVersion(groupId, wrapper.getComponentLifecycle(), wrapper.getExampleUri(), wrapper.getAffectedComponents(), wrapper.isReplicateRequest(), revision, wrapper.getVersionControlInformationEntity(), wrapper.getFlowSnapshot(), request, idGenerationSeed, true, true);
            vcur.markStepComplete((Object)updatedVersionControlEntity);
        }
        catch (ResumeFlowException rfe) {
            logger.warn(rfe.getMessage(), (Throwable)rfe);
            vcur.fail(rfe.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to update flow to new version", (Throwable)e);
            vcur.fail("Failed to update flow to new version due to " + e);
        }
    }
}

