/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.AsyncLineageSubmission;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.LineageComputationType;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.NiFiProperties;

public class NoOpProvenanceRepository
implements ProvenanceRepository {
    private static final QueryResult noOpQueryResult = new QueryResult(){

        public List<ProvenanceEventRecord> getMatchingEvents() {
            return Collections.emptyList();
        }

        public long getTotalHitCount() {
            return 0L;
        }

        public long getQueryTime() {
            return 0L;
        }

        public Date getExpiration() {
            return new Date(0L);
        }

        public String getError() {
            return "";
        }

        public int getPercentComplete() {
            return 100;
        }

        public boolean isFinished() {
            return true;
        }

        public boolean awaitCompletion(long time, TimeUnit unit) {
            return false;
        }
    };

    public NoOpProvenanceRepository() {
    }

    public NoOpProvenanceRepository(NiFiProperties ignored) {
    }

    public void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory factory, IdentifierLookup identifierLookup) throws IOException {
        eventReporter.reportEvent(Severity.INFO, "Provenance", "Initialized NoOpProvenanceRepository - Provenance tracking is disabled");
    }

    public void close() throws IOException {
    }

    public ProvenanceEventBuilder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public ProvenanceEventRecord getEvent(long id) {
        return null;
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) {
        return null;
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) {
        return Collections.emptyList();
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords, NiFiUser user) {
        return Collections.emptyList();
    }

    public Long getMaxEventId() {
        return 0L;
    }

    public void registerEvent(ProvenanceEventRecord records) {
    }

    public void registerEvents(Iterable<ProvenanceEventRecord> records) {
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        return new NoOpQuerySubmission(query, user.getIdentity());
    }

    public List<ProvenanceEventRecord> getLatestCachedEvents(String componentId, int eventLimit) {
        return Collections.emptyList();
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        return new NoOpQuerySubmission(queryIdentifier, user.getIdentity());
    }

    public ComputeLineageSubmission submitLineageComputation(String s, NiFiUser user) {
        return new NoOpComputeLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, null, Collections.singleton(s), user.getIdentity());
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        NoOpComputeLineageSubmission result = new NoOpComputeLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, eventId, Collections.emptySet(), user.getIdentity());
        result.getResult().setError("Could not find event with ID " + eventId);
        return result;
    }

    public AsyncLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        return new NoOpComputeLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, null, Collections.emptyList(), user.getIdentity());
    }

    public List<SearchableField> getSearchableFields() {
        return Collections.emptyList();
    }

    public List<SearchableField> getSearchableAttributes() {
        return Collections.emptyList();
    }

    public Set<String> getContainerNames() {
        return Collections.singleton("noOp");
    }

    public long getContainerCapacity(String s) {
        return 0L;
    }

    public String getContainerFileStoreName(String containerName) {
        return "noOp";
    }

    public long getContainerUsableSpace(String containerName) {
        return 0L;
    }

    public AsyncLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        return new NoOpComputeLineageSubmission(LineageComputationType.EXPAND_PARENTS, null, Collections.emptyList(), user.getIdentity());
    }

    public AsyncLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        return new NoOpComputeLineageSubmission(LineageComputationType.EXPAND_CHILDREN, null, Collections.emptyList(), user.getIdentity());
    }

    private static class NoOpQuerySubmission
    implements QuerySubmission {
        private final Query query;
        private final String submitterId;
        private final Date submissionTime = new Date();

        private NoOpQuerySubmission(Query query, String id) {
            this.query = query;
            this.submitterId = id;
        }

        private NoOpQuerySubmission(String queryId, String id) {
            this.query = new Query(queryId);
            this.submitterId = id;
        }

        public Query getQuery() {
            return this.query;
        }

        public QueryResult getResult() {
            return noOpQueryResult;
        }

        public Date getSubmissionTime() {
            return this.submissionTime;
        }

        public String getQueryIdentifier() {
            return this.query.getIdentifier();
        }

        public void cancel() {
        }

        public boolean isCanceled() {
            return true;
        }

        public String getSubmitterIdentity() {
            return this.submitterId;
        }
    }

    private static class NoOpComputeLineageSubmission
    extends AsyncLineageSubmission {
        public NoOpComputeLineageSubmission(LineageComputationType computationType, Long eventId, Collection<String> lineageFlowFileUuids, String submitterId) {
            super(computationType, eventId, lineageFlowFileUuids, 1, submitterId);
        }

        public boolean isCanceled() {
            return true;
        }
    }
}

