/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.action;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.nifi.action.FlowAction;
import org.apache.nifi.action.FlowActionReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTestFlowActionReporter
implements FlowActionReporter {
    private static final String USER_DIR_PROPERTY = "user.dir";
    private static final Path USER_DIRECTORY = Paths.get(System.getProperty("user.dir"), new String[0]);
    private static final String LOG_FILE_PREFIX = SystemTestFlowActionReporter.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(SystemTestFlowActionReporter.class);

    public void reportFlowActions(Collection<FlowAction> actions) {
        logger.info("Reporting Flow Actions [{}]", (Object)actions.size());
        for (FlowAction flowAction : actions) {
            Map attributes = flowAction.getAttributes();
            String formatted = attributes.toString();
            String filename = "%s.%d.log".formatted(LOG_FILE_PREFIX, System.nanoTime());
            Path log = USER_DIRECTORY.resolve(filename);
            try {
                Files.writeString(log, (CharSequence)formatted, new OpenOption[0]);
            }
            catch (Exception e) {
                logger.warn("Failed to write Flow Action [{}]", (Object)log, (Object)e);
            }
        }
    }

    public void close() {
        logger.info("Clearing Flow Actions from User Directory [{}]", (Object)USER_DIRECTORY);
        try (Stream<Path> userDirectoryPaths = Files.list(USER_DIRECTORY);){
            userDirectoryPaths.filter(path -> path.getFileName().toString().startsWith(LOG_FILE_PREFIX)).forEach(log -> {
                try {
                    Files.delete(log);
                }
                catch (Exception e) {
                    logger.warn("Delete Flow Action Log [{}] failed", log, (Object)e);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to clear User Directory [{}]", (Object)USER_DIRECTORY, (Object)e);
        }
    }
}

