/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class WriteLifecycleEvents
extends AbstractProcessor {
    static final PropertyDescriptor EVENT_FILE = new PropertyDescriptor.Builder().name("Event File").displayName("Event File").description("Specifies the file to write to that contains a line of text for each lifecycle event that occurs").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("target/CountLifecycleEvents.events").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles go here").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(EVENT_FILE);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.writeEvent(context, "OnScheduled");
    }

    @OnUnscheduled
    public void onUnscheduled(ProcessContext context) throws IOException {
        this.writeEvent(context, "OnUnscheduled");
    }

    @OnStopped
    public void onStopped(ProcessContext context) throws IOException {
        this.writeEvent(context, "OnStopped");
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        try {
            this.writeEvent(context, "OnTrigger");
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
    }

    private void writeEvent(ProcessContext context, String event) throws IOException {
        File file = new File(context.getProperty(EVENT_FILE).getValue());
        byte[] eventBytes = (event + "\n").getBytes(StandardCharsets.UTF_8);
        try (FileOutputStream fos = new FileOutputStream(file, true);){
            ((OutputStream)fos).write(eventBytes);
        }
    }
}

