/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.cs.tests.system.SleepService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class Sleep
extends AbstractProcessor {
    public static final PropertyDescriptor VALIDATE_SLEEP_TIME = new PropertyDescriptor.Builder().name("Validate Sleep Time").description("The amount of time to sleep during validation").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_TRIGGER_SLEEP_TIME = new PropertyDescriptor.Builder().name("onTrigger Sleep Time").description("The amount of time to sleep during each trigger").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_SCHEDULED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnScheduled Sleep Time").description("The amount of time to sleep when scheduled").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_STOPPED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnStopped Sleep Time").description("The amount of time to sleep when stopped").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    static final PropertyDescriptor SLEEP_SERVICE = new PropertyDescriptor.Builder().name("Sleep Service").description("Controller Service that sleeps").required(false).identifiesControllerService(SleepService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(VALIDATE_SLEEP_TIME);
        properties.add(ON_SCHEDULED_SLEEP_TIME);
        properties.add(ON_TRIGGER_SLEEP_TIME);
        properties.add(ON_STOPPED_SLEEP_TIME);
        properties.add(SLEEP_SERVICE);
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        long sleepMillis = validationContext.getProperty(VALIDATE_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        this.sleep(sleepMillis);
        return Collections.emptyList();
    }

    private void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @OnScheduled
    public void onEnabled(ProcessContext context) {
        this.sleep(context.getProperty(ON_SCHEDULED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS));
    }

    @OnStopped
    public void onDisabled(ProcessContext context) {
        this.sleep(context.getProperty(ON_STOPPED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long sleepMillis = context.getProperty(ON_TRIGGER_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        this.sleep(sleepMillis);
        SleepService service = (SleepService)context.getProperty(SLEEP_SERVICE).asControllerService(SleepService.class);
        if (service != null) {
            service.sleep();
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

