/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Selects FlowFiles that match the given criteria and transfers them to the 'success' relationship. Then, selects all other FlowFiles and transfers them to the success relationship. Note that this Processor will not work properly if it is scheduled to run while its incoming queue(s) are being populated. This is meant to be used only for purposes of testing in a Stateless execution engine and makes use of FlowFileFilters.")
public class ReOrderFlowFiles
extends AbstractProcessor {
    protected static PropertyDescriptor FIRST_SELECTION_CRITERIA = new PropertyDescriptor.Builder().name("First Group Selection Criteria").description("An Expression Language expression that evaluates to true or false. FlowFiles that evaluate to true will be transferred first; others will be transferred after.").required(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.BOOLEAN, (boolean)false)).build();
    private static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are transferred to this relationship.").build();
    private static final Set<Relationship> relationships = Set.of(REL_SUCCESS);
    private static final List<PropertyDescriptor> properties = List.of(FIRST_SELECTION_CRITERIA);

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        final PropertyValue selectionValue = context.getProperty(FIRST_SELECTION_CRITERIA);
        List matching = session.get(new FlowFileFilter(){

            public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
                boolean selected = selectionValue.evaluateAttributeExpressions(flowFile).asBoolean();
                return selected ? FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE : FlowFileFilter.FlowFileFilterResult.REJECT_AND_CONTINUE;
            }
        });
        List unmatched = session.get(new FlowFileFilter(this){

            public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
                return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
            }
        });
        session.transfer((Collection)matching, REL_SUCCESS);
        session.transfer((Collection)unmatched, REL_SUCCESS);
    }
}

