/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class Duplicate
extends AbstractProcessor {
    public static final PropertyDescriptor OUTPUT_COUNT = new PropertyDescriptor.Builder().name("Output Count").displayName("Output Count").description("The number of FlowFiles to output for each input").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("2").build();
    public Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(OUTPUT_COUNT);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(this.REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile input = session.get();
        if (input == null) {
            return;
        }
        ArrayList<FlowFile> output = new ArrayList<FlowFile>();
        output.add(input);
        for (int i = 0; i < context.getProperty(OUTPUT_COUNT).asInteger() - 1; ++i) {
            output.add(session.clone(input));
        }
        session.transfer(output, this.REL_SUCCESS);
        this.getLogger().info("Duplicated {} to create {} FlowFiles total", new Object[]{input, output.size()});
    }
}

