/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@TriggerWhenEmpty
@DefaultSchedule(period="100 millis")
public class CountPrimaryNodeChangeEvents
extends AbstractSessionFactoryProcessor {
    private static final String nodeNumber = System.getProperty("nodeNumber");
    static final PropertyDescriptor EVENT_SLEEP_DURATION = new PropertyDescriptor.Builder().name("Event Sleep Duration").displayName("Event Sleep Duration").description("The amount of time to sleep when the onPrimaryNodeChange event occurs").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    private final AtomicReference<ProcessSession> sessionReference = new AtomicReference();
    private volatile long sleepMillis = 0L;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(EVENT_SLEEP_DURATION);
    }

    @OnPrimaryNodeStateChange
    public void onPrimaryNodeChange() {
        ProcessSession session = this.sessionReference.get();
        if (session == null) {
            return;
        }
        session.adjustCounter("PrimaryNodeChangeCalled-" + nodeNumber, 1L, true);
        try {
            Thread.sleep(this.sleepMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        session.adjustCounter("PrimaryNodeChangeCompleted-" + nodeNumber, 1L, true);
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession current = this.sessionReference.get();
        if (current == null) {
            ProcessSession session = sessionFactory.createSession();
            this.sessionReference.compareAndSet(null, session);
        }
        this.sleepMillis = context.getProperty(EVENT_SLEEP_DURATION).asTimePeriod(TimeUnit.MILLISECONDS);
        this.sessionReference.get().adjustCounter("Triggers-" + nodeNumber, 1L, true);
    }
}

