/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.cs.tests.system.KeyProviderService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

@RequiresInstanceClassLoading(cloneAncestorResources=true)
public class ClassloaderIsolationWithServiceProperty
extends AbstractProcessor
implements ClassloaderIsolationKeyProvider {
    public static final PropertyDescriptor KEY_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("Key Provider Service").identifiesControllerService(KeyProviderService.class).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(KEY_PROVIDER_SERVICE);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String classLoaderInstance = ((Object)((Object)this)).getClass().getClassLoader().toString();
        flowFile = session.putAttribute(flowFile, "classloader.instance", classLoaderInstance);
        session.transfer(flowFile, REL_SUCCESS);
    }

    public String getClassloaderIsolationKey(PropertyContext context) {
        KeyProviderService service = (KeyProviderService)context.getProperty(KEY_PROVIDER_SERVICE).asControllerService(KeyProviderService.class);
        return service.getKeyField();
    }
}

