/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderInitializationContext;
import org.apache.nifi.flow.resource.ImmutableExternalResourceDescriptor;

public class LocalDirectoryNarProvider
implements ExternalResourceProvider {
    private static final String SOURCE_DIR_PROPERTY = "source.dir";
    private File sourceDir;

    public void initialize(ExternalResourceProviderInitializationContext context) {
        String sourceDirValue = (String)context.getProperties().get(SOURCE_DIR_PROPERTY);
        if (sourceDirValue == null) {
            throw new IllegalStateException("source.dir is required");
        }
        this.sourceDir = new File(sourceDirValue);
        if (!this.sourceDir.exists()) {
            throw new IllegalStateException("Local NAR directory does not exist at: " + this.sourceDir.getAbsolutePath());
        }
    }

    public Collection<ExternalResourceDescriptor> listResources() throws IOException {
        return Arrays.stream(this.sourceDir.listFiles((dir, name) -> name.endsWith(".nar"))).map(this::createDescriptor).collect(Collectors.toList());
    }

    private ExternalResourceDescriptor createDescriptor(File file) {
        return new ImmutableExternalResourceDescriptor(file.getName(), file.lastModified());
    }

    public InputStream fetchExternalResource(ExternalResourceDescriptor descriptor) throws IOException {
        File file = new File(this.sourceDir, descriptor.getLocation());
        return new FileInputStream(file);
    }
}

