/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.repository.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.engine.StatelessNodeTypeProvider;

public class StatelessProcessContextFactory
implements ProcessContextFactory {
    private static final NodeTypeProvider NODE_TYPE_PROVIDER = new StatelessNodeTypeProvider();
    private final ControllerServiceProvider controllerServiceProvider;
    private final StateManagerProvider stateManagerProvider;

    public StatelessProcessContextFactory(ControllerServiceProvider controllerServiceProvider, StateManagerProvider stateManagerProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
        this.stateManagerProvider = stateManagerProvider;
    }

    @Override
    public ProcessContext createProcessContext(Connectable connectable) {
        StateManager stateManager = this.stateManagerProvider.getStateManager(connectable.getIdentifier());
        if (connectable instanceof ProcessorNode) {
            ProcessorNode processor = (ProcessorNode)connectable;
            return new StandardProcessContext(processor, this.controllerServiceProvider, stateManager, () -> false, NODE_TYPE_PROVIDER);
        }
        return new ConnectableProcessContext(connectable, stateManager);
    }
}

