/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis.rules.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flowanalysis.GroupAnalysisResult;
import org.apache.nifi.flowanalysis.rules.util.ConnectionViolation;

public class FlowAnalysisRuleUtils {
    public static Map<String, VersionedComponent> gatherComponents(VersionedProcessGroup group) {
        return Stream.of(group.getFunnels().stream(), group.getProcessors().stream(), group.getInputPorts().stream(), group.getOutputPorts().stream()).flatMap(c -> c).collect(Collectors.toMap(VersionedComponent::getIdentifier, Function.identity()));
    }

    public static Collection<GroupAnalysisResult> convertToGroupAnalysisResults(VersionedProcessGroup pg, Collection<ConnectionViolation> violations) {
        if (!violations.isEmpty()) {
            Map<String, VersionedComponent> components = FlowAnalysisRuleUtils.gatherComponents(pg);
            HashSet<GroupAnalysisResult> results = new HashSet<GroupAnalysisResult>();
            violations.forEach(violation -> results.add(violation.convertToGroupAnalysisResult(components)));
            return results;
        }
        return Collections.emptySet();
    }
}

