/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis.rules.util;

import java.util.Map;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flowanalysis.GroupAnalysisResult;
import org.apache.nifi.flowanalysis.rules.util.ViolationType;
import org.apache.nifi.util.StringUtils;

public class ConnectionViolation {
    private final VersionedConnection connection;
    private final ViolationType violationType;
    private final String rule;
    private final String configuredValue;
    private final String ruleLimit;

    public ConnectionViolation(VersionedConnection connection, ViolationType violationType, String rule, String configuredValue, String ruleLimit) {
        this.connection = connection;
        this.violationType = violationType;
        this.rule = rule;
        this.configuredValue = configuredValue;
        this.ruleLimit = ruleLimit;
    }

    public GroupAnalysisResult convertToGroupAnalysisResult(Map<String, VersionedComponent> components) {
        VersionedComponent source = components.get(this.connection.getSource().getId());
        VersionedComponent destination = components.get(this.connection.getDestination().getId());
        return GroupAnalysisResult.forComponent((VersionedComponent)this.assignConnectionViolationToComponent(this.connection, source, destination), (String)(this.connection.getIdentifier() + "_" + this.violationType.getId()), (String)(this.getConnectionLocationMessage(this.connection, source, destination, this.rule) + " " + this.getViolationReason())).build();
    }

    private VersionedComponent assignConnectionViolationToComponent(VersionedConnection connection, VersionedComponent source, VersionedComponent destination) {
        if (!(source instanceof VersionedProcessor) && !(destination instanceof VersionedProcessor)) {
            return connection;
        }
        if (source instanceof VersionedProcessor) {
            return source;
        }
        return destination;
    }

    private String getViolationReason() {
        return String.format("The connection is configured with a %s of %s which %s %s.", this.violationType.getConfigurationItem(), this.configuredValue, this.violationType.getViolationMessage(), this.ruleLimit);
    }

    private String getConnectionLocationMessage(VersionedConnection connection, VersionedComponent source, VersionedComponent destination, String rule) {
        StringBuilder message = new StringBuilder();
        message.append("The connection ");
        if (StringUtils.isNotEmpty((String)connection.getName())) {
            message.append(connection.getName()).append(' ');
        } else {
            String relationships = String.join((CharSequence)",", connection.getSelectedRelationships());
            if (StringUtils.isNotEmpty((String)relationships)) {
                message.append(relationships).append(' ');
            }
        }
        message.append("[").append(connection.getIdentifier()).append("]");
        if (source != null) {
            String sourceName = source instanceof VersionedFunnel ? "funnel" : source.getName();
            message.append(" from source ").append(sourceName).append(" [").append(source.getIdentifier()).append("]");
        }
        if (destination != null) {
            String destinationName = destination instanceof VersionedFunnel ? "funnel" : destination.getName();
            message.append(" to destination ").append(destinationName).append(" [").append(destination.getIdentifier()).append("]");
        }
        message.append(" violates the ").append(rule).append(" rule.");
        return message.toString();
    }
}

