/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.file.transfer.FileInfo;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processor.util.file.transfer.PermissionDeniedException;
import org.apache.nifi.processors.standard.ftp.FTPClientProvider;
import org.apache.nifi.processors.standard.ftp.StandardFTPClientProvider;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.stream.io.StreamUtils;

public class FTPTransfer
implements FileTransfer {
    public static final String CONNECTION_MODE_ACTIVE = "Active";
    public static final String CONNECTION_MODE_PASSIVE = "Passive";
    public static final String TRANSFER_MODE_ASCII = "ASCII";
    public static final String TRANSFER_MODE_BINARY = "Binary";
    public static final String FTP_TIMEVAL_FORMAT = "yyyyMMddHHmmss";
    public static final String OBSOLETE_UTF8_ENCODING = "ftp-use-utf8";
    private static final String OBSOLETE_PROXY_TYPE = "Proxy Type";
    private static final String OBSOLETE_PROXY_HOST = "Proxy Host";
    private static final String OBSOLETE_PROXY_PORT = "Proxy Port";
    private static final String OBSOLETE_PROXY_USERNAME = "Http Proxy Username";
    private static final String OBSOLETE_PROXY_PASSWORD = "Http Proxy Password";
    public static final PropertyDescriptor CONNECTION_MODE = new PropertyDescriptor.Builder().name("Connection Mode").description("The FTP Connection Mode").allowableValues(new String[]{"Active", "Passive"}).defaultValue("Passive").build();
    public static final PropertyDescriptor TRANSFER_MODE = new PropertyDescriptor.Builder().name("Transfer Mode").description("The FTP Transfer Mode").allowableValues(new String[]{"Binary", "ASCII"}).defaultValue("Binary").build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port that the remote system is listening on for file transfers").addValidator(StandardValidators.PORT_VALIDATOR).required(true).defaultValue("21").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor BUFFER_SIZE = new PropertyDescriptor.Builder().name("Internal Buffer Size").description("Set the internal buffer size for buffered data streams").defaultValue("16KB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor UTF8_ENCODING = new PropertyDescriptor.Builder().name("Use UTF-8 Encoding").description("Tells the client to use UTF-8 encoding when processing files and filenames. If set to true, the server must also support UTF-8 encoding.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    private static final int REPLY_CODE_FILE_UNAVAILABLE = 550;
    private static final Pattern NOT_FOUND_MESSAGE_PATTERN = Pattern.compile("(no such)|(not exist)|(not found)", 2);
    private static final FTPClientProvider FTP_CLIENT_PROVIDER = new StandardFTPClientProvider();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])PROXY_SPECS);
    private final ComponentLog logger;
    private final ProcessContext ctx;
    private boolean closed = true;
    private FTPClient client;
    private String homeDirectory;
    private String remoteHostName;
    private String remotePort;
    private String remoteUsername;
    private String remotePassword;

    public FTPTransfer(ProcessContext context, ComponentLog logger) {
        this.ctx = context;
        this.logger = logger;
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    public static void migrateProxyProperties(PropertyConfiguration config) {
        ProxyServiceMigration.migrateProxyProperties((PropertyConfiguration)config, (PropertyDescriptor)PROXY_CONFIGURATION_SERVICE, (String)OBSOLETE_PROXY_TYPE, (String)OBSOLETE_PROXY_HOST, (String)OBSOLETE_PROXY_PORT, (String)OBSOLETE_PROXY_USERNAME, (String)OBSOLETE_PROXY_PASSWORD);
    }

    public String getProtocolName() {
        return "ftp";
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (null != this.client) {
                this.client.disconnect();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close FTPClient", (Throwable)ex);
        }
        this.client = null;
    }

    public String getHomeDirectory(FlowFile flowFile) throws IOException {
        this.getClient(flowFile);
        return this.homeDirectory;
    }

    public List<FileInfo> getListing(boolean applyFilters) throws IOException {
        String path = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean depth = false;
        int maxResults = this.ctx.getProperty(FileTransfer.REMOTE_POLL_BATCH_SIZE).asInteger();
        return this.getListing(path, 0, maxResults, applyFilters);
    }

    private List<FileInfo> getListing(String path, int depth, int maxResults, boolean applyFilters) throws IOException {
        boolean cdSuccessful;
        ArrayList<FileInfo> listing = new ArrayList<FileInfo>();
        if (maxResults < 1) {
            return listing;
        }
        if (depth >= 100) {
            this.logger.warn("{} had to stop recursively searching directories at a recursive depth of {} to avoid memory issues", new Object[]{this, depth});
            return listing;
        }
        boolean ignoreDottedFiles = this.ctx.getProperty(FileTransfer.IGNORE_DOTTED_FILES).asBoolean();
        boolean recurse = this.ctx.getProperty(FileTransfer.RECURSIVE_SEARCH).asBoolean();
        boolean symlink = this.ctx.getProperty(FileTransfer.FOLLOW_SYMLINK).asBoolean();
        String fileFilterRegex = this.ctx.getProperty(FileTransfer.FILE_FILTER_REGEX).getValue();
        Pattern pattern = fileFilterRegex == null ? null : Pattern.compile(fileFilterRegex);
        String pathFilterRegex = this.ctx.getProperty(FileTransfer.PATH_FILTER_REGEX).getValue();
        Pattern pathPattern = !recurse || pathFilterRegex == null ? null : Pattern.compile(pathFilterRegex);
        String remotePath = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean pathFilterMatches = true;
        if (pathPattern != null) {
            Path reldir;
            Path path2 = reldir = path == null ? Paths.get(".", new String[0]) : Paths.get(path, new String[0]);
            if (remotePath != null) {
                reldir = Paths.get(remotePath, new String[0]).relativize(reldir);
            }
            if (reldir != null && !reldir.toString().isEmpty() && !pathPattern.matcher(reldir.toString().replace("\\", "/")).matches()) {
                pathFilterMatches = false;
            }
        }
        FTPClient client = this.getClient(null);
        int count = 0;
        FTPFile[] files = path == null || path.isBlank() ? client.listFiles(".") : client.listFiles(path);
        if (files.length == 0 && path != null && !path.isBlank() && !(cdSuccessful = this.setWorkingDirectory(path))) {
            throw new IOException("Cannot list files for non-existent directory " + path);
        }
        for (FTPFile file : files) {
            String filename = file.getName();
            if (filename.equals(".") || filename.equals("..") || ignoreDottedFiles && filename.startsWith(".")) continue;
            File newFullPath = new File(path, filename);
            String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
            if (recurse && file.isDirectory() || symlink && file.isSymbolicLink()) {
                try {
                    listing.addAll(this.getListing(newFullForwardPath, depth + 1, maxResults - count, applyFilters));
                }
                catch (IOException e) {
                    this.logger.error("Unable to get listing from {}; skipping", new Object[]{newFullForwardPath, e});
                }
            }
            if (!(file.isDirectory() || file.isSymbolicLink() || !pathFilterMatches && applyFilters || pattern != null && applyFilters && !pattern.matcher(filename).matches())) {
                listing.add(this.newFileInfo(file, path));
                ++count;
            }
            if (count >= maxResults) break;
        }
        return listing;
    }

    private FileInfo newFileInfo(FTPFile file, String path) {
        if (file == null) {
            return null;
        }
        File newFullPath = new File(path, file.getName());
        String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
        StringBuilder perms = new StringBuilder();
        perms.append(file.hasPermission(0, 0) ? "r" : "-");
        perms.append(file.hasPermission(0, 1) ? "w" : "-");
        perms.append(file.hasPermission(0, 2) ? "x" : "-");
        perms.append(file.hasPermission(1, 0) ? "r" : "-");
        perms.append(file.hasPermission(1, 1) ? "w" : "-");
        perms.append(file.hasPermission(1, 2) ? "x" : "-");
        perms.append(file.hasPermission(2, 0) ? "r" : "-");
        perms.append(file.hasPermission(2, 1) ? "w" : "-");
        perms.append(file.hasPermission(2, 2) ? "x" : "-");
        long lastModifiedTime = file.getTimestamp() != null ? file.getTimestamp().getTimeInMillis() : 0L;
        FileInfo.Builder builder = new FileInfo.Builder().filename(file.getName()).fullPathFileName(newFullForwardPath).directory(file.isDirectory()).size(file.getSize()).lastModifiedTime(lastModifiedTime).permissions(perms.toString()).owner(file.getUser()).group(file.getGroup());
        return builder.build();
    }

    public FlowFile getRemoteFile(String remoteFileName, FlowFile origFlowFile, ProcessSession session) throws ProcessException, IOException {
        FTPClient client = this.getClient(origFlowFile);
        try (InputStream in = client.retrieveFileStream(remoteFileName);){
            if (in == null) {
                String reply = client.getReplyString();
                if (reply == null) {
                    throw new IOException("Retrieve File Failed: FTP server response not found");
                }
                int replyCode = client.getReplyCode();
                if (550 == replyCode) {
                    if (NOT_FOUND_MESSAGE_PATTERN.matcher(reply).find()) {
                        throw new FileNotFoundException(reply);
                    }
                    throw new PermissionDeniedException(reply);
                }
                throw new IOException(reply);
            }
            FlowFile resultFlowFile = session.write(origFlowFile, out -> StreamUtils.copy((InputStream)in, (OutputStream)out));
            client.completePendingCommand();
            FlowFile flowFile = resultFlowFile;
            return flowFile;
        }
    }

    public FileInfo getRemoteFileInfo(FlowFile flowFile, String path, String remoteFileName) throws IOException {
        FTPClient client = this.getClient(flowFile);
        if (path == null) {
            int slashpos = remoteFileName.lastIndexOf(47);
            if (slashpos >= 0 && !remoteFileName.endsWith("/")) {
                path = remoteFileName.substring(0, slashpos);
                remoteFileName = remoteFileName.substring(slashpos + 1);
            } else {
                path = "";
            }
        }
        FTPFile[] files = client.listFiles(path);
        FTPFile matchingFile = null;
        for (FTPFile file : files) {
            if (!file.getName().equalsIgnoreCase(remoteFileName)) continue;
            matchingFile = file;
            break;
        }
        if (matchingFile == null) {
            return null;
        }
        return this.newFileInfo(matchingFile, path);
    }

    public void ensureDirectoryExists(FlowFile flowFile, File directoryName) throws IOException {
        if (directoryName.getParent() != null && !directoryName.getParentFile().equals(new File(File.separator))) {
            this.ensureDirectoryExists(flowFile, directoryName.getParentFile());
        }
        String remoteDirectory = directoryName.getAbsolutePath().replace("\\", "/").replaceAll("^.\\:", "");
        FTPClient client = this.getClient(flowFile);
        boolean cdSuccessful = this.setWorkingDirectory(remoteDirectory);
        if (!cdSuccessful) {
            if (client.makeDirectory(remoteDirectory)) {
                this.logger.debug("Remote Directory not found: created directory [{}]", new Object[]{remoteDirectory});
            } else if (!this.setWorkingDirectory(remoteDirectory)) {
                throw new IOException("Failed to create remote directory " + remoteDirectory);
            }
        }
    }

    private String setAndGetWorkingDirectory(String path) throws IOException {
        this.client.changeWorkingDirectory(this.homeDirectory);
        if (!this.client.changeWorkingDirectory(path)) {
            throw new ProcessException("Unable to change working directory to " + path);
        }
        return this.client.printWorkingDirectory();
    }

    private boolean setWorkingDirectory(String path) throws IOException {
        this.client.changeWorkingDirectory(this.homeDirectory);
        return this.client.changeWorkingDirectory(path);
    }

    private boolean resetWorkingDirectory() throws IOException {
        return this.client.changeWorkingDirectory(this.homeDirectory);
    }

    public String put(FlowFile flowFile, String path, String filename, InputStream content) throws IOException {
        String permissions;
        boolean storeSuccessful;
        String workingDir;
        FTPClient client = this.getClient(flowFile);
        Object fullPath = path == null ? filename : ((workingDir = this.setAndGetWorkingDirectory(path)).endsWith("/") ? workingDir + filename : workingDir + "/" + filename);
        Object tempFilename = this.ctx.getProperty(TEMP_FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        if (tempFilename == null) {
            boolean dotRename = this.ctx.getProperty(DOT_RENAME).asBoolean();
            Object object = tempFilename = dotRename ? "." + filename : filename;
        }
        if (!(storeSuccessful = client.storeFile((String)tempFilename, content))) {
            throw new IOException("Failed to store file " + (String)tempFilename + " to " + (String)fullPath + " due to: " + client.getReplyString());
        }
        String lastModifiedTime = this.ctx.getProperty(LAST_MODIFIED_TIME).evaluateAttributeExpressions(flowFile).getValue();
        if (lastModifiedTime != null && !lastModifiedTime.isBlank()) {
            try {
                DateTimeFormatter informat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                OffsetDateTime fileModifyTime = OffsetDateTime.parse(lastModifiedTime, informat);
                DateTimeFormatter outformat = DateTimeFormatter.ofPattern(FTP_TIMEVAL_FORMAT, Locale.US);
                String time = outformat.format(fileModifyTime);
                if (!client.setModificationTime((String)tempFilename, time)) {
                    this.logger.warn("Could not set lastModifiedTime on {} to {}", new Object[]{flowFile, lastModifiedTime});
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to set lastModifiedTime on {} to {}", new Object[]{flowFile, lastModifiedTime, e});
            }
        }
        if ((permissions = this.ctx.getProperty(PERMISSIONS).evaluateAttributeExpressions(flowFile).getValue()) != null && !permissions.isBlank()) {
            try {
                int perms = this.numberPermissions(permissions);
                if (perms >= 0 && !client.sendSiteCommand("chmod " + Integer.toOctalString(perms) + " " + (String)tempFilename)) {
                    this.logger.warn("Could not set permission on {} to {}", new Object[]{flowFile, permissions});
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to set permission on {} to {}", new Object[]{flowFile, permissions, e});
            }
        }
        if (!filename.equals(tempFilename)) {
            try {
                client.deleteFile((String)fullPath);
            }
            catch (IOException e) {
                this.logger.debug("Failed to remove {} before renaming temporary file", new Object[]{fullPath, e});
            }
            try {
                this.logger.debug("Renaming remote path from {} to {} for {}", new Object[]{tempFilename, filename, flowFile});
                boolean renameSuccessful = client.rename((String)tempFilename, filename);
                if (!renameSuccessful) {
                    throw new IOException("Failed to rename temporary file " + (String)tempFilename + " to " + (String)fullPath + " due to: " + client.getReplyString());
                }
            }
            catch (IOException e) {
                try {
                    client.deleteFile((String)tempFilename);
                    throw e;
                }
                catch (IOException e1) {
                    throw new IOException("Failed to rename temporary file " + (String)tempFilename + " to " + (String)fullPath + " and failed to delete it when attempting to clean up", e1);
                }
            }
        }
        return fullPath;
    }

    public void rename(FlowFile flowFile, String source, String target) throws IOException {
        FTPClient client = this.getClient(flowFile);
        boolean renameSuccessful = client.rename(source, target);
        if (!renameSuccessful) {
            throw new IOException("Failed to rename temporary file " + source + " to " + target + " due to: " + client.getReplyString());
        }
    }

    public void deleteFile(FlowFile flowFile, String path, String remoteFileName) throws IOException {
        FTPClient client = this.getClient(flowFile);
        if (path != null) {
            this.setWorkingDirectory(path);
        }
        if (!client.deleteFile(remoteFileName)) {
            throw new IOException("Failed to remove file " + remoteFileName + " due to " + client.getReplyString());
        }
    }

    public void deleteDirectory(FlowFile flowFile, String remoteDirectoryName) throws IOException {
        FTPClient client = this.getClient(flowFile);
        boolean success = client.removeDirectory(remoteDirectoryName);
        if (!success) {
            throw new IOException("Failed to remove directory " + remoteDirectoryName + " due to " + client.getReplyString());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void sendCommands(List<String> commands, FlowFile flowFile) throws IOException {
        if (commands.isEmpty()) {
            return;
        }
        FTPClient client = this.getClient(flowFile);
        for (String cmd : commands) {
            if (cmd.isEmpty()) continue;
            int result = client.sendCommand(cmd);
            this.logger.debug("{} sent command to the FTP server: {} for {}", new Object[]{this, cmd, flowFile});
            if (!FTPReply.isNegativePermanent((int)result) && !FTPReply.isNegativeTransient((int)result)) continue;
            throw new IOException(String.valueOf(this) + " negative reply back from FTP server cmd: " + cmd + " reply:" + result + ": " + client.getReplyString() + " for " + String.valueOf(flowFile));
        }
    }

    protected FTPClient createClient(PropertyContext context, Map<String, String> attributes) {
        return FTP_CLIENT_PROVIDER.getClient(context, attributes);
    }

    private FTPClient getClient(FlowFile flowFile) throws IOException {
        String hostname = this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue();
        String port = this.ctx.getProperty(PORT).evaluateAttributeExpressions(flowFile).getValue();
        String username = this.ctx.getProperty(FileTransfer.USERNAME).evaluateAttributeExpressions(flowFile).getValue();
        String password = this.ctx.getProperty(FileTransfer.PASSWORD).evaluateAttributeExpressions(flowFile).getValue();
        if (this.client != null) {
            if (Objects.equals(this.remoteHostName, hostname) && Objects.equals(this.remotePort, port) && Objects.equals(this.remoteUsername, username) && Objects.equals(this.remotePassword, password)) {
                this.resetWorkingDirectory();
                return this.client;
            }
            this.close();
        }
        Map attributes = flowFile == null ? Collections.emptyMap() : flowFile.getAttributes();
        this.client = this.createClient((PropertyContext)this.ctx, attributes);
        this.remoteHostName = hostname;
        this.remotePort = port;
        this.remoteUsername = username;
        this.remotePassword = password;
        this.closed = false;
        this.homeDirectory = this.client.printWorkingDirectory();
        return this.client;
    }

    protected int numberPermissions(String perms) {
        int number = -1;
        Pattern rwxPattern = Pattern.compile("^[rwx-]{9}$");
        Pattern numPattern = Pattern.compile("\\d+");
        if (rwxPattern.matcher(perms).matches()) {
            number = 0;
            if (perms.charAt(0) == 'r') {
                number |= 0x100;
            }
            if (perms.charAt(1) == 'w') {
                number |= 0x80;
            }
            if (perms.charAt(2) == 'x') {
                number |= 0x40;
            }
            if (perms.charAt(3) == 'r') {
                number |= 0x20;
            }
            if (perms.charAt(4) == 'w') {
                number |= 0x10;
            }
            if (perms.charAt(5) == 'x') {
                number |= 8;
            }
            if (perms.charAt(6) == 'r') {
                number |= 4;
            }
            if (perms.charAt(7) == 'w') {
                number |= 2;
            }
            if (perms.charAt(8) == 'x') {
                number |= 1;
            }
        } else if (numPattern.matcher(perms).matches()) {
            try {
                number = Integer.parseInt(perms, 8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }
}

