/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.processors.standard.util.XmlElementNotifier;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSplitterSaxParser
extends DefaultHandler {
    private final XmlElementNotifier notifier;
    private final AtomicInteger splitDepth;
    private final StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    public Locator locator;
    private final AtomicInteger depth = new AtomicInteger(0);

    public XmlSplitterSaxParser(XmlElementNotifier notifier) {
        this.notifier = notifier;
        this.splitDepth = new AtomicInteger(1);
    }

    public XmlSplitterSaxParser(XmlElementNotifier notifier, int splitDepth) {
        this.notifier = notifier;
        this.splitDepth = new AtomicInteger(splitDepth);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        block7: for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    this.sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    continue block7;
                }
                default: {
                    this.sb.append(c);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.sb.append("</").append(qName).append(">");
        int newDepth = this.depth.decrementAndGet();
        if (newDepth == this.splitDepth.get()) {
            String elementTree = this.sb.toString();
            this.notifier.onXmlElementFound(elementTree);
            this.sb.setLength(38);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int newDepth = this.depth.incrementAndGet();
        if (newDepth > this.splitDepth.get()) {
            this.sb.append("<");
            this.sb.append(qName);
            int attCount = atts.getLength();
            for (int i = 0; i < attCount; ++i) {
                String attName = atts.getQName(i);
                String attValue = atts.getValue(i);
                this.sb.append(" ").append(attName).append("=").append("\"").append(attValue).append("\"");
            }
            this.sb.append(">");
        }
    }
}

