/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.lang.invoke.CallSite;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.impl.GenericDatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public class MySQLDatabaseAdapter
extends GenericDatabaseAdapter {
    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public String getDescription() {
        return "Generates MySQL compatible SQL";
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsInsertIgnore() {
        return true;
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        ArrayList<CallSite> updateValues = new ArrayList<CallSite>();
        for (String columnName : columnNames) {
            updateValues.add((CallSite)((Object)(columnName + " = ?")));
        }
        String parameterizedUpdateValues = String.join((CharSequence)", ", updateValues);
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON DUPLICATE KEY UPDATE ").append(parameterizedUpdateValues);
        return statementStringBuilder.toString();
    }

    @Override
    public String getInsertIgnoreStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        StringBuilder statementStringBuilder = new StringBuilder("INSERT IGNORE INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")");
        return statementStringBuilder.toString();
    }

    @Override
    public boolean supportsCreateTableIfNotExists() {
        return true;
    }

    @Override
    public String getAlterTableStatement(String tableName, List<ColumnDescription> columnsToAdd) {
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder("ADD COLUMN ").append(column.getColumnName()).append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        StringBuilder alterTableStatement = new StringBuilder();
        return alterTableStatement.append("ALTER TABLE ").append(tableName).append(" ").append(String.join((CharSequence)", ", columnsAndDatatypes)).toString();
    }

    @Override
    public String getSQLForDataType(int sqlType) {
        switch (sqlType) {
            case 8: {
                return "DOUBLE PRECISION";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: 
            case 2009: 
            case 2011: {
                return "TEXT";
            }
        }
        return JDBCType.valueOf(sqlType).getName();
    }
}

