/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.palindromicity.syslog.KeyProvider;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.ListenSyslog;
import org.apache.nifi.processors.standard.ParseSyslog;
import org.apache.nifi.processors.standard.PutSyslog;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.events.Syslog5424Event;
import org.apache.nifi.syslog.keyproviders.SyslogPrefixedKeyProvider;
import org.apache.nifi.syslog.parsers.StrictSyslog5424Parser;
import org.apache.nifi.syslog.utils.NifiStructuredDataPolicy;
import org.apache.nifi.syslog.utils.NilHandlingPolicy;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"logs", "syslog", "syslog5424", "attributes", "system", "event", "message"})
@CapabilityDescription(value="Attempts to parse the contents of a well formed Syslog message in accordance to RFC5424 format and adds attributes to the FlowFile for each of the parts of the Syslog message, including Structured Data.Structured Data will be written to attributes as one attribute per item id + parameter see https://tools.ietf.org/html/rfc5424.Note: ParseSyslog5424 follows the specification more closely than ParseSyslog.  If your Syslog producer does not follow the spec closely, with regards to using '-' for missing header entries for example, those logs will fail with this parser, where they would not fail with ParseSyslog.")
@WritesAttributes(value={@WritesAttribute(attribute="syslog.priority", description="The priority of the Syslog message."), @WritesAttribute(attribute="syslog.severity", description="The severity of the Syslog message derived from the priority."), @WritesAttribute(attribute="syslog.facility", description="The facility of the Syslog message derived from the priority."), @WritesAttribute(attribute="syslog.version", description="The optional version from the Syslog message."), @WritesAttribute(attribute="syslog.timestamp", description="The timestamp of the Syslog message."), @WritesAttribute(attribute="syslog.hostname", description="The hostname or IP address of the Syslog message."), @WritesAttribute(attribute="syslog.appname", description="The appname of the Syslog message."), @WritesAttribute(attribute="syslog.procid", description="The procid of the Syslog message."), @WritesAttribute(attribute="syslog.messageid", description="The messageid the Syslog message."), @WritesAttribute(attribute="syslog.structuredData", description="Multiple entries per structuredData of the Syslog message."), @WritesAttribute(attribute="syslog.sender", description="The hostname of the Syslog server that sent the message."), @WritesAttribute(attribute="syslog.body", description="The body of the Syslog message, everything after the hostname.")})
@SeeAlso(value={ListenSyslog.class, ParseSyslog.class, PutSyslog.class})
public class ParseSyslog5424
extends AbstractProcessor {
    public static final AllowableValue OMIT = new AllowableValue(NilHandlingPolicy.OMIT.name(), NilHandlingPolicy.OMIT.name(), "The missing field will not have an attribute added.");
    public static final AllowableValue NULL = new AllowableValue(NilHandlingPolicy.NULL.name(), NilHandlingPolicy.NULL.name(), "The missing field will have an empty attribute added.");
    public static final AllowableValue DASH = new AllowableValue(NilHandlingPolicy.DASH.name(), NilHandlingPolicy.DASH.name(), "The missing field will have an attribute added with the value of '-'.");
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("Specifies which character set of the Syslog messages").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    public static final PropertyDescriptor NIL_POLICY = new PropertyDescriptor.Builder().name("nil_policy").displayName("NIL Policy").description("Defines how NIL values are handled for header fields.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).allowableValues(new DescribedValue[]{OMIT, NULL, DASH}).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue(NULL.getValue()).build();
    public static final PropertyDescriptor INCLUDE_BODY_IN_ATTRIBUTES = new PropertyDescriptor.Builder().name("include_policy").displayName("Include Message Body in Attributes").description("If true, then the Syslog Message body will be included in the attributes.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).defaultValue("true").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CHARSET, NIL_POLICY, INCLUDE_BODY_IN_ATTRIBUTES);
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that could not be parsed as a Syslog message will be transferred to this Relationship without any attributes being added").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that is successfully parsed as a Syslog message will be to this Relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_FAILURE, REL_SUCCESS);
    private volatile StrictSyslog5424Parser parser;
    private volatile Charset charset;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.charset = Charset.forName(context.getProperty(CHARSET).getValue());
        String nilPolicyString = context.getProperty(NIL_POLICY).getValue();
        this.parser = new StrictSyslog5424Parser(NilHandlingPolicy.valueOf((String)nilPolicyString), NifiStructuredDataPolicy.FLATTEN, (KeyProvider)new SyslogPrefixedKeyProvider());
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Syslog5424Event syslogEvent;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        boolean includeBody = true;
        if (context.getProperty(INCLUDE_BODY_IN_ATTRIBUTES).isSet()) {
            includeBody = context.getProperty(INCLUDE_BODY_IN_ATTRIBUTES).asBoolean();
        }
        byte[] buffer = new byte[(int)flowFile.getSize()];
        session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])buffer));
        String line = new String(buffer, this.charset).trim();
        try {
            syslogEvent = this.parser.parseEvent(line);
        }
        catch (ProcessException pe) {
            this.getLogger().error("Failed to parse {} as a Syslog 5424  message; routing to failure", new Object[]{flowFile, pe});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (syslogEvent == null || !syslogEvent.isValid()) {
            this.getLogger().error("Failed to parse {} as a Syslog message: it does not conform to any of the RFC formats supported; routing to failure", new Object[]{flowFile});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        Map<String, String> attributeMap = ParseSyslog5424.convertMap(syslogEvent.getFieldMap());
        if (!includeBody) {
            attributeMap.remove(SyslogAttributes.SYSLOG_BODY.key());
        }
        flowFile = session.putAllAttributes(flowFile, attributeMap);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private static Map<String, String> convertMap(Map<String, Object> map) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        map.forEach((key, value) -> returnMap.put((String)key, (String)value));
        return returnMap;
    }
}

