/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.net.Proxy;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.proxy.ProxyConfiguration;

public class HTTPUtils {
    public static final String HTTP_REQUEST_URI = "http.request.uri";
    public static final String HTTP_REMOTE_HOST = "http.remote.host";
    public static final String HTTP_LOCAL_NAME = "http.local.name";
    public static final String HTTP_PORT = "http.server.port";
    public static final String HTTP_SSL_CERT = "http.subject.dn";
    public static final String HTTP_CONTEXT_ID = "http.context.identifier";

    public static String getURI(Map<String, String> map) {
        String client = map.get(HTTP_REMOTE_HOST);
        String server = map.get(HTTP_LOCAL_NAME);
        String port = map.get(HTTP_PORT);
        String uri = map.get(HTTP_REQUEST_URI);
        if (map.get(HTTP_SSL_CERT) == null) {
            return "http://" + client + "@" + server + ":" + port + uri;
        }
        return "https://" + client + "@" + server + ":" + port + uri;
    }

    public static void setProxy(ProcessContext context, HttpClientBuilder clientBuilder, CredentialsProvider credentialsProvider) {
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context);
        if (Proxy.Type.HTTP.equals((Object)proxyConfig.getProxyType())) {
            String host = proxyConfig.getProxyServerHost();
            int port = proxyConfig.getProxyServerPort();
            clientBuilder.setProxy(new HttpHost(host, port));
            if (proxyConfig.hasCredential()) {
                AuthScope proxyAuthScope = new AuthScope(host, port);
                UsernamePasswordCredentials proxyCredential = new UsernamePasswordCredentials(proxyConfig.getProxyUserName(), proxyConfig.getProxyUserPassword());
                credentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredential);
            }
        }
    }
}

