/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.BatchUpdateException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.StandardColumnDefinition;
import org.apache.nifi.database.dialect.service.api.StandardStatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.RollbackOnFailure;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapterDescriptor;
import org.apache.nifi.processors.standard.db.NameNormalizer;
import org.apache.nifi.processors.standard.db.NameNormalizerFactory;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.processors.standard.db.TranslationStrategy;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"sql", "record", "jdbc", "put", "database", "update", "insert", "delete"})
@CapabilityDescription(value="The PutDatabaseRecord processor uses a specified RecordReader to input (possibly multiple) records from an incoming flow file. These records are translated to SQL statements and executed as a single transaction. If any errors occur, the flow file is routed to failure or retry, and if the records are transmitted successfully, the incoming flow file is routed to success.  The type of statement executed by the processor is specified via the Statement Type property, which accepts some hard-coded values such as INSERT, UPDATE, and DELETE, as well as 'Use statement.type Attribute', which causes the processor to get the statement type from a flow file attribute.  IMPORTANT: If the Statement Type is UPDATE, then the incoming records must not alter the value(s) of the primary keys (or user-specified Update Keys). If such records are encountered, the UPDATE statement issued to the database may do nothing (if no existing records with the new primary key values are found), or could inadvertently corrupt the existing data (by changing records for which the new values of the primary keys exist).")
@ReadsAttribute(attribute="statement.type", description="If 'Use statement.type Attribute' is selected for the Statement Type property, the value of this attribute will be used to determine the type of statement (INSERT, UPDATE, DELETE, SQL, etc.) to generate and execute.")
@WritesAttribute(attribute="putdatabaserecord.error", description="If an error occurs during processing, the flow file will be routed to failure or retry, and this attribute will be populated with the cause of the error.")
@UseCase(description="Insert records into a database")
public class PutDatabaseRecord
extends AbstractProcessor {
    public static final String UPDATE_TYPE = "UPDATE";
    public static final String INSERT_TYPE = "INSERT";
    public static final String DELETE_TYPE = "DELETE";
    public static final String UPSERT_TYPE = "UPSERT";
    public static final String INSERT_IGNORE_TYPE = "INSERT_IGNORE";
    public static final String SQL_TYPE = "SQL";
    public static final String USE_ATTR_TYPE = "Use statement.type Attribute";
    public static final String USE_RECORD_PATH = "Use Record Path";
    static final String STATEMENT_TYPE_ATTRIBUTE = "statement.type";
    static final String PUT_DATABASE_RECORD_ERROR = "putdatabaserecord.error";
    static final AllowableValue IGNORE_UNMATCHED_FIELD = new AllowableValue("Ignore Unmatched Fields", "Ignore Unmatched Fields", "Any field in the document that cannot be mapped to a column in the database is ignored");
    static final AllowableValue FAIL_UNMATCHED_FIELD = new AllowableValue("Fail on Unmatched Fields", "Fail on Unmatched Fields", "If the document has any field that cannot be mapped to a column in the database, the FlowFile will be routed to the failure relationship");
    static final AllowableValue IGNORE_UNMATCHED_COLUMN = new AllowableValue("Ignore Unmatched Columns", "Ignore Unmatched Columns", "Any column in the database that does not have a field in the document will be assumed to not be required.  No notification will be logged");
    static final AllowableValue WARNING_UNMATCHED_COLUMN = new AllowableValue("Warn on Unmatched Columns", "Warn on Unmatched Columns", "Any column in the database that does not have a field in the document will be assumed to not be required.  A warning will be logged");
    static final AllowableValue FAIL_UNMATCHED_COLUMN = new AllowableValue("Fail on Unmatched Columns", "Fail on Unmatched Columns", "A flow will fail if any column in the database that does not have a field in the document.  An error will be logged");
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("A FlowFile is routed to this relationship if the database cannot be updated but attempting the operation again may succeed").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if the database cannot be updated and retrying the operation will also fail, such as an invalid query or an integrity constraint violation").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_RETRY);
    static final PropertyDescriptor RECORD_READER_FACTORY = new PropertyDescriptor.Builder().name("put-db-record-record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor STATEMENT_TYPE = new PropertyDescriptor.Builder().name("put-db-record-statement-type").displayName("Statement Type").description("Specifies the type of SQL Statement to generate. Please refer to the database documentation for a description of the behavior of each operation. Please note that some Database Types may not support certain Statement Types. If 'Use statement.type Attribute' is chosen, then the value is taken from the statement.type attribute in the FlowFile. The 'Use statement.type Attribute' option is the only one that allows the 'SQL' statement type. If 'SQL' is specified, the value of the field specified by the 'Field Containing SQL' property is expected to be a valid SQL statement on the target database, and will be executed as-is.").required(true).allowableValues(new String[]{"UPDATE", "INSERT", "UPSERT", "INSERT_IGNORE", "DELETE", "Use statement.type Attribute", "Use Record Path"}).build();
    static final PropertyDescriptor STATEMENT_TYPE_RECORD_PATH = new PropertyDescriptor.Builder().name("Statement Type Record Path").displayName("Statement Type Record Path").description("Specifies a RecordPath to evaluate against each Record in order to determine the Statement Type. The RecordPath should equate to either INSERT, UPDATE, UPSERT, or DELETE. (Debezium style operation types are also supported: \"r\" and \"c\" for INSERT, \"u\" for UPDATE, and \"d\" for DELETE)").required(true).addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(STATEMENT_TYPE, "Use Record Path", new String[0]).build();
    static final PropertyDescriptor DATA_RECORD_PATH = new PropertyDescriptor.Builder().name("Data Record Path").displayName("Data Record Path").description("If specified, this property denotes a RecordPath that will be evaluated against each incoming Record and the Record that results from evaluating the RecordPath will be sent to the database instead of sending the entire incoming Record. If not specified, the entire incoming Record will be published to the database.").required(false).addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("put-db-record-dcbp-service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database for sending records.").required(true).identifiesControllerService(DBCPService.class).build();
    static final PropertyDescriptor CATALOG_NAME = new PropertyDescriptor.Builder().name("put-db-record-catalog-name").displayName("Catalog Name").description("The name of the catalog that the statement should update. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the catalog name must match the database's catalog name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SCHEMA_NAME = new PropertyDescriptor.Builder().name("put-db-record-schema-name").displayName("Schema Name").description("The name of the schema that the table belongs to. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the schema name must match the database's schema name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("put-db-record-table-name").displayName("Table Name").description("The name of the table that the statement should affect. Note that if the database is case-sensitive, the table name must match the database's table name exactly.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final AllowableValue BINARY_STRING_FORMAT_UTF8 = new AllowableValue("UTF-8", "UTF-8", "String values for binary columns contain the original value as text via UTF-8 character encoding");
    static final AllowableValue BINARY_STRING_FORMAT_HEXADECIMAL = new AllowableValue("Hexadecimal", "Hexadecimal", "String values for binary columns contain the original value in hexadecimal format");
    static final AllowableValue BINARY_STRING_FORMAT_BASE64 = new AllowableValue("Base64", "Base64", "String values for binary columns contain the original value in Base64 encoded format");
    static final PropertyDescriptor BINARY_STRING_FORMAT = new PropertyDescriptor.Builder().name("put-db-record-binary-format").displayName("Binary String Format").description("The format to be applied when decoding string values to binary.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).allowableValues(new DescribedValue[]{BINARY_STRING_FORMAT_UTF8, BINARY_STRING_FORMAT_HEXADECIMAL, BINARY_STRING_FORMAT_BASE64}).defaultValue((DescribedValue)BINARY_STRING_FORMAT_UTF8).build();
    static final PropertyDescriptor TRANSLATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("put-db-record-translate-field-names").displayName("Translate Field Names").description("If true, the Processor will attempt to translate field names into the appropriate column names for the table specified. If false, the field names must match the column names exactly, or the column will not be updated").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor TRANSLATION_STRATEGY = new PropertyDescriptor.Builder().required(true).name("Column Name Translation Strategy").description("The strategy used to normalize table column name. Column Name will be uppercased to do case-insensitive matching irrespective of strategy").allowableValues(TranslationStrategy.class).defaultValue((DescribedValue)TranslationStrategy.REMOVE_UNDERSCORE).dependsOn(TRANSLATE_FIELD_NAMES, "true", new String[0]).build();
    public static final PropertyDescriptor TRANSLATION_PATTERN = new PropertyDescriptor.Builder().required(true).name("Column Name Translation Pattern").description("Column name will be normalized with this regular expression").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).dependsOn(TRANSLATION_STRATEGY, (DescribedValue)TranslationStrategy.PATTERN, new DescribedValue[0]).build();
    static final PropertyDescriptor UNMATCHED_FIELD_BEHAVIOR = new PropertyDescriptor.Builder().name("put-db-record-unmatched-field-behavior").displayName("Unmatched Field Behavior").description("If an incoming record has a field that does not map to any of the database table's columns, this property specifies how to handle the situation").allowableValues(new DescribedValue[]{IGNORE_UNMATCHED_FIELD, FAIL_UNMATCHED_FIELD}).defaultValue((DescribedValue)IGNORE_UNMATCHED_FIELD).build();
    static final PropertyDescriptor UNMATCHED_COLUMN_BEHAVIOR = new PropertyDescriptor.Builder().name("put-db-record-unmatched-column-behavior").displayName("Unmatched Column Behavior").description("If an incoming record does not have a field mapping for all of the database table's columns, this property specifies how to handle the situation").allowableValues(new DescribedValue[]{IGNORE_UNMATCHED_COLUMN, WARNING_UNMATCHED_COLUMN, FAIL_UNMATCHED_COLUMN}).defaultValue((DescribedValue)FAIL_UNMATCHED_COLUMN).build();
    static final PropertyDescriptor UPDATE_KEYS = new PropertyDescriptor.Builder().name("put-db-record-update-keys").displayName("Update Keys").description("A comma-separated list of column names that uniquely identifies a row in the database for UPDATE statements. If the Statement Type is UPDATE and this property is not set, the table's Primary Keys are used. In this case, if no Primary Key exists, the conversion to SQL will fail if Unmatched Column Behaviour is set to FAIL. This property is ignored if the Statement Type is INSERT").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(STATEMENT_TYPE, "UPDATE", new String[]{"UPSERT", "SQL", "Use statement.type Attribute", "Use Record Path"}).build();
    static final PropertyDescriptor DELETE_KEYS = new PropertyDescriptor.Builder().name("Delete Keys").description("A comma-separated list of column names that uniquely identifies a row in the database for DELETE statements. If the Statement Type is DELETE and this property is not set, the table's columns are used. This property is ignored if the Statement Type is not DELETE").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(STATEMENT_TYPE, "DELETE", new String[]{"SQL", "Use statement.type Attribute", "Use Record Path"}).build();
    static final PropertyDescriptor FIELD_CONTAINING_SQL = new PropertyDescriptor.Builder().name("put-db-record-field-containing-sql").displayName("Field Containing SQL").description("If the Statement Type is 'SQL' (as set in the statement.type attribute), this field indicates which field in the record(s) contains the SQL statement to execute. The value of the field must be a single SQL statement. If the Statement Type is not 'SQL', this field is ignored.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(STATEMENT_TYPE, "Use statement.type Attribute", new String[]{"Use Record Path"}).build();
    static final PropertyDescriptor ALLOW_MULTIPLE_STATEMENTS = new PropertyDescriptor.Builder().name("put-db-record-allow-multiple-statements").displayName("Allow Multiple SQL Statements").description("If the Statement Type is 'SQL' (as set in the statement.type attribute), this field indicates whether to split the field value by a semicolon and execute each statement separately. If any statement causes an error, the entire set of statements will be rolled back. If the Statement Type is not 'SQL', this field is ignored.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").dependsOn(STATEMENT_TYPE, "Use statement.type Attribute", new String[]{"Use Record Path"}).build();
    static final PropertyDescriptor QUOTE_IDENTIFIERS = new PropertyDescriptor.Builder().name("put-db-record-quoted-identifiers").displayName("Quote Column Identifiers").description("Enabling this option will cause all column names to be quoted, allowing you to use reserved words as column names in your tables.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUOTE_TABLE_IDENTIFIER = new PropertyDescriptor.Builder().name("put-db-record-quoted-table-identifiers").displayName("Quote Table Identifiers").description("Enabling this option will cause the table name to be quoted to support the use of special characters in the table name.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("put-db-record-query-timeout").displayName("Max Wait Time").description("The maximum amount of time allowed for a running SQL statement , zero means there is no limit. Max time less than 1 second will be equal to zero.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor TABLE_SCHEMA_CACHE_SIZE = new PropertyDescriptor.Builder().name("table-schema-cache-size").displayName("Table Schema Cache Size").description("Specifies how many Table Schemas should be cached").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("100").required(true).build();
    static final PropertyDescriptor MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("put-db-record-max-batch-size").displayName("Maximum Batch Size").description("Specifies maximum number of sql statements to be included in each batch sent to the database. Zero means the batch size is not limited, and all statements are put into a single batch which can cause high memory usage issues for a very large number of statements.").defaultValue("1000").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor AUTO_COMMIT = new PropertyDescriptor.Builder().name("database-session-autocommit").displayName("Database Session AutoCommit").description("The autocommit mode to set on the database connection being used. If set to false, the operation(s) will be explicitly committed or rolled back (based on success or failure respectively). If set to true, the driver/database automatically handles the commit/rollback.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(false).build();
    static final PropertyDescriptor DB_TYPE = DatabaseAdapterDescriptor.getDatabaseTypeDescriptor("db-type");
    static final PropertyDescriptor DATABASE_DIALECT_SERVICE = DatabaseAdapterDescriptor.getDatabaseDialectServiceDescriptor(DB_TYPE);
    protected static final List<PropertyDescriptor> properties = List.of(RECORD_READER_FACTORY, DB_TYPE, DATABASE_DIALECT_SERVICE, STATEMENT_TYPE, STATEMENT_TYPE_RECORD_PATH, DATA_RECORD_PATH, DBCP_SERVICE, CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, BINARY_STRING_FORMAT, TRANSLATE_FIELD_NAMES, TRANSLATION_STRATEGY, TRANSLATION_PATTERN, UNMATCHED_FIELD_BEHAVIOR, UNMATCHED_COLUMN_BEHAVIOR, UPDATE_KEYS, DELETE_KEYS, FIELD_CONTAINING_SQL, ALLOW_MULTIPLE_STATEMENTS, QUOTE_IDENTIFIERS, QUOTE_TABLE_IDENTIFIER, QUERY_TIMEOUT, RollbackOnFailure.ROLLBACK_ON_FAILURE, TABLE_SCHEMA_CACHE_SIZE, MAX_BATCH_SIZE, AUTO_COMMIT);
    private Cache<SchemaKey, TableSchema> schemaCache;
    private volatile DatabaseDialectService databaseDialectService;
    private volatile Function<Record, String> recordPathOperationType;
    private volatile RecordPath dataRecordPath;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String databaseType = validationContext.getProperty(DB_TYPE).getValue();
        DatabaseDialectService dialectService = DatabaseAdapterDescriptor.getDatabaseDialectService((PropertyContext)validationContext, DATABASE_DIALECT_SERVICE, databaseType);
        Set supportedStatementTypes = dialectService.getSupportedStatementTypes();
        String configuredStatementType = validationContext.getProperty(STATEMENT_TYPE).getValue();
        if (INSERT_IGNORE_TYPE.equals(configuredStatementType) && !supportedStatementTypes.contains(StatementType.INSERT_IGNORE)) {
            validationResults.add(new ValidationResult.Builder().subject(STATEMENT_TYPE.getDisplayName()).valid(false).explanation("INSERT IGNORE not supported with Database Dialect").build());
        }
        if (UPSERT_TYPE.equals(configuredStatementType) && !supportedStatementTypes.contains(StatementType.UPSERT)) {
            validationResults.add(new ValidationResult.Builder().subject(STATEMENT_TYPE.getDisplayName()).valid(false).explanation("UPSERT not supported with Database Dialect").build());
        }
        Boolean autoCommit = validationContext.getProperty(AUTO_COMMIT).asBoolean();
        boolean rollbackOnFailure = validationContext.getProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE).asBoolean();
        if (autoCommit != null && autoCommit.booleanValue() && rollbackOnFailure) {
            validationResults.add(new ValidationResult.Builder().subject(RollbackOnFailure.ROLLBACK_ON_FAILURE.getDisplayName()).explanation(String.format("'%s' cannot be set to 'true' when '%s' is also set to 'true'. Transaction rollbacks for batch updates cannot rollback all the flow file's statements together when auto commit is set to 'true' because the database autocommits each batch separately.", RollbackOnFailure.ROLLBACK_ON_FAILURE.getDisplayName(), AUTO_COMMIT.getDisplayName())).build());
        }
        if (autoCommit != null && autoCommit.booleanValue() && !this.isMaxBatchSizeHardcodedToZero(validationContext)) {
            String explanation = String.format("'%s' must be hard-coded to zero when '%s' is set to 'true'. Batch size equal to zero executes all statements in a single transaction which allows rollback to revert all the flow file's statements together if an error occurs.", MAX_BATCH_SIZE.getDisplayName(), AUTO_COMMIT.getDisplayName());
            validationResults.add(new ValidationResult.Builder().subject(MAX_BATCH_SIZE.getDisplayName()).explanation(explanation).build());
        }
        return validationResults;
    }

    private boolean isMaxBatchSizeHardcodedToZero(ValidationContext validationContext) {
        try {
            return !validationContext.getProperty(MAX_BATCH_SIZE).isExpressionLanguagePresent() && 0 == validationContext.getProperty(MAX_BATCH_SIZE).asInteger();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        String databaseType = context.getProperty(DB_TYPE).getValue();
        this.databaseDialectService = DatabaseAdapterDescriptor.getDatabaseDialectService((PropertyContext)context, DATABASE_DIALECT_SERVICE, databaseType);
        int tableSchemaCacheSize = context.getProperty(TABLE_SCHEMA_CACHE_SIZE).asInteger();
        this.schemaCache = Caffeine.newBuilder().maximumSize((long)tableSchemaCacheSize).build();
        if (context.getProperty(STATEMENT_TYPE).getValue().equals(USE_RECORD_PATH)) {
            String statementTypeRecordPathValue = context.getProperty(STATEMENT_TYPE_RECORD_PATH).getValue();
            RecordPath recordPath = RecordPath.compile((String)statementTypeRecordPathValue);
            this.recordPathOperationType = new RecordPathStatementType(recordPath);
        } else {
            this.recordPathOperationType = null;
        }
        String dataRecordPathValue = context.getProperty(DATA_RECORD_PATH).getValue();
        this.dataRecordPath = dataRecordPathValue == null ? null : RecordPath.compile((String)dataRecordPathValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = dbcpService.getConnection(flowFile.getAttributes());
            originalAutoCommit = connection.getAutoCommit();
            Boolean propertyAutoCommitValue = context.getProperty(AUTO_COMMIT).asBoolean();
            if (propertyAutoCommitValue != null && originalAutoCommit != propertyAutoCommitValue) {
                try {
                    connection.setAutoCommit(propertyAutoCommitValue);
                }
                catch (Exception ex) {
                    this.getLogger().debug("Failed to setAutoCommit({}) due to {}", new Object[]{propertyAutoCommitValue, ex.getClass().getName(), ex});
                }
            }
            this.putToDatabase(context, session, flowFile, connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            session.transfer(flowFile, REL_SUCCESS);
            session.getProvenanceReporter().send(flowFile, this.getJdbcUrl(connection));
        }
        catch (Exception e) {
            this.routeOnException(context, session, connection, e, flowFile);
        }
        finally {
            this.closeConnection(connection, originalAutoCommit);
        }
    }

    private void routeOnException(ProcessContext context, ProcessSession session, Connection connection, Exception e, FlowFile flowFile) {
        Relationship relationship;
        Throwable toAnalyze;
        Throwable throwable = toAnalyze = e instanceof BatchUpdateException || e instanceof ProcessException ? e.getCause() : e;
        if (toAnalyze instanceof SQLTransientException) {
            relationship = REL_RETRY;
            flowFile = session.penalize(flowFile);
        } else {
            relationship = REL_FAILURE;
        }
        boolean rollbackOnFailure = context.getProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE).asBoolean();
        if (rollbackOnFailure) {
            this.getLogger().error("Failed to put Records to database for {}. Rolling back NiFi session and returning the flow file to its incoming queue.", new Object[]{flowFile, e});
            session.rollback();
            context.yield();
        } else {
            this.getLogger().error("Failed to put Records to database for {}. Routing to {}.", new Object[]{flowFile, relationship, e});
            flowFile = session.putAttribute(flowFile, PUT_DATABASE_RECORD_ERROR, e.getMessage() == null ? "Unknown" : e.getMessage());
            session.transfer(flowFile, relationship);
        }
        this.rollbackConnection(connection);
    }

    private void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                    this.getLogger().debug("Manually rolled back JDBC transaction.");
                }
            }
            catch (Exception rollbackException) {
                this.getLogger().error("Failed to rollback JDBC transaction", (Throwable)rollbackException);
            }
        }
    }

    private void closeConnection(Connection connection, boolean originalAutoCommit) {
        if (connection != null) {
            try {
                if (originalAutoCommit != connection.getAutoCommit()) {
                    connection.setAutoCommit(originalAutoCommit);
                }
            }
            catch (Exception autoCommitException) {
                this.getLogger().warn("Failed to set auto-commit back to {} on connection", new Object[]{originalAutoCommit, autoCommitException});
            }
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (Exception closeException) {
                this.getLogger().warn("Failed to close database connection", (Throwable)closeException);
            }
        }
    }

    private void executeSQL(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection connection, RecordReader recordReader) throws IllegalArgumentException, MalformedRecordException, IOException, SQLException {
        RecordSchema recordSchema = recordReader.getSchema();
        String sqlField = context.getProperty(FIELD_CONTAINING_SQL).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)sqlField)) {
            throw new IllegalArgumentException(String.format("SQL specified as Statement Type but no Field Containing SQL was found, FlowFile %s", flowFile));
        }
        boolean schemaHasSqlField = recordSchema.getFields().stream().anyMatch(field -> sqlField.equals(field.getFieldName()));
        if (!schemaHasSqlField) {
            throw new IllegalArgumentException(String.format("Record schema does not contain Field Containing SQL: %s, FlowFile %s", sqlField, flowFile));
        }
        try (Statement statement = connection.createStatement();){
            block19: {
                int timeoutMillis = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
                try {
                    statement.setQueryTimeout(timeoutMillis);
                }
                catch (SQLException se) {
                    if (timeoutMillis <= 0) break block19;
                    throw se;
                }
            }
            ComponentLog log = this.getLogger();
            int maxBatchSize = context.getProperty(MAX_BATCH_SIZE).evaluateAttributeExpressions(flowFile).asInteger();
            boolean useBatch = maxBatchSize != 1 && this.isSupportsBatchUpdates(connection);
            int currentBatchSize = 0;
            int batchIndex = 0;
            boolean isFirstRecord = true;
            Record nextRecord = recordReader.nextRecord();
            while (nextRecord != null) {
                String[] sqlStatements;
                Record currentRecord = nextRecord;
                String sql = currentRecord.getAsString(sqlField);
                nextRecord = recordReader.nextRecord();
                if (sql == null || StringUtils.isEmpty((CharSequence)sql)) {
                    throw new MalformedRecordException(String.format("Record had no (or null) value for Field Containing SQL: %s, FlowFile %s", sqlField, flowFile));
                }
                if (context.getProperty(ALLOW_MULTIPLE_STATEMENTS).asBoolean().booleanValue()) {
                    String regex = "(?<!\\\\);";
                    sqlStatements = sql.split("(?<!\\\\);");
                } else {
                    sqlStatements = new String[]{sql};
                }
                if (isFirstRecord) {
                    if (nextRecord == null && sqlStatements.length == 1) {
                        useBatch = false;
                    }
                    isFirstRecord = false;
                }
                for (String sqlStatement : sqlStatements) {
                    if (useBatch) {
                        ++currentBatchSize;
                        statement.addBatch(sqlStatement);
                        continue;
                    }
                    statement.execute(sqlStatement);
                }
                if (!useBatch || maxBatchSize <= 0 || currentBatchSize < maxBatchSize) continue;
                log.debug("Executing batch with last query {} because batch reached max size %s for {}; batch index: {}; batch size: {}", new Object[]{sql, maxBatchSize, flowFile, ++batchIndex, currentBatchSize});
                statement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
                currentBatchSize = 0;
            }
            if (useBatch && currentBatchSize > 0) {
                log.debug("Executing last batch because last statement reached for {}; batch index: {}; batch size: {}", new Object[]{flowFile, ++batchIndex, currentBatchSize});
                statement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDML(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection con, RecordReader recordReader, String explicitStatementType, DMLSettings settings) throws IllegalArgumentException, MalformedRecordException, IOException, SQLException {
        TableSchema tableSchema;
        ComponentLog log = this.getLogger();
        String configuredStatementType = context.getProperty(STATEMENT_TYPE).getValue();
        String catalog = context.getProperty(CATALOG_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String schemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String updateKeys = switch (configuredStatementType) {
            case UPDATE_TYPE, UPSERT_TYPE, SQL_TYPE, USE_ATTR_TYPE, USE_RECORD_PATH -> context.getProperty(UPDATE_KEYS).evaluateAttributeExpressions(flowFile).getValue();
            default -> null;
        };
        String deleteKeys = switch (configuredStatementType) {
            case DELETE_TYPE, SQL_TYPE, USE_ATTR_TYPE, USE_RECORD_PATH -> context.getProperty(DELETE_KEYS).evaluateAttributeExpressions(flowFile).getValue();
            default -> null;
        };
        int maxBatchSize = context.getProperty(MAX_BATCH_SIZE).evaluateAttributeExpressions(flowFile).asInteger();
        int timeoutMillis = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        String binaryStringFormat = context.getProperty(BINARY_STRING_FORMAT).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException(String.format("Cannot process %s because Table Name is null or empty", flowFile));
        }
        NameNormalizer normalizer = Optional.of(settings).filter(s -> s.translateFieldNames).map(s -> NameNormalizerFactory.getNormalizer(s.translationStrategy, s.translationPattern)).orElse(null);
        SchemaKey schemaKey = new SchemaKey(catalog, schemaName, tableName);
        try {
            tableSchema = (TableSchema)this.schemaCache.get((Object)schemaKey, key -> {
                try {
                    TableSchema schema = TableSchema.from(con, catalog, schemaName, tableName, settings.translateFieldNames, normalizer, updateKeys, log);
                    this.getLogger().debug("Fetched Table Schema {} for table name {}", new Object[]{schema, tableName});
                    return schema;
                }
                catch (SQLException e) {
                    throw new ProcessException((Throwable)e);
                }
            });
            if (tableSchema == null) {
                throw new IllegalArgumentException("No table schema specified!");
            }
        }
        catch (ProcessException pe) {
            if (pe.getCause() instanceof SQLException) {
                throw (SQLException)pe.getCause();
            }
            throw pe;
        }
        String fqTableName = this.generateTableName(settings, catalog, schemaName, tableName, tableSchema);
        HashMap<String, PreparedSqlAndColumns> preparedSql = new HashMap<String, PreparedSqlAndColumns>();
        int currentBatchSize = 0;
        int batchIndex = 0;
        Statement lastPreparedStatement = null;
        try {
            Record outerRecord;
            while ((outerRecord = recordReader.nextRecord()) != null) {
                String statementType = USE_RECORD_PATH.equalsIgnoreCase(explicitStatementType) ? this.recordPathOperationType.apply(outerRecord) : explicitStatementType;
                List<Record> dataRecords = this.getDataRecords(outerRecord);
                for (Record currentRecord : dataRecords) {
                    PreparedSqlAndColumns preparedSqlAndColumns = (PreparedSqlAndColumns)preparedSql.get(statementType);
                    if (preparedSqlAndColumns == null) {
                        PreparedStatement preparedStatement;
                        SqlAndIncludedColumns sqlHolder;
                        block67: {
                            RecordSchema recordSchema = currentRecord.getSchema();
                            if (INSERT_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateInsert(recordSchema, fqTableName, tableSchema, settings, normalizer);
                            } else if (UPDATE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateUpdate(recordSchema, fqTableName, updateKeys, tableSchema, settings, normalizer);
                            } else if (DELETE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateDelete(recordSchema, fqTableName, deleteKeys, tableSchema, settings, normalizer);
                            } else if (UPSERT_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.getSqlStatement(StatementType.UPSERT, recordSchema, fqTableName, updateKeys, tableSchema, settings, normalizer);
                            } else if (INSERT_IGNORE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.getSqlStatement(StatementType.INSERT_IGNORE, recordSchema, fqTableName, updateKeys, tableSchema, settings, normalizer);
                            } else {
                                throw new IllegalArgumentException(String.format("Statement Type %s is not valid, FlowFile %s", statementType, flowFile));
                            }
                            log.debug("Generated SQL: {}", new Object[]{sqlHolder.getSql()});
                            preparedStatement = con.prepareStatement(sqlHolder.getSql());
                            try {
                                preparedStatement.setQueryTimeout(timeoutMillis);
                            }
                            catch (SQLException se) {
                                if (timeoutMillis <= 0) break block67;
                                throw se;
                            }
                        }
                        int parameterCount = this.getParameterCount(sqlHolder.sql);
                        preparedSqlAndColumns = new PreparedSqlAndColumns(sqlHolder, preparedStatement, parameterCount);
                        preparedSql.put(statementType, preparedSqlAndColumns);
                    }
                    PreparedStatement ps = preparedSqlAndColumns.getPreparedStatement();
                    List<Integer> fieldIndexes = preparedSqlAndColumns.getSqlAndIncludedColumns().getFieldIndexes();
                    String sql = preparedSqlAndColumns.getSqlAndIncludedColumns().getSql();
                    if (ps != lastPreparedStatement && lastPreparedStatement != null) {
                        log.debug("Executing query {} because Statement Type changed between Records for {}; fieldIndexes: {}; batch index: {}; batch size: {}", new Object[]{sql, flowFile, fieldIndexes, ++batchIndex, currentBatchSize});
                        lastPreparedStatement.executeBatch();
                        session.adjustCounter("Batches Executed", 1L, false);
                        currentBatchSize = 0;
                    }
                    lastPreparedStatement = ps;
                    Object[] values = currentRecord.getValues();
                    List dataTypes = currentRecord.getSchema().getDataTypes();
                    RecordSchema recordSchema = currentRecord.getSchema();
                    Map<String, ColumnDescription> columns = tableSchema.getColumns();
                    int deleteIndex = 0;
                    for (int i = 0; i < fieldIndexes.size(); ++i) {
                        int sqlType;
                        int currentFieldIndex = fieldIndexes.get(i);
                        Object currentValue = values[currentFieldIndex];
                        DataType dataType = (DataType)dataTypes.get(currentFieldIndex);
                        int fieldSqlType = DataTypeUtils.getSQLTypeValue((DataType)dataType);
                        String fieldName = recordSchema.getField(currentFieldIndex).getFieldName();
                        String columnName = TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer);
                        ColumnDescription column = columns.get(columnName);
                        if (column == null) {
                            if (!settings.ignoreUnmappedFields) {
                                throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", columns.keySet()));
                            }
                            sqlType = fieldSqlType;
                        } else {
                            sqlType = column.getDataType();
                            if (sqlType == -150) {
                                sqlType = -156;
                            }
                        }
                        if (fieldSqlType != sqlType) {
                            try {
                                DataType targetDataType = DataTypeUtils.getDataTypeFromSQLTypeValue((int)sqlType);
                                if (targetDataType == null) {
                                    targetDataType = DataTypeUtils.getDataTypeFromSQLTypeValue((int)fieldSqlType);
                                }
                                if (targetDataType != null) {
                                    if (sqlType == 2004 || sqlType == -2 || sqlType == -3 || sqlType == -4) {
                                        if (currentValue instanceof Object[]) {
                                            Object[] src = (Object[])currentValue;
                                            if (src.length > 0 && !(src[0] instanceof Byte)) {
                                                throw new IllegalTypeConversionException("Cannot convert value " + String.valueOf(currentValue) + " to BLOB/BINARY/VARBINARY/LONGVARBINARY");
                                            }
                                            byte[] dest = new byte[src.length];
                                            for (int j = 0; j < src.length; ++j) {
                                                dest[j] = (Byte)src[j];
                                            }
                                            currentValue = dest;
                                        } else if (currentValue instanceof String) {
                                            String stringValue = (String)currentValue;
                                            currentValue = BINARY_STRING_FORMAT_BASE64.getValue().equals(binaryStringFormat) ? (Object)Base64.getDecoder().decode(stringValue) : (BINARY_STRING_FORMAT_HEXADECIMAL.getValue().equals(binaryStringFormat) ? (Object)HexFormat.of().parseHex(stringValue) : (Object)stringValue.getBytes(StandardCharsets.UTF_8));
                                        } else if (currentValue != null && !(currentValue instanceof byte[])) {
                                            throw new IllegalTypeConversionException("Cannot convert value " + String.valueOf(currentValue) + " to BLOB/BINARY/VARBINARY/LONGVARBINARY");
                                        }
                                    } else {
                                        currentValue = DataTypeUtils.convertType((Object)currentValue, (DataType)targetDataType, (String)fieldName);
                                    }
                                }
                            }
                            catch (IllegalTypeConversionException itce) {
                                sqlType = DataTypeUtils.getSQLTypeValue((DataType)dataType);
                            }
                        }
                        if (DELETE_TYPE.equalsIgnoreCase(statementType)) {
                            this.setParameter(ps, ++deleteIndex, currentValue, fieldSqlType, sqlType);
                            if (column == null || !column.isNullable()) continue;
                            this.setParameter(ps, ++deleteIndex, currentValue, fieldSqlType, sqlType);
                            continue;
                        }
                        if (UPSERT_TYPE.equalsIgnoreCase(statementType)) {
                            int timesToAddObjects = preparedSqlAndColumns.parameterCount / fieldIndexes.size();
                            for (int j = 0; j < timesToAddObjects; ++j) {
                                this.setParameter(ps, i + fieldIndexes.size() * j + 1, currentValue, fieldSqlType, sqlType);
                            }
                            continue;
                        }
                        this.setParameter(ps, i + 1, currentValue, fieldSqlType, sqlType);
                    }
                    ps.addBatch();
                    session.adjustCounter(statementType + " updates performed", 1L, false);
                    if (++currentBatchSize != maxBatchSize) continue;
                    log.debug("Executing query {} because batch reached max size for {}; fieldIndexes: {}; batch index: {}; batch size: {}", new Object[]{sql, flowFile, fieldIndexes, ++batchIndex, currentBatchSize});
                    session.adjustCounter("Batches Executed", 1L, false);
                    ps.executeBatch();
                    currentBatchSize = 0;
                }
            }
            if (currentBatchSize > 0) {
                lastPreparedStatement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
            }
        }
        finally {
            for (PreparedSqlAndColumns preparedSqlAndColumns : preparedSql.values()) {
                preparedSqlAndColumns.getPreparedStatement().close();
            }
        }
    }

    private void setParameter(PreparedStatement ps, int index, Object value, int fieldSqlType, int sqlType) throws IOException {
        block46: {
            if (sqlType == 2004) {
                if (fieldSqlType == 2003 || fieldSqlType == 12) {
                    if (!(value instanceof byte[])) {
                        if (value == null) {
                            try {
                                ps.setNull(index, 2004);
                                return;
                            }
                            catch (SQLException e) {
                                throw new IOException("Unable to setNull() on prepared statement", e);
                            }
                        }
                        throw new IOException("Expected BLOB to be of type byte[] but is instead " + value.getClass().getName());
                    }
                    byte[] byteArray = (byte[])value;
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);){
                        ps.setBlob(index, inputStream);
                        break block46;
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data " + String.valueOf(value), e);
                    }
                }
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(value.toString().getBytes(StandardCharsets.UTF_8));){
                    ps.setBlob(index, inputStream);
                    break block46;
                }
                catch (IOException | SQLException e) {
                    throw new IOException("Unable to parse binary data " + String.valueOf(value), e);
                }
            }
            if (sqlType == 2005) {
                if (value == null) {
                    try {
                        ps.setNull(index, 2005);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to setNull() on prepared statement", e);
                    }
                } else {
                    try {
                        Clob clob = ps.getConnection().createClob();
                        clob.setString(1L, value.toString());
                        ps.setClob(index, clob);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse data as CLOB/String " + String.valueOf(value), e);
                    }
                }
            } else if (sqlType == -3 || sqlType == -4) {
                if (fieldSqlType == 2003 || fieldSqlType == 12) {
                    if (!(value instanceof byte[])) {
                        if (value == null) {
                            try {
                                ps.setNull(index, 2004);
                                return;
                            }
                            catch (SQLException e) {
                                throw new IOException("Unable to setNull() on prepared statement", e);
                            }
                        }
                        throw new IOException("Expected VARBINARY/LONGVARBINARY to be of type byte[] but is instead " + value.getClass().getName());
                    }
                    byte[] byteArray = (byte[])value;
                    try {
                        ps.setBytes(index, byteArray);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data with size" + byteArray.length, e);
                    }
                } else {
                    byte[] byteArray = new byte[]{};
                    try {
                        byteArray = value.toString().getBytes(StandardCharsets.UTF_8);
                        ps.setBytes(index, byteArray);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data with size" + byteArray.length, e);
                    }
                }
            } else {
                try {
                    if (fieldSqlType == 1111 && sqlType == 12) {
                        try {
                            ps.setObject(index, value, fieldSqlType);
                        }
                        catch (SQLException e) {
                            ps.setObject(index, value, sqlType);
                        }
                    } else {
                        ps.setObject(index, value, sqlType);
                    }
                }
                catch (SQLException e) {
                    throw new IOException("Unable to setObject() with value " + String.valueOf(value) + " at index " + index + " of type " + sqlType, e);
                }
            }
        }
    }

    private List<Record> getDataRecords(Record outerRecord) {
        if (this.dataRecordPath == null) {
            return List.of(outerRecord);
        }
        RecordPathResult result = this.dataRecordPath.evaluate(outerRecord);
        List fieldValues = result.getSelectedFields().toList();
        if (fieldValues.isEmpty()) {
            throw new ProcessException("RecordPath " + this.dataRecordPath.getPath() + " evaluated against Record yielded no results.");
        }
        for (FieldValue fieldValue : fieldValues) {
            RecordFieldType fieldType = fieldValue.getField().getDataType().getFieldType();
            if (fieldType == RecordFieldType.RECORD) continue;
            throw new ProcessException("RecordPath " + this.dataRecordPath.getPath() + " evaluated against Record expected to return one or more Records but encountered field of type " + String.valueOf(fieldType));
        }
        ArrayList<Record> dataRecords = new ArrayList<Record>(fieldValues.size());
        for (FieldValue fieldValue : fieldValues) {
            dataRecords.add((Record)fieldValue.getValue());
        }
        return dataRecords;
    }

    private String getJdbcUrl(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                return databaseMetaData.getURL();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not determine JDBC URL based on the Driver Connection.", (Throwable)e);
        }
        return "DBCPService";
    }

    private String getStatementType(ProcessContext context, FlowFile flowFile) {
        String statementTypeProperty;
        String statementType = statementTypeProperty = context.getProperty(STATEMENT_TYPE).getValue();
        if (USE_ATTR_TYPE.equals(statementTypeProperty)) {
            statementType = flowFile.getAttribute(STATEMENT_TYPE_ATTRIBUTE);
        }
        return this.validateStatementType(statementType, flowFile);
    }

    private String validateStatementType(String statementType, FlowFile flowFile) {
        if (statementType == null || statementType.trim().isEmpty()) {
            throw new ProcessException("No Statement Type specified for " + String.valueOf(flowFile));
        }
        if (INSERT_TYPE.equalsIgnoreCase(statementType) || UPDATE_TYPE.equalsIgnoreCase(statementType) || DELETE_TYPE.equalsIgnoreCase(statementType) || UPSERT_TYPE.equalsIgnoreCase(statementType) || SQL_TYPE.equalsIgnoreCase(statementType) || USE_RECORD_PATH.equalsIgnoreCase(statementType) || INSERT_IGNORE_TYPE.equalsIgnoreCase(statementType)) {
            return statementType;
        }
        throw new ProcessException("Invalid Statement Type <" + statementType + "> for " + String.valueOf(flowFile));
    }

    private void putToDatabase(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection connection) throws Exception {
        String statementType = this.getStatementType(context, flowFile);
        try (InputStream in = session.read(flowFile);){
            RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER_FACTORY).asControllerService(RecordReaderFactory.class);
            RecordReader recordReader = recordReaderFactory.createRecordReader(flowFile, in, this.getLogger());
            if (SQL_TYPE.equalsIgnoreCase(statementType)) {
                this.executeSQL(context, session, flowFile, connection, recordReader);
            } else {
                DMLSettings settings = new DMLSettings(context);
                this.executeDML(context, session, flowFile, connection, recordReader, statementType, settings);
            }
        }
    }

    String generateTableName(DMLSettings settings, String catalog, String schemaName, String tableName, TableSchema tableSchema) {
        StringBuilder tableNameBuilder = new StringBuilder();
        if (catalog != null) {
            if (settings.quoteTableName) {
                tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(catalog).append(tableSchema.getQuotedIdentifierString());
            } else {
                tableNameBuilder.append(catalog);
            }
            tableNameBuilder.append(".");
        }
        if (schemaName != null) {
            if (settings.quoteTableName) {
                tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(schemaName).append(tableSchema.getQuotedIdentifierString());
            } else {
                tableNameBuilder.append(schemaName);
            }
            tableNameBuilder.append(".");
        }
        if (settings.quoteTableName) {
            tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(tableName).append(tableSchema.getQuotedIdentifierString());
        } else {
            tableNameBuilder.append(tableName);
        }
        return tableNameBuilder.toString();
    }

    private Set<String> getNormalizedColumnNames(RecordSchema schema, boolean translateFieldNames, NameNormalizer normalizer) {
        HashSet<String> normalizedFieldNames = new HashSet<String>();
        if (schema != null) {
            schema.getFieldNames().forEach(fieldName -> normalizedFieldNames.add(TableSchema.normalizedName(fieldName, translateFieldNames, normalizer)));
        }
        return normalizedFieldNames;
    }

    SqlAndIncludedColumns generateInsert(RecordSchema recordSchema, String tableName, TableSchema tableSchema, DMLSettings settings, NameNormalizer normalizer) throws IllegalArgumentException, SQLException {
        this.checkValuesForRequiredColumns(recordSchema, tableSchema, settings, normalizer);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO ");
        sqlBuilder.append(tableName);
        sqlBuilder.append(" (");
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (fieldsFound.getAndIncrement() > 0) {
                        sqlBuilder.append(", ");
                    }
                    if (settings.escapeColumnNames) {
                        sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                    } else {
                        sqlBuilder.append(desc.getColumnName());
                    }
                    includedColumns.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '{}' to any column in the database\n{}Columns: {}", new Object[]{fieldName, settings.translateFieldNames ? "Normalized " : "", String.join((CharSequence)",", tableSchema.getColumns().keySet())});
            }
            sqlBuilder.append(") VALUES (");
            sqlBuilder.append(StringUtils.repeat((String)"?", (String)",", (int)includedColumns.size()));
            sqlBuilder.append(")");
            if (fieldsFound.get() == 0) {
                throw new SQLDataException("None of the fields in the record map to the columns defined by the " + tableName + " table\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    private SqlAndIncludedColumns getSqlStatement(StatementType statementType, RecordSchema recordSchema, String qualifiedTableName, String updateKeys, TableSchema tableSchema, DMLSettings settings, NameNormalizer normalizer) throws MalformedRecordException, SQLDataException, SQLIntegrityConstraintViolationException {
        this.checkValuesForRequiredColumns(recordSchema, tableSchema, settings, normalizer);
        Set<String> keyColumnNames = this.getUpdateKeyColumnNames(qualifiedTableName, updateKeys, tableSchema);
        this.normalizeKeyColumnNamesAndCheckForValues(recordSchema, updateKeys, settings, keyColumnNames, normalizer);
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
        ArrayList<Integer> usedColumnIndices = new ArrayList<Integer>();
        List fieldNames = recordSchema.getFieldNames();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            Object columnName;
            RecordField field = recordSchema.getField(i);
            String fieldName = field.getFieldName();
            String columnNameNormalized = TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer);
            ColumnDescription columnDescription = tableSchema.getColumns().get(columnNameNormalized);
            if (columnDescription == null) {
                if (settings.ignoreUnmappedFields) continue;
                String tableColumnNames = String.join((CharSequence)",", tableSchema.getColumns().keySet());
                String message = "Record Field [%s] not mapped to Table Columns [%s]".formatted(fieldName, tableColumnNames);
                throw new SQLDataException(message);
            }
            if (settings.escapeColumnNames) {
                String quotedIdentifier = tableSchema.getQuotedIdentifierString();
                columnName = quotedIdentifier + columnDescription.getColumnName() + quotedIdentifier;
            } else {
                columnName = columnDescription.getColumnName();
            }
            ColumnDefinition columnDefinition = this.getColumnDefinition(columnDescription, keyColumnNames, (String)columnName);
            columnDefinitions.add(columnDefinition);
            usedColumnIndices.add(i);
        }
        TableDefinition tableDefinition = new TableDefinition(Optional.empty(), Optional.empty(), qualifiedTableName, columnDefinitions);
        StandardStatementRequest statementRequest = new StandardStatementRequest(statementType, tableDefinition);
        StatementResponse statementResponse = this.databaseDialectService.getStatement((StatementRequest)statementRequest);
        String sql = statementResponse.sql();
        return new SqlAndIncludedColumns(sql, usedColumnIndices);
    }

    private ColumnDefinition getColumnDefinition(ColumnDescription columnDescription, Set<String> keyColumnNames, String columnName) {
        int dataType = columnDescription.getDataType();
        boolean primaryKey = keyColumnNames.contains(columnDescription.getColumnName());
        ColumnDefinition.Nullable nullable = columnDescription.isNullable() ? ColumnDefinition.Nullable.YES : ColumnDefinition.Nullable.NO;
        return new StandardColumnDefinition(columnName, dataType, nullable, primaryKey);
    }

    SqlAndIncludedColumns generateUpdate(RecordSchema recordSchema, String tableName, String updateKeys, TableSchema tableSchema, DMLSettings settings, NameNormalizer normalizer) throws IllegalArgumentException, MalformedRecordException, SQLException {
        Set<String> keyColumnNames = this.getUpdateKeyColumnNames(tableName, updateKeys, tableSchema);
        Set<String> normalizedKeyColumnNames = this.normalizeKeyColumnNamesAndCheckForValues(recordSchema, updateKeys, settings, keyColumnNames, normalizer);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ");
        sqlBuilder.append(tableName);
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            sqlBuilder.append(" SET ");
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                String normalizedColName = TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer);
                ColumnDescription desc = tableSchema.getColumns().get(TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer));
                if (desc == null) {
                    if (!settings.ignoreUnmappedFields) {
                        throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                    }
                    this.getLogger().debug("Did not map field '{}' to any column in the database\nColumns: {}", new Object[]{fieldName, settings.translateFieldNames ? "Normalized " : "", String.join((CharSequence)",", tableSchema.getColumns().keySet())});
                    continue;
                }
                if (normalizedKeyColumnNames.contains(normalizedColName)) continue;
                if (fieldsFound.getAndIncrement() > 0) {
                    sqlBuilder.append(", ");
                }
                if (settings.escapeColumnNames) {
                    sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                } else {
                    sqlBuilder.append(desc.getColumnName());
                }
                sqlBuilder.append(" = ?");
                includedColumns.add(i);
            }
            AtomicInteger whereFieldCount = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                boolean firstUpdateKey = true;
                String normalizedColName = TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer);
                ColumnDescription desc = tableSchema.getColumns().get(TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer));
                if (desc == null || !normalizedKeyColumnNames.contains(normalizedColName)) continue;
                if (whereFieldCount.getAndIncrement() > 0) {
                    sqlBuilder.append(" AND ");
                } else if (firstUpdateKey) {
                    sqlBuilder.append(" WHERE ");
                    firstUpdateKey = false;
                }
                if (settings.escapeColumnNames) {
                    sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                } else {
                    sqlBuilder.append(desc.getColumnName());
                }
                sqlBuilder.append(" = ?");
                includedColumns.add(i);
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    SqlAndIncludedColumns generateDelete(RecordSchema recordSchema, String tableName, String deleteKeys, TableSchema tableSchema, DMLSettings settings, NameNormalizer normalizer) throws IllegalArgumentException, MalformedRecordException, SQLDataException {
        Set<String> normalizedFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames, normalizer);
        for (String requiredColName : tableSchema.getRequiredColumnNames()) {
            String normalizedColName = TableSchema.normalizedName(requiredColName, settings.translateFieldNames, normalizer);
            if (normalizedFieldNames.contains(normalizedColName)) continue;
            String missingColMessage = "Record does not have a value for the Required column '" + requiredColName + "'";
            if (settings.failUnmappedColumns) {
                this.getLogger().error(missingColMessage);
                throw new MalformedRecordException(missingColMessage);
            }
            if (!settings.warningUnmappedColumns) continue;
            this.getLogger().warn(missingColMessage);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DELETE FROM ");
        sqlBuilder.append(tableName);
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            sqlBuilder.append(" WHERE ");
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            Set<Object> deleteKeysSet = deleteKeys == null ? new HashSet(fieldNames) : Arrays.stream(deleteKeys.split(",")).map(String::trim).collect(Collectors.toSet());
            for (int i = 0; i < fieldCount; ++i) {
                if (!deleteKeysSet.contains(fieldNames.get(i))) continue;
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(TableSchema.normalizedName(fieldName, settings.translateFieldNames, normalizer));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (fieldsFound.getAndIncrement() > 0) {
                        sqlBuilder.append(" AND ");
                    }
                    Object columnName = settings.escapeColumnNames ? tableSchema.getQuotedIdentifierString() + desc.getColumnName() + tableSchema.getQuotedIdentifierString() : desc.getColumnName();
                    sqlBuilder.append("(");
                    sqlBuilder.append((String)columnName);
                    sqlBuilder.append(" = ?");
                    if (desc.isNullable()) {
                        sqlBuilder.append(" OR (");
                        sqlBuilder.append((String)columnName);
                        sqlBuilder.append(" is null AND ? is null))");
                    } else {
                        sqlBuilder.append(")");
                    }
                    includedColumns.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '{}' to any column in the database\n{}Columns: {}", new Object[]{fieldName, settings.translateFieldNames ? "Normalized " : "", String.join((CharSequence)",", tableSchema.getColumns().keySet())});
            }
            if (fieldsFound.get() == 0) {
                throw new SQLDataException("None of the fields in the record map to the columns defined by the " + tableName + " table\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    private void checkValuesForRequiredColumns(RecordSchema recordSchema, TableSchema tableSchema, DMLSettings settings, NameNormalizer normalizer) {
        Set<String> normalizedFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames, normalizer);
        for (String requiredColName : tableSchema.getRequiredColumnNames()) {
            String normalizedColName = TableSchema.normalizedName(requiredColName, settings.translateFieldNames, normalizer);
            if (normalizedFieldNames.contains(normalizedColName)) continue;
            String missingColMessage = "Record does not have a value for the Required column '" + requiredColName + "'";
            if (settings.failUnmappedColumns) {
                this.getLogger().error(missingColMessage);
                throw new IllegalArgumentException(missingColMessage);
            }
            if (!settings.warningUnmappedColumns) continue;
            this.getLogger().warn(missingColMessage);
        }
    }

    private Set<String> getUpdateKeyColumnNames(String tableName, String updateKeys, TableSchema tableSchema) throws SQLIntegrityConstraintViolationException {
        Set<String> updateKeyColumnNames;
        if (updateKeys == null) {
            updateKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        } else {
            updateKeyColumnNames = new HashSet<String>();
            for (String updateKey : updateKeys.split(",")) {
                updateKeyColumnNames.add(updateKey.trim());
            }
        }
        if (updateKeyColumnNames.isEmpty()) {
            throw new SQLIntegrityConstraintViolationException("Table '" + tableName + "' not found or does not have a Primary Key and no Update Keys were specified");
        }
        return updateKeyColumnNames;
    }

    private Set<String> normalizeKeyColumnNamesAndCheckForValues(RecordSchema recordSchema, String updateKeys, DMLSettings settings, Set<String> updateKeyColumnNames, NameNormalizer normalizer) throws MalformedRecordException {
        Set<String> normalizedRecordFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames, normalizer);
        HashSet<String> normalizedKeyColumnNames = new HashSet<String>();
        for (String updateKeyColumnName : updateKeyColumnNames) {
            String normalizedKeyColumnName = TableSchema.normalizedName(updateKeyColumnName, settings.translateFieldNames, normalizer);
            if (!normalizedRecordFieldNames.contains(normalizedKeyColumnName)) {
                String missingColMessage = "Record does not have a value for the " + (updateKeys == null ? "Primary" : "Update") + "Key column '" + updateKeyColumnName + "'";
                if (settings.failUnmappedColumns) {
                    this.getLogger().error(missingColMessage);
                    throw new MalformedRecordException(missingColMessage);
                }
                if (settings.warningUnmappedColumns) {
                    this.getLogger().warn(missingColMessage);
                }
            }
            normalizedKeyColumnNames.add(normalizedKeyColumnName);
        }
        return normalizedKeyColumnNames;
    }

    private boolean isSupportsBatchUpdates(Connection connection) {
        try {
            return connection.getMetaData().supportsBatchUpdates();
        }
        catch (Exception ex) {
            this.getLogger().debug("Exception while testing if connection supportsBatchUpdates", (Throwable)ex);
            return false;
        }
    }

    private int getParameterCount(String sql) {
        int parameterCount = 0;
        for (char character : sql.toCharArray()) {
            if ('?' != character) continue;
            ++parameterCount;
        }
        return parameterCount;
    }

    private static class RecordPathStatementType
    implements Function<Record, String> {
        private final RecordPath recordPath;

        public RecordPathStatementType(RecordPath recordPath) {
            this.recordPath = recordPath;
        }

        @Override
        public String apply(Record record) {
            String resultValue;
            RecordPathResult recordPathResult = this.recordPath.evaluate(record);
            List resultList = recordPathResult.getSelectedFields().distinct().toList();
            if (resultList.isEmpty()) {
                throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record but got no results");
            }
            if (resultList.size() > 1) {
                throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record and received multiple distinct results (" + String.valueOf(resultList) + ")");
            }
            return switch (resultValue = String.valueOf(((FieldValue)resultList.getFirst()).getValue()).toUpperCase()) {
                case PutDatabaseRecord.INSERT_TYPE, PutDatabaseRecord.UPDATE_TYPE, PutDatabaseRecord.DELETE_TYPE, PutDatabaseRecord.UPSERT_TYPE -> resultValue;
                case "C", "R" -> PutDatabaseRecord.INSERT_TYPE;
                case "U" -> PutDatabaseRecord.UPDATE_TYPE;
                case "D" -> PutDatabaseRecord.DELETE_TYPE;
                default -> throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record to determine Statement Type but found invalid value: " + resultValue);
            };
        }
    }

    static class SchemaKey {
        private final String catalog;
        private final String schemaName;
        private final String tableName;

        public SchemaKey(String catalog, String schemaName, String tableName) {
            this.catalog = catalog;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        public int hashCode() {
            int result = this.catalog != null ? this.catalog.hashCode() : 0;
            result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            result = 31 * result + this.tableName.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaKey schemaKey = (SchemaKey)o;
            if (this.catalog != null ? !this.catalog.equals(schemaKey.catalog) : schemaKey.catalog != null) {
                return false;
            }
            if (this.schemaName != null ? !this.schemaName.equals(schemaKey.schemaName) : schemaKey.schemaName != null) {
                return false;
            }
            return this.tableName.equals(schemaKey.tableName);
        }
    }

    static class DMLSettings {
        private final boolean translateFieldNames;
        private final TranslationStrategy translationStrategy;
        private final Pattern translationPattern;
        private final boolean ignoreUnmappedFields;
        private final boolean failUnmappedColumns;
        private final boolean warningUnmappedColumns;
        private final boolean escapeColumnNames;
        private final boolean quoteTableName;

        DMLSettings(ProcessContext context) {
            this.translateFieldNames = context.getProperty(TRANSLATE_FIELD_NAMES).asBoolean();
            this.translationStrategy = this.translateFieldNames ? (TranslationStrategy)context.getProperty(TRANSLATION_STRATEGY).asAllowableValue(TranslationStrategy.class) : null;
            this.translationPattern = this.translationStrategy == TranslationStrategy.PATTERN ? Pattern.compile(context.getProperty(TRANSLATION_PATTERN).getValue()) : null;
            String unmatchedFieldBehavior = context.getProperty(UNMATCHED_FIELD_BEHAVIOR).getValue();
            this.ignoreUnmappedFields = IGNORE_UNMATCHED_FIELD.getValue().equalsIgnoreCase(unmatchedFieldBehavior);
            String unmatchedColumnBehavior = context.getProperty(UNMATCHED_COLUMN_BEHAVIOR).getValue();
            this.failUnmappedColumns = FAIL_UNMATCHED_COLUMN.getValue().equalsIgnoreCase(unmatchedColumnBehavior);
            this.warningUnmappedColumns = WARNING_UNMATCHED_COLUMN.getValue().equalsIgnoreCase(unmatchedColumnBehavior);
            this.escapeColumnNames = context.getProperty(QUOTE_IDENTIFIERS).asBoolean();
            this.quoteTableName = context.getProperty(QUOTE_TABLE_IDENTIFIER).asBoolean();
        }
    }

    static class PreparedSqlAndColumns {
        private final SqlAndIncludedColumns sqlAndIncludedColumns;
        private final PreparedStatement preparedStatement;
        private final int parameterCount;

        public PreparedSqlAndColumns(SqlAndIncludedColumns sqlAndIncludedColumns, PreparedStatement preparedStatement, int parameterCount) {
            this.sqlAndIncludedColumns = sqlAndIncludedColumns;
            this.preparedStatement = preparedStatement;
            this.parameterCount = parameterCount;
        }

        public SqlAndIncludedColumns getSqlAndIncludedColumns() {
            return this.sqlAndIncludedColumns;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }
    }

    static class SqlAndIncludedColumns {
        private final String sql;
        private final List<Integer> fieldIndexes;

        public SqlAndIncludedColumns(String sql, List<Integer> fieldIndexes) {
            this.sql = sql;
            this.fieldIndexes = fieldIndexes;
        }

        public String getSql() {
            return this.sql;
        }

        public List<Integer> getFieldIndexes() {
            return this.fieldIndexes;
        }
    }
}

