/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.datasources.GroupStatusCache;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class ProcessGroupStatusDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("id", String.class, false), new ColumnSchema("groupId", String.class, false), new ColumnSchema("name", String.class, false), new ColumnSchema("bytesRead", Long.TYPE, false), new ColumnSchema("bytesWritten", Long.TYPE, false), new ColumnSchema("bytesReceived", Long.TYPE, false), new ColumnSchema("bytesSent", Long.TYPE, false), new ColumnSchema("bytesTransferred", Long.TYPE, false), new ColumnSchema("flowFilesReceived", Integer.TYPE, false), new ColumnSchema("flowFilesSent", Integer.TYPE, false), new ColumnSchema("flowFilesTransferred", Integer.TYPE, false), new ColumnSchema("inputContentSize", Long.TYPE, false), new ColumnSchema("inputCount", Integer.TYPE, false), new ColumnSchema("outputContentSize", Long.TYPE, false), new ColumnSchema("outputCount", Integer.TYPE, false), new ColumnSchema("queuedCount", Integer.TYPE, false), new ColumnSchema("queuedContentSize", Long.TYPE, false), new ColumnSchema("activeThreadCount", Integer.TYPE, false), new ColumnSchema("terminatedThreadCount", Integer.TYPE, false), new ColumnSchema("versionedFlowState", String.class, false), new ColumnSchema("processingNanos", Long.TYPE, false), new ColumnSchema("cpuDuration", Long.TYPE, false), new ColumnSchema("contentReadDuration", Long.TYPE, false), new ColumnSchema("contentWriteDuration", Long.TYPE, false), new ColumnSchema("sessionCommitDuration", Long.TYPE, false), new ColumnSchema("garbageCollectionDuration", Long.TYPE, false)));
    private final ReportingContext reportingContext;
    private final GroupStatusCache groupStatusCache;
    private ProcessGroupStatus lastFetchedStatus = null;
    private List<GroupStatusAndParentId> lastStatuses = null;

    public ProcessGroupStatusDataSource(ReportingContext reportingContext, GroupStatusCache groupStatusCache) {
        this.reportingContext = reportingContext;
        this.groupStatusCache = groupStatusCache;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        ProcessGroupStatus groupStatus = this.groupStatusCache.getGroupStatus(this.reportingContext);
        List<GroupStatusAndParentId> groupStatuses = groupStatus == this.lastFetchedStatus ? this.lastStatuses : (this.lastStatuses = this.gatherProcessGroupStatuses(groupStatus));
        this.lastFetchedStatus = groupStatus;
        return new IterableRowStream(groupStatuses, this::toArray);
    }

    private List<GroupStatusAndParentId> gatherProcessGroupStatuses(ProcessGroupStatus groupStatus) {
        ArrayList<GroupStatusAndParentId> allStatuses = new ArrayList<GroupStatusAndParentId>();
        this.gatherProcessGroupStatuses(null, groupStatus, allStatuses);
        return allStatuses;
    }

    private void gatherProcessGroupStatuses(String parentGroupId, ProcessGroupStatus groupStatus, List<GroupStatusAndParentId> groupStatuses) {
        groupStatuses.add(new GroupStatusAndParentId(parentGroupId, groupStatus));
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.gatherProcessGroupStatuses(groupStatus.getId(), childStatus, groupStatuses);
        }
    }

    private Object[] toArray(GroupStatusAndParentId groupStatusAndParentId) {
        ProcessGroupStatus status = groupStatusAndParentId.status();
        String parentId = groupStatusAndParentId.parentId();
        return new Object[]{status.getId(), parentId, status.getName(), status.getBytesRead(), status.getBytesWritten(), status.getBytesReceived(), status.getBytesSent(), status.getBytesTransferred(), status.getFlowFilesReceived(), status.getFlowFilesSent(), status.getFlowFilesTransferred(), status.getInputContentSize(), status.getInputCount(), status.getOutputContentSize(), status.getOutputCount(), status.getQueuedContentSize(), status.getActiveThreadCount(), status.getTerminatedThreadCount(), status.getQueuedCount(), status.getVersionedFlowState() == null ? null : status.getVersionedFlowState().name(), status.getProcessingNanos(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getCpuDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getContentReadDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getContentWriteDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getSessionCommitDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getGarbageCollectionDuration()};
    }

    private record GroupStatusAndParentId(String parentId, ProcessGroupStatus status) {
    }
}

