/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snowflake.service.util;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.snowflake.service.util.AccountIdentifierFormatParameters;

public enum AccountIdentifierFormat implements DescribedValue
{
    FULL_URL("full-url", "Full URL", "Provide an account identifier in a single property"){

        @Override
        public String getAccount(AccountIdentifierFormatParameters parameters) {
            String[] hostParts = this.getHostname(parameters).split("\\.");
            if (hostParts.length == 0) {
                throw new IllegalArgumentException("Invalid Snowflake host url");
            }
            return hostParts[0];
        }

        @Override
        public String getHostname(AccountIdentifierFormatParameters parameters) {
            return Objects.requireNonNull(parameters.getHostUrl());
        }
    }
    ,
    ACCOUNT_NAME("account-name", "Account Name", "Provide a Snowflake Account Name"){

        @Override
        public String getAccount(AccountIdentifierFormatParameters parameters) {
            String organizationName = Objects.requireNonNull(parameters.getOrganizationName());
            String accountName = Objects.requireNonNull(parameters.getAccountName());
            return organizationName + "-" + accountName;
        }

        @Override
        public String getHostname(AccountIdentifierFormatParameters parameters) {
            return this.getAccount(parameters) + ".snowflakecomputing.com";
        }
    }
    ,
    ACCOUNT_LOCATOR("account-locator", "Account Locator", "Provide a Snowflake Account Locator"){

        @Override
        public String getAccount(AccountIdentifierFormatParameters parameters) {
            return Objects.requireNonNull(parameters.getAccountLocator());
        }

        @Override
        public String getHostname(AccountIdentifierFormatParameters parameters) {
            String accountLocator = Objects.requireNonNull(parameters.getAccountLocator());
            String cloudRegion = Objects.requireNonNull(parameters.getCloudRegion());
            String optCloudType = parameters.getCloudType();
            StringBuilder hostBuilder = new StringBuilder();
            hostBuilder.append(accountLocator).append(".").append(cloudRegion);
            Optional.ofNullable(optCloudType).ifPresent(cloudType -> hostBuilder.append(".").append((String)cloudType));
            hostBuilder.append(".snowflakecomputing.com");
            return hostBuilder.toString();
        }
    };

    private final String value;
    private final String displayName;
    private final String description;

    private AccountIdentifierFormat(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String getAccount(AccountIdentifierFormatParameters var1);

    public abstract String getHostname(AccountIdentifierFormatParameters var1);
}

